/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a streaming channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamChannelDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamChannelDefinition.Builder, StreamChannelDefinition> {
    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfChannels").getter(getter(StreamChannelDefinition::numberOfChannels))
            .setter(setter(Builder::numberOfChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfChannels").build()).build();

    private static final SdkField<List<ChannelDefinition>> CHANNEL_DEFINITIONS_FIELD = SdkField
            .<List<ChannelDefinition>> builder(MarshallingType.LIST)
            .memberName("ChannelDefinitions")
            .getter(getter(StreamChannelDefinition::channelDefinitions))
            .setter(setter(Builder::channelDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_CHANNELS_FIELD,
            CHANNEL_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NumberOfChannels", NUMBER_OF_CHANNELS_FIELD);
                    put("ChannelDefinitions", CHANNEL_DEFINITIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer numberOfChannels;

    private final List<ChannelDefinition> channelDefinitions;

    private StreamChannelDefinition(BuilderImpl builder) {
        this.numberOfChannels = builder.numberOfChannels;
        this.channelDefinitions = builder.channelDefinitions;
    }

    /**
     * <p>
     * The number of channels in a streaming channel.
     * </p>
     * 
     * @return The number of channels in a streaming channel.
     */
    public final Integer numberOfChannels() {
        return numberOfChannels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelDefinitions() {
        return channelDefinitions != null && !(channelDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The definitions of the channels in a streaming channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelDefinitions} method.
     * </p>
     * 
     * @return The definitions of the channels in a streaming channel.
     */
    public final List<ChannelDefinition> channelDefinitions() {
        return channelDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelDefinitions() ? channelDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamChannelDefinition)) {
            return false;
        }
        StreamChannelDefinition other = (StreamChannelDefinition) obj;
        return Objects.equals(numberOfChannels(), other.numberOfChannels())
                && hasChannelDefinitions() == other.hasChannelDefinitions()
                && Objects.equals(channelDefinitions(), other.channelDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamChannelDefinition").add("NumberOfChannels", numberOfChannels())
                .add("ChannelDefinitions", hasChannelDefinitions() ? channelDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfChannels":
            return Optional.ofNullable(clazz.cast(numberOfChannels()));
        case "ChannelDefinitions":
            return Optional.ofNullable(clazz.cast(channelDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StreamChannelDefinition, T> g) {
        return obj -> g.apply((StreamChannelDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamChannelDefinition> {
        /**
         * <p>
         * The number of channels in a streaming channel.
         * </p>
         * 
         * @param numberOfChannels
         *        The number of channels in a streaming channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfChannels(Integer numberOfChannels);

        /**
         * <p>
         * The definitions of the channels in a streaming channel.
         * </p>
         * 
         * @param channelDefinitions
         *        The definitions of the channels in a streaming channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions);

        /**
         * <p>
         * The definitions of the channels in a streaming channel.
         * </p>
         * 
         * @param channelDefinitions
         *        The definitions of the channels in a streaming channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelDefinitions(ChannelDefinition... channelDefinitions);

        /**
         * <p>
         * The definitions of the channels in a streaming channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition.Builder#build()} is
         * called immediately and its result is passed to {@link #channelDefinitions(List<ChannelDefinition>)}.
         * 
         * @param channelDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.ChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelDefinitions(java.util.Collection<ChannelDefinition>)
         */
        Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfChannels;

        private List<ChannelDefinition> channelDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StreamChannelDefinition model) {
            numberOfChannels(model.numberOfChannels);
            channelDefinitions(model.channelDefinitions);
        }

        public final Integer getNumberOfChannels() {
            return numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final List<ChannelDefinition.Builder> getChannelDefinitions() {
            List<ChannelDefinition.Builder> result = ChannelDefinitionsCopier.copyToBuilder(this.channelDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelDefinitions(Collection<ChannelDefinition.BuilderImpl> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copyFromBuilder(channelDefinitions);
        }

        @Override
        public final Builder channelDefinitions(Collection<ChannelDefinition> channelDefinitions) {
            this.channelDefinitions = ChannelDefinitionsCopier.copy(channelDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(ChannelDefinition... channelDefinitions) {
            channelDefinitions(Arrays.asList(channelDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelDefinitions(Consumer<ChannelDefinition.Builder>... channelDefinitions) {
            channelDefinitions(Stream.of(channelDefinitions).map(c -> ChannelDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StreamChannelDefinition build() {
            return new StreamChannelDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
