/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings for a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamConfiguration.Builder, StreamConfiguration> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(StreamConfiguration::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> FRAGMENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentNumber").getter(getter(StreamConfiguration::fragmentNumber))
            .setter(setter(Builder::fragmentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentNumber").build()).build();

    private static final SdkField<StreamChannelDefinition> STREAM_CHANNEL_DEFINITION_FIELD = SdkField
            .<StreamChannelDefinition> builder(MarshallingType.SDK_POJO).memberName("StreamChannelDefinition")
            .getter(getter(StreamConfiguration::streamChannelDefinition)).setter(setter(Builder::streamChannelDefinition))
            .constructor(StreamChannelDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamChannelDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            FRAGMENT_NUMBER_FIELD, STREAM_CHANNEL_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamArn", STREAM_ARN_FIELD);
                    put("FragmentNumber", FRAGMENT_NUMBER_FIELD);
                    put("StreamChannelDefinition", STREAM_CHANNEL_DEFINITION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String fragmentNumber;

    private final StreamChannelDefinition streamChannelDefinition;

    private StreamConfiguration(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.fragmentNumber = builder.fragmentNumber;
        this.streamChannelDefinition = builder.streamChannelDefinition;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The unique identifier of the fragment to begin processing.
     * </p>
     * 
     * @return The unique identifier of the fragment to begin processing.
     */
    public final String fragmentNumber() {
        return fragmentNumber;
    }

    /**
     * <p>
     * The streaming channel definition in the stream configuration.
     * </p>
     * 
     * @return The streaming channel definition in the stream configuration.
     */
    public final StreamChannelDefinition streamChannelDefinition() {
        return streamChannelDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(streamChannelDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamConfiguration)) {
            return false;
        }
        StreamConfiguration other = (StreamConfiguration) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(fragmentNumber(), other.fragmentNumber())
                && Objects.equals(streamChannelDefinition(), other.streamChannelDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamConfiguration").add("StreamArn", streamArn()).add("FragmentNumber", fragmentNumber())
                .add("StreamChannelDefinition", streamChannelDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "FragmentNumber":
            return Optional.ofNullable(clazz.cast(fragmentNumber()));
        case "StreamChannelDefinition":
            return Optional.ofNullable(clazz.cast(streamChannelDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StreamConfiguration, T> g) {
        return obj -> g.apply((StreamConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamConfiguration> {
        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The unique identifier of the fragment to begin processing.
         * </p>
         * 
         * @param fragmentNumber
         *        The unique identifier of the fragment to begin processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentNumber(String fragmentNumber);

        /**
         * <p>
         * The streaming channel definition in the stream configuration.
         * </p>
         * 
         * @param streamChannelDefinition
         *        The streaming channel definition in the stream configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamChannelDefinition(StreamChannelDefinition streamChannelDefinition);

        /**
         * <p>
         * The streaming channel definition in the stream configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamChannelDefinition.Builder} avoiding
         * the need to create one manually via {@link StreamChannelDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamChannelDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #streamChannelDefinition(StreamChannelDefinition)}.
         * 
         * @param streamChannelDefinition
         *        a consumer that will call methods on {@link StreamChannelDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamChannelDefinition(StreamChannelDefinition)
         */
        default Builder streamChannelDefinition(Consumer<StreamChannelDefinition.Builder> streamChannelDefinition) {
            return streamChannelDefinition(StreamChannelDefinition.builder().applyMutation(streamChannelDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String fragmentNumber;

        private StreamChannelDefinition streamChannelDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamConfiguration model) {
            streamArn(model.streamArn);
            fragmentNumber(model.fragmentNumber);
            streamChannelDefinition(model.streamChannelDefinition);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getFragmentNumber() {
            return fragmentNumber;
        }

        public final void setFragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
        }

        @Override
        public final Builder fragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        public final StreamChannelDefinition.Builder getStreamChannelDefinition() {
            return streamChannelDefinition != null ? streamChannelDefinition.toBuilder() : null;
        }

        public final void setStreamChannelDefinition(StreamChannelDefinition.BuilderImpl streamChannelDefinition) {
            this.streamChannelDefinition = streamChannelDefinition != null ? streamChannelDefinition.build() : null;
        }

        @Override
        public final Builder streamChannelDefinition(StreamChannelDefinition streamChannelDefinition) {
            this.streamChannelDefinition = streamChannelDefinition;
            return this;
        }

        @Override
        public StreamConfiguration build() {
            return new StreamConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
