/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMediaInsightsPipelineStatusRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<UpdateMediaInsightsPipelineStatusRequest.Builder, UpdateMediaInsightsPipelineStatusRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateMediaInsightsPipelineStatusRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(UpdateMediaInsightsPipelineStatusRequest::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            UPDATE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("identifier", IDENTIFIER_FIELD);
                    put("UpdateStatus", UPDATE_STATUS_FIELD);
                }
            });

    private final String identifier;

    private final String updateStatus;

    private UpdateMediaInsightsPipelineStatusRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.updateStatus = builder.updateStatus;
    }

    /**
     * <p>
     * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media insights
     * pipeline.
     * </p>
     * 
     * @return The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
     *         insights pipeline.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The requested status of the media insights pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link MediaPipelineStatusUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The requested status of the media insights pipeline.
     * @see MediaPipelineStatusUpdate
     */
    public final MediaPipelineStatusUpdate updateStatus() {
        return MediaPipelineStatusUpdate.fromValue(updateStatus);
    }

    /**
     * <p>
     * The requested status of the media insights pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link MediaPipelineStatusUpdate#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The requested status of the media insights pipeline.
     * @see MediaPipelineStatusUpdate
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaInsightsPipelineStatusRequest)) {
            return false;
        }
        UpdateMediaInsightsPipelineStatusRequest other = (UpdateMediaInsightsPipelineStatusRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMediaInsightsPipelineStatusRequest").add("Identifier", identifier())
                .add("UpdateStatus", updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaInsightsPipelineStatusRequest, T> g) {
        return obj -> g.apply((UpdateMediaInsightsPipelineStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMediaInsightsPipelineStatusRequest> {
        /**
         * <p>
         * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         * insights pipeline.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         *        insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The requested status of the media insights pipeline.
         * </p>
         * 
         * @param updateStatus
         *        The requested status of the media insights pipeline.
         * @see MediaPipelineStatusUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatusUpdate
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The requested status of the media insights pipeline.
         * </p>
         * 
         * @param updateStatus
         *        The requested status of the media insights pipeline.
         * @see MediaPipelineStatusUpdate
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineStatusUpdate
         */
        Builder updateStatus(MediaPipelineStatusUpdate updateStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String identifier;

        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaInsightsPipelineStatusRequest model) {
            super(model);
            identifier(model.identifier);
            updateStatus(model.updateStatus);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(MediaPipelineStatusUpdate updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMediaInsightsPipelineStatusRequest build() {
            return new UpdateMediaInsightsPipelineStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
