/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.FragmentSelector;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingStreamListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisVideoStreamRecordingSourceRuntimeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisVideoStreamRecordingSourceRuntimeConfiguration> {
    private static final SdkField<List<RecordingStreamConfiguration>> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Streams").getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration.getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration::streams)).setter(KinesisVideoStreamRecordingSourceRuntimeConfiguration.setter(Builder::streams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordingStreamConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FragmentSelector> FRAGMENT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FragmentSelector").getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration.getter(KinesisVideoStreamRecordingSourceRuntimeConfiguration::fragmentSelector)).setter(KinesisVideoStreamRecordingSourceRuntimeConfiguration.setter(Builder::fragmentSelector)).constructor(FragmentSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD, FRAGMENT_SELECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Streams", STREAMS_FIELD);
            this.put("FragmentSelector", FRAGMENT_SELECTOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<RecordingStreamConfiguration> streams;
    private final FragmentSelector fragmentSelector;

    private KinesisVideoStreamRecordingSourceRuntimeConfiguration(BuilderImpl builder) {
        this.streams = builder.streams;
        this.fragmentSelector = builder.fragmentSelector;
    }

    public final boolean hasStreams() {
        return this.streams != null && !(this.streams instanceof SdkAutoConstructList);
    }

    public final List<RecordingStreamConfiguration> streams() {
        return this.streams;
    }

    public final FragmentSelector fragmentSelector() {
        return this.fragmentSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreams() ? this.streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSelector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamRecordingSourceRuntimeConfiguration)) {
            return false;
        }
        KinesisVideoStreamRecordingSourceRuntimeConfiguration other = (KinesisVideoStreamRecordingSourceRuntimeConfiguration)obj;
        return this.hasStreams() == other.hasStreams() && Objects.equals(this.streams(), other.streams()) && Objects.equals(this.fragmentSelector(), other.fragmentSelector());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisVideoStreamRecordingSourceRuntimeConfiguration").add("Streams", this.hasStreams() ? this.streams() : null).add("FragmentSelector", (Object)this.fragmentSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "FragmentSelector": {
                return Optional.ofNullable(clazz.cast(this.fragmentSelector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamRecordingSourceRuntimeConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamRecordingSourceRuntimeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RecordingStreamConfiguration> streams = DefaultSdkAutoConstructList.getInstance();
        private FragmentSelector fragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamRecordingSourceRuntimeConfiguration model) {
            this.streams(model.streams);
            this.fragmentSelector(model.fragmentSelector);
        }

        public final List<RecordingStreamConfiguration.Builder> getStreams() {
            List<RecordingStreamConfiguration.Builder> result = RecordingStreamListCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<RecordingStreamConfiguration.BuilderImpl> streams) {
            this.streams = RecordingStreamListCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<RecordingStreamConfiguration> streams) {
            this.streams = RecordingStreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(RecordingStreamConfiguration ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<RecordingStreamConfiguration.Builder> ... streams) {
            this.streams(Stream.of(streams).map(c -> (RecordingStreamConfiguration)((RecordingStreamConfiguration.Builder)RecordingStreamConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FragmentSelector.Builder getFragmentSelector() {
            return this.fragmentSelector != null ? this.fragmentSelector.toBuilder() : null;
        }

        public final void setFragmentSelector(FragmentSelector.BuilderImpl fragmentSelector) {
            this.fragmentSelector = fragmentSelector != null ? fragmentSelector.build() : null;
        }

        @Override
        public final Builder fragmentSelector(FragmentSelector fragmentSelector) {
            this.fragmentSelector = fragmentSelector;
            return this;
        }

        public KinesisVideoStreamRecordingSourceRuntimeConfiguration build() {
            return new KinesisVideoStreamRecordingSourceRuntimeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisVideoStreamRecordingSourceRuntimeConfiguration> {
        public Builder streams(Collection<RecordingStreamConfiguration> var1);

        public Builder streams(RecordingStreamConfiguration ... var1);

        public Builder streams(Consumer<RecordingStreamConfiguration.Builder> ... var1);

        public Builder fragmentSelector(FragmentSelector var1);

        default public Builder fragmentSelector(Consumer<FragmentSelector.Builder> fragmentSelector) {
            return this.fragmentSelector((FragmentSelector)((FragmentSelector.Builder)FragmentSelector.builder().applyMutation(fragmentSelector)).build());
        }
    }
}

