/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaPipelineTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpeakerSearchTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpeakerSearchTask> {
    private static final SdkField<String> SPEAKER_SEARCH_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpeakerSearchTaskId").getter(SpeakerSearchTask.getter(SpeakerSearchTask::speakerSearchTaskId)).setter(SpeakerSearchTask.setter(Builder::speakerSearchTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskId").build()}).build();
    private static final SdkField<String> SPEAKER_SEARCH_TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpeakerSearchTaskStatus").getter(SpeakerSearchTask.getter(SpeakerSearchTask::speakerSearchTaskStatusAsString)).setter(SpeakerSearchTask.setter(Builder::speakerSearchTaskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpeakerSearchTaskStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(SpeakerSearchTask.getter(SpeakerSearchTask::createdTimestamp)).setter(SpeakerSearchTask.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(SpeakerSearchTask.getter(SpeakerSearchTask::updatedTimestamp)).setter(SpeakerSearchTask.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEAKER_SEARCH_TASK_ID_FIELD, SPEAKER_SEARCH_TASK_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SpeakerSearchTaskId", SPEAKER_SEARCH_TASK_ID_FIELD);
            this.put("SpeakerSearchTaskStatus", SPEAKER_SEARCH_TASK_STATUS_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String speakerSearchTaskId;
    private final String speakerSearchTaskStatus;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private SpeakerSearchTask(BuilderImpl builder) {
        this.speakerSearchTaskId = builder.speakerSearchTaskId;
        this.speakerSearchTaskStatus = builder.speakerSearchTaskStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String speakerSearchTaskId() {
        return this.speakerSearchTaskId;
    }

    public final MediaPipelineTaskStatus speakerSearchTaskStatus() {
        return MediaPipelineTaskStatus.fromValue(this.speakerSearchTaskStatus);
    }

    public final String speakerSearchTaskStatusAsString() {
        return this.speakerSearchTaskStatus;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.speakerSearchTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.speakerSearchTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSearchTask)) {
            return false;
        }
        SpeakerSearchTask other = (SpeakerSearchTask)obj;
        return Objects.equals(this.speakerSearchTaskId(), other.speakerSearchTaskId()) && Objects.equals(this.speakerSearchTaskStatusAsString(), other.speakerSearchTaskStatusAsString()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"SpeakerSearchTask").add("SpeakerSearchTaskId", (Object)this.speakerSearchTaskId()).add("SpeakerSearchTaskStatus", (Object)this.speakerSearchTaskStatusAsString()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpeakerSearchTaskId": {
                return Optional.ofNullable(clazz.cast(this.speakerSearchTaskId()));
            }
            case "SpeakerSearchTaskStatus": {
                return Optional.ofNullable(clazz.cast(this.speakerSearchTaskStatusAsString()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSearchTask, T> g) {
        return obj -> g.apply((SpeakerSearchTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String speakerSearchTaskId;
        private String speakerSearchTaskStatus;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSearchTask model) {
            this.speakerSearchTaskId(model.speakerSearchTaskId);
            this.speakerSearchTaskStatus(model.speakerSearchTaskStatus);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getSpeakerSearchTaskId() {
            return this.speakerSearchTaskId;
        }

        public final void setSpeakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
        }

        @Override
        public final Builder speakerSearchTaskId(String speakerSearchTaskId) {
            this.speakerSearchTaskId = speakerSearchTaskId;
            return this;
        }

        public final String getSpeakerSearchTaskStatus() {
            return this.speakerSearchTaskStatus;
        }

        public final void setSpeakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
        }

        @Override
        public final Builder speakerSearchTaskStatus(String speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus = speakerSearchTaskStatus;
            return this;
        }

        @Override
        public final Builder speakerSearchTaskStatus(MediaPipelineTaskStatus speakerSearchTaskStatus) {
            this.speakerSearchTaskStatus(speakerSearchTaskStatus == null ? null : speakerSearchTaskStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public SpeakerSearchTask build() {
            return new SpeakerSearchTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpeakerSearchTask> {
        public Builder speakerSearchTaskId(String var1);

        public Builder speakerSearchTaskStatus(String var1);

        public Builder speakerSearchTaskStatus(MediaPipelineTaskStatus var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

