/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaConcatenationPipelineResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<CreateMediaConcatenationPipelineResponse.Builder, CreateMediaConcatenationPipelineResponse> {
    private static final SdkField<MediaConcatenationPipeline> MEDIA_CONCATENATION_PIPELINE_FIELD = SdkField
            .<MediaConcatenationPipeline> builder(MarshallingType.SDK_POJO)
            .memberName("MediaConcatenationPipeline")
            .getter(getter(CreateMediaConcatenationPipelineResponse::mediaConcatenationPipeline))
            .setter(setter(Builder::mediaConcatenationPipeline))
            .constructor(MediaConcatenationPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcatenationPipeline").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDIA_CONCATENATION_PIPELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("MediaConcatenationPipeline", MEDIA_CONCATENATION_PIPELINE_FIELD);
                }
            });

    private final MediaConcatenationPipeline mediaConcatenationPipeline;

    private CreateMediaConcatenationPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.mediaConcatenationPipeline = builder.mediaConcatenationPipeline;
    }

    /**
     * <p>
     * A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of a media
     * concatenation pipeline object.
     * </p>
     * 
     * @return A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of a
     *         media concatenation pipeline object.
     */
    public final MediaConcatenationPipeline mediaConcatenationPipeline() {
        return mediaConcatenationPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaConcatenationPipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaConcatenationPipelineResponse)) {
            return false;
        }
        CreateMediaConcatenationPipelineResponse other = (CreateMediaConcatenationPipelineResponse) obj;
        return Objects.equals(mediaConcatenationPipeline(), other.mediaConcatenationPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaConcatenationPipelineResponse")
                .add("MediaConcatenationPipeline", mediaConcatenationPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaConcatenationPipeline":
            return Optional.ofNullable(clazz.cast(mediaConcatenationPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaConcatenationPipelineResponse, T> g) {
        return obj -> g.apply((CreateMediaConcatenationPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaConcatenationPipelineResponse> {
        /**
         * <p>
         * A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of a
         * media concatenation pipeline object.
         * </p>
         * 
         * @param mediaConcatenationPipeline
         *        A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of
         *        a media concatenation pipeline object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcatenationPipeline(MediaConcatenationPipeline mediaConcatenationPipeline);

        /**
         * <p>
         * A media concatenation pipeline object, the ID, source type, <code>MediaPipelineARN</code>, and sink of a
         * media concatenation pipeline object.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaConcatenationPipeline.Builder}
         * avoiding the need to create one manually via {@link MediaConcatenationPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConcatenationPipeline.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaConcatenationPipeline(MediaConcatenationPipeline)}.
         * 
         * @param mediaConcatenationPipeline
         *        a consumer that will call methods on {@link MediaConcatenationPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConcatenationPipeline(MediaConcatenationPipeline)
         */
        default Builder mediaConcatenationPipeline(Consumer<MediaConcatenationPipeline.Builder> mediaConcatenationPipeline) {
            return mediaConcatenationPipeline(MediaConcatenationPipeline.builder().applyMutation(mediaConcatenationPipeline)
                    .build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private MediaConcatenationPipeline mediaConcatenationPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaConcatenationPipelineResponse model) {
            super(model);
            mediaConcatenationPipeline(model.mediaConcatenationPipeline);
        }

        public final MediaConcatenationPipeline.Builder getMediaConcatenationPipeline() {
            return mediaConcatenationPipeline != null ? mediaConcatenationPipeline.toBuilder() : null;
        }

        public final void setMediaConcatenationPipeline(MediaConcatenationPipeline.BuilderImpl mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline != null ? mediaConcatenationPipeline.build() : null;
        }

        @Override
        public final Builder mediaConcatenationPipeline(MediaConcatenationPipeline mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline;
            return this;
        }

        @Override
        public CreateMediaConcatenationPipelineResponse build() {
            return new CreateMediaConcatenationPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
