/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration settings for a sentiment analysis task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SentimentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SentimentConfiguration.Builder, SentimentConfiguration> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(SentimentConfiguration::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> SENTIMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SentimentType").getter(getter(SentimentConfiguration::sentimentTypeAsString))
            .setter(setter(Builder::sentimentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentType").build()).build();

    private static final SdkField<Integer> TIME_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimePeriod").getter(getter(SentimentConfiguration::timePeriod)).setter(setter(Builder::timePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            SENTIMENT_TYPE_FIELD, TIME_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("RuleName", RULE_NAME_FIELD);
                    put("SentimentType", SENTIMENT_TYPE_FIELD);
                    put("TimePeriod", TIME_PERIOD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String sentimentType;

    private final Integer timePeriod;

    private SentimentConfiguration(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.sentimentType = builder.sentimentType;
        this.timePeriod = builder.timePeriod;
    }

    /**
     * <p>
     * The name of the rule in the sentiment configuration.
     * </p>
     * 
     * @return The name of the rule in the sentiment configuration.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentimentType}
     * will return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentTypeAsString}.
     * </p>
     * 
     * @return The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
     * @see SentimentType
     */
    public final SentimentType sentimentType() {
        return SentimentType.fromValue(sentimentType);
    }

    /**
     * <p>
     * The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentimentType}
     * will return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentTypeAsString}.
     * </p>
     * 
     * @return The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
     * @see SentimentType
     */
    public final String sentimentTypeAsString() {
        return sentimentType;
    }

    /**
     * <p>
     * Specifies the analysis interval.
     * </p>
     * 
     * @return Specifies the analysis interval.
     */
    public final Integer timePeriod() {
        return timePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentConfiguration)) {
            return false;
        }
        SentimentConfiguration other = (SentimentConfiguration) obj;
        return Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(sentimentTypeAsString(), other.sentimentTypeAsString())
                && Objects.equals(timePeriod(), other.timePeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SentimentConfiguration").add("RuleName", ruleName())
                .add("SentimentType", sentimentTypeAsString()).add("TimePeriod", timePeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "SentimentType":
            return Optional.ofNullable(clazz.cast(sentimentTypeAsString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SentimentConfiguration, T> g) {
        return obj -> g.apply((SentimentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SentimentConfiguration> {
        /**
         * <p>
         * The name of the rule in the sentiment configuration.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule in the sentiment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
         * </p>
         * 
         * @param sentimentType
         *        The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentimentType(String sentimentType);

        /**
         * <p>
         * The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
         * </p>
         * 
         * @param sentimentType
         *        The type of sentiment, <code>POSITIVE</code>, <code>NEGATIVE</code>, or <code>NEUTRAL</code>.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentimentType(SentimentType sentimentType);

        /**
         * <p>
         * Specifies the analysis interval.
         * </p>
         * 
         * @param timePeriod
         *        Specifies the analysis interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(Integer timePeriod);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String sentimentType;

        private Integer timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentConfiguration model) {
            ruleName(model.ruleName);
            sentimentType(model.sentimentType);
            timePeriod(model.timePeriod);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getSentimentType() {
            return sentimentType;
        }

        public final void setSentimentType(String sentimentType) {
            this.sentimentType = sentimentType;
        }

        @Override
        public final Builder sentimentType(String sentimentType) {
            this.sentimentType = sentimentType;
            return this;
        }

        @Override
        public final Builder sentimentType(SentimentType sentimentType) {
            this.sentimentType(sentimentType == null ? null : sentimentType.toString());
            return this;
        }

        public final Integer getTimePeriod() {
            return timePeriod;
        }

        public final void setTimePeriod(Integer timePeriod) {
            this.timePeriod = timePeriod;
        }

        @Override
        public final Builder timePeriod(Integer timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        @Override
        public SentimentConfiguration build() {
            return new SentimentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
