/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source configuration for a specified media pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConfiguration.Builder, SourceConfiguration> {
    private static final SdkField<SelectedVideoStreams> SELECTED_VIDEO_STREAMS_FIELD = SdkField
            .<SelectedVideoStreams> builder(MarshallingType.SDK_POJO).memberName("SelectedVideoStreams")
            .getter(getter(SourceConfiguration::selectedVideoStreams)).setter(setter(Builder::selectedVideoStreams))
            .constructor(SelectedVideoStreams::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedVideoStreams").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_VIDEO_STREAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SelectedVideoStreams", SELECTED_VIDEO_STREAMS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final SelectedVideoStreams selectedVideoStreams;

    private SourceConfiguration(BuilderImpl builder) {
        this.selectedVideoStreams = builder.selectedVideoStreams;
    }

    /**
     * <p>
     * The selected video streams for a specified media pipeline. The number of video streams can't exceed 25.
     * </p>
     * 
     * @return The selected video streams for a specified media pipeline. The number of video streams can't exceed 25.
     */
    public final SelectedVideoStreams selectedVideoStreams() {
        return selectedVideoStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedVideoStreams());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfiguration)) {
            return false;
        }
        SourceConfiguration other = (SourceConfiguration) obj;
        return Objects.equals(selectedVideoStreams(), other.selectedVideoStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConfiguration").add("SelectedVideoStreams", selectedVideoStreams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedVideoStreams":
            return Optional.ofNullable(clazz.cast(selectedVideoStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SourceConfiguration, T> g) {
        return obj -> g.apply((SourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConfiguration> {
        /**
         * <p>
         * The selected video streams for a specified media pipeline. The number of video streams can't exceed 25.
         * </p>
         * 
         * @param selectedVideoStreams
         *        The selected video streams for a specified media pipeline. The number of video streams can't exceed
         *        25.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedVideoStreams(SelectedVideoStreams selectedVideoStreams);

        /**
         * <p>
         * The selected video streams for a specified media pipeline. The number of video streams can't exceed 25.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectedVideoStreams.Builder} avoiding
         * the need to create one manually via {@link SelectedVideoStreams#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectedVideoStreams.Builder#build()} is called immediately and
         * its result is passed to {@link #selectedVideoStreams(SelectedVideoStreams)}.
         * 
         * @param selectedVideoStreams
         *        a consumer that will call methods on {@link SelectedVideoStreams.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedVideoStreams(SelectedVideoStreams)
         */
        default Builder selectedVideoStreams(Consumer<SelectedVideoStreams.Builder> selectedVideoStreams) {
            return selectedVideoStreams(SelectedVideoStreams.builder().applyMutation(selectedVideoStreams).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SelectedVideoStreams selectedVideoStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConfiguration model) {
            selectedVideoStreams(model.selectedVideoStreams);
        }

        public final SelectedVideoStreams.Builder getSelectedVideoStreams() {
            return selectedVideoStreams != null ? selectedVideoStreams.toBuilder() : null;
        }

        public final void setSelectedVideoStreams(SelectedVideoStreams.BuilderImpl selectedVideoStreams) {
            this.selectedVideoStreams = selectedVideoStreams != null ? selectedVideoStreams.build() : null;
        }

        @Override
        public final Builder selectedVideoStreams(SelectedVideoStreams selectedVideoStreams) {
            this.selectedVideoStreams = selectedVideoStreams;
            return this;
        }

        @Override
        public SourceConfiguration build() {
            return new SourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
