/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains server side encryption parameters to be used by media capture pipeline. The parameters can also be used by
 * media concatenation pipeline taking media capture pipeline as a media source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SseAwsKeyManagementParams implements SdkPojo, Serializable,
        ToCopyableBuilder<SseAwsKeyManagementParams.Builder, SseAwsKeyManagementParams> {
    private static final SdkField<String> AWS_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsKmsKeyId").getter(getter(SseAwsKeyManagementParams::awsKmsKeyId))
            .setter(setter(Builder::awsKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyId").build()).build();

    private static final SdkField<String> AWS_KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsKmsEncryptionContext").getter(getter(SseAwsKeyManagementParams::awsKmsEncryptionContext))
            .setter(setter(Builder::awsKmsEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsEncryptionContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_KMS_KEY_ID_FIELD,
            AWS_KMS_ENCRYPTION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AwsKmsKeyId", AWS_KMS_KEY_ID_FIELD);
                    put("AwsKmsEncryptionContext", AWS_KMS_ENCRYPTION_CONTEXT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String awsKmsKeyId;

    private final String awsKmsEncryptionContext;

    private SseAwsKeyManagementParams(BuilderImpl builder) {
        this.awsKmsKeyId = builder.awsKmsKeyId;
        this.awsKmsEncryptionContext = builder.awsKmsEncryptionContext;
    }

    /**
     * <p>
     * The KMS key you want to use to encrypt your media pipeline output. Decryption is required for concatenation
     * pipeline. If using a key located in the current Amazon Web Services account, you can specify your KMS key in one
     * of four ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If using a key located in a different Amazon Web Services account than the current Amazon Web Services account,
     * you can specify your KMS key in one of two ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the ARN for the KMS key ID. For example,
     * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     * </p>
     * <p>
     * Note that the role specified in the <code>SinkIamRoleArn</code> request parameter must have permission to use the
     * specified KMS key.
     * </p>
     * 
     * @return The KMS key you want to use to encrypt your media pipeline output. Decryption is required for
     *         concatenation pipeline. If using a key located in the current Amazon Web Services account, you can
     *         specify your KMS key in one of four ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If using a key located in a different Amazon Web Services account than the current Amazon Web Services
     *         account, you can specify your KMS key in one of two ways:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key ID. For example,
     *         <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use the ARN for the KMS key alias. For example,
     *         <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
     *         </p>
     *         <p>
     *         Note that the role specified in the <code>SinkIamRoleArn</code> request parameter must have permission to
     *         use the specified KMS key.
     */
    public final String awsKmsKeyId() {
        return awsKmsKeyId;
    }

    /**
     * <p>
     * Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as non-secret key-value pair
     * known as encryption context pairs, that provides an added layer of security for your data. For more information,
     * see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/encrypt_context.html">KMS encryption
     * context</a> and <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in KMS</a>
     * in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as non-secret
     *         key-value pair known as encryption context pairs, that provides an added layer of security for your data.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/encrypt_context.html">KMS encryption
     *         context</a> and <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in
     *         KMS</a> in the <i>Key Management Service Developer Guide</i>.
     */
    public final String awsKmsEncryptionContext() {
        return awsKmsEncryptionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsEncryptionContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SseAwsKeyManagementParams)) {
            return false;
        }
        SseAwsKeyManagementParams other = (SseAwsKeyManagementParams) obj;
        return Objects.equals(awsKmsKeyId(), other.awsKmsKeyId())
                && Objects.equals(awsKmsEncryptionContext(), other.awsKmsEncryptionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SseAwsKeyManagementParams").add("AwsKmsKeyId", awsKmsKeyId())
                .add("AwsKmsEncryptionContext", awsKmsEncryptionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsKmsKeyId":
            return Optional.ofNullable(clazz.cast(awsKmsKeyId()));
        case "AwsKmsEncryptionContext":
            return Optional.ofNullable(clazz.cast(awsKmsEncryptionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SseAwsKeyManagementParams, T> g) {
        return obj -> g.apply((SseAwsKeyManagementParams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SseAwsKeyManagementParams> {
        /**
         * <p>
         * The KMS key you want to use to encrypt your media pipeline output. Decryption is required for concatenation
         * pipeline. If using a key located in the current Amazon Web Services account, you can specify your KMS key in
         * one of four ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ul>
         * <p>
         * If using a key located in a different Amazon Web Services account than the current Amazon Web Services
         * account, you can specify your KMS key in one of two ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Use the ARN for the KMS key ID. For example,
         * <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>
         * .
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).
         * </p>
         * <p>
         * Note that the role specified in the <code>SinkIamRoleArn</code> request parameter must have permission to use
         * the specified KMS key.
         * </p>
         * 
         * @param awsKmsKeyId
         *        The KMS key you want to use to encrypt your media pipeline output. Decryption is required for
         *        concatenation pipeline. If using a key located in the current Amazon Web Services account, you can
         *        specify your KMS key in one of four ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the Amazon Resource Name (ARN) for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If using a key located in a different Amazon Web Services account than the current Amazon Web Services
         *        account, you can specify your KMS key in one of two ways:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key ID. For example,
         *        <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Use the ARN for the KMS key alias. For example,
         *        <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify an encryption key, your output is encrypted with the default Amazon S3 key
         *        (SSE-S3).
         *        </p>
         *        <p>
         *        Note that the role specified in the <code>SinkIamRoleArn</code> request parameter must have permission
         *        to use the specified KMS key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKeyId(String awsKmsKeyId);

        /**
         * <p>
         * Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as non-secret key-value
         * pair known as encryption context pairs, that provides an added layer of security for your data. For more
         * information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/encrypt_context.html">KMS
         * encryption context</a> and <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys in
         * KMS</a> in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param awsKmsEncryptionContext
         *        Base64-encoded string of a UTF-8 encoded JSON, which contains the encryption context as non-secret
         *        key-value pair known as encryption context pairs, that provides an added layer of security for your
         *        data. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/encrypt_context.html">KMS encryption
         *        context</a> and <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Asymmetric keys
         *        in KMS</a> in the <i>Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsEncryptionContext(String awsKmsEncryptionContext);
    }

    static final class BuilderImpl implements Builder {
        private String awsKmsKeyId;

        private String awsKmsEncryptionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(SseAwsKeyManagementParams model) {
            awsKmsKeyId(model.awsKmsKeyId);
            awsKmsEncryptionContext(model.awsKmsEncryptionContext);
        }

        public final String getAwsKmsKeyId() {
            return awsKmsKeyId;
        }

        public final void setAwsKmsKeyId(String awsKmsKeyId) {
            this.awsKmsKeyId = awsKmsKeyId;
        }

        @Override
        public final Builder awsKmsKeyId(String awsKmsKeyId) {
            this.awsKmsKeyId = awsKmsKeyId;
            return this;
        }

        public final String getAwsKmsEncryptionContext() {
            return awsKmsEncryptionContext;
        }

        public final void setAwsKmsEncryptionContext(String awsKmsEncryptionContext) {
            this.awsKmsEncryptionContext = awsKmsEncryptionContext;
        }

        @Override
        public final Builder awsKmsEncryptionContext(String awsKmsEncryptionContext) {
            this.awsKmsEncryptionContext = awsKmsEncryptionContext;
            return this;
        }

        @Override
        public SseAwsKeyManagementParams build() {
            return new SseAwsKeyManagementParams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
