/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the artifacts concatenation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactsConcatenationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ArtifactsConcatenationConfiguration.Builder, ArtifactsConcatenationConfiguration> {
    private static final SdkField<AudioConcatenationConfiguration> AUDIO_FIELD = SdkField
            .<AudioConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Audio")
            .getter(getter(ArtifactsConcatenationConfiguration::audio)).setter(setter(Builder::audio))
            .constructor(AudioConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<VideoConcatenationConfiguration> VIDEO_FIELD = SdkField
            .<VideoConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Video")
            .getter(getter(ArtifactsConcatenationConfiguration::video)).setter(setter(Builder::video))
            .constructor(VideoConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<ContentConcatenationConfiguration> CONTENT_FIELD = SdkField
            .<ContentConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Content")
            .getter(getter(ArtifactsConcatenationConfiguration::content)).setter(setter(Builder::content))
            .constructor(ContentConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<DataChannelConcatenationConfiguration> DATA_CHANNEL_FIELD = SdkField
            .<DataChannelConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataChannel")
            .getter(getter(ArtifactsConcatenationConfiguration::dataChannel)).setter(setter(Builder::dataChannel))
            .constructor(DataChannelConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataChannel").build()).build();

    private static final SdkField<TranscriptionMessagesConcatenationConfiguration> TRANSCRIPTION_MESSAGES_FIELD = SdkField
            .<TranscriptionMessagesConcatenationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TranscriptionMessages").getter(getter(ArtifactsConcatenationConfiguration::transcriptionMessages))
            .setter(setter(Builder::transcriptionMessages)).constructor(TranscriptionMessagesConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionMessages").build())
            .build();

    private static final SdkField<MeetingEventsConcatenationConfiguration> MEETING_EVENTS_FIELD = SdkField
            .<MeetingEventsConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("MeetingEvents")
            .getter(getter(ArtifactsConcatenationConfiguration::meetingEvents)).setter(setter(Builder::meetingEvents))
            .constructor(MeetingEventsConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingEvents").build()).build();

    private static final SdkField<CompositedVideoConcatenationConfiguration> COMPOSITED_VIDEO_FIELD = SdkField
            .<CompositedVideoConcatenationConfiguration> builder(MarshallingType.SDK_POJO).memberName("CompositedVideo")
            .getter(getter(ArtifactsConcatenationConfiguration::compositedVideo)).setter(setter(Builder::compositedVideo))
            .constructor(CompositedVideoConcatenationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositedVideo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD,
            CONTENT_FIELD, DATA_CHANNEL_FIELD, TRANSCRIPTION_MESSAGES_FIELD, MEETING_EVENTS_FIELD, COMPOSITED_VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioConcatenationConfiguration audio;

    private final VideoConcatenationConfiguration video;

    private final ContentConcatenationConfiguration content;

    private final DataChannelConcatenationConfiguration dataChannel;

    private final TranscriptionMessagesConcatenationConfiguration transcriptionMessages;

    private final MeetingEventsConcatenationConfiguration meetingEvents;

    private final CompositedVideoConcatenationConfiguration compositedVideo;

    private ArtifactsConcatenationConfiguration(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
        this.dataChannel = builder.dataChannel;
        this.transcriptionMessages = builder.transcriptionMessages;
        this.meetingEvents = builder.meetingEvents;
        this.compositedVideo = builder.compositedVideo;
    }

    /**
     * <p>
     * The configuration for the audio artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the audio artifacts concatenation.
     */
    public final AudioConcatenationConfiguration audio() {
        return audio;
    }

    /**
     * <p>
     * The configuration for the video artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the video artifacts concatenation.
     */
    public final VideoConcatenationConfiguration video() {
        return video;
    }

    /**
     * <p>
     * The configuration for the content artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the content artifacts concatenation.
     */
    public final ContentConcatenationConfiguration content() {
        return content;
    }

    /**
     * <p>
     * The configuration for the data channel artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the data channel artifacts concatenation.
     */
    public final DataChannelConcatenationConfiguration dataChannel() {
        return dataChannel;
    }

    /**
     * <p>
     * The configuration for the transcription messages artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the transcription messages artifacts concatenation.
     */
    public final TranscriptionMessagesConcatenationConfiguration transcriptionMessages() {
        return transcriptionMessages;
    }

    /**
     * <p>
     * The configuration for the meeting events artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the meeting events artifacts concatenation.
     */
    public final MeetingEventsConcatenationConfiguration meetingEvents() {
        return meetingEvents;
    }

    /**
     * <p>
     * The configuration for the composited video artifacts concatenation.
     * </p>
     * 
     * @return The configuration for the composited video artifacts concatenation.
     */
    public final CompositedVideoConcatenationConfiguration compositedVideo() {
        return compositedVideo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(dataChannel());
        hashCode = 31 * hashCode + Objects.hashCode(transcriptionMessages());
        hashCode = 31 * hashCode + Objects.hashCode(meetingEvents());
        hashCode = 31 * hashCode + Objects.hashCode(compositedVideo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactsConcatenationConfiguration)) {
            return false;
        }
        ArtifactsConcatenationConfiguration other = (ArtifactsConcatenationConfiguration) obj;
        return Objects.equals(audio(), other.audio()) && Objects.equals(video(), other.video())
                && Objects.equals(content(), other.content()) && Objects.equals(dataChannel(), other.dataChannel())
                && Objects.equals(transcriptionMessages(), other.transcriptionMessages())
                && Objects.equals(meetingEvents(), other.meetingEvents())
                && Objects.equals(compositedVideo(), other.compositedVideo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactsConcatenationConfiguration").add("Audio", audio()).add("Video", video())
                .add("Content", content()).add("DataChannel", dataChannel())
                .add("TranscriptionMessages", transcriptionMessages()).add("MeetingEvents", meetingEvents())
                .add("CompositedVideo", compositedVideo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "DataChannel":
            return Optional.ofNullable(clazz.cast(dataChannel()));
        case "TranscriptionMessages":
            return Optional.ofNullable(clazz.cast(transcriptionMessages()));
        case "MeetingEvents":
            return Optional.ofNullable(clazz.cast(meetingEvents()));
        case "CompositedVideo":
            return Optional.ofNullable(clazz.cast(compositedVideo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Audio", AUDIO_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("DataChannel", DATA_CHANNEL_FIELD);
        map.put("TranscriptionMessages", TRANSCRIPTION_MESSAGES_FIELD);
        map.put("MeetingEvents", MEETING_EVENTS_FIELD);
        map.put("CompositedVideo", COMPOSITED_VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArtifactsConcatenationConfiguration, T> g) {
        return obj -> g.apply((ArtifactsConcatenationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactsConcatenationConfiguration> {
        /**
         * <p>
         * The configuration for the audio artifacts concatenation.
         * </p>
         * 
         * @param audio
         *        The configuration for the audio artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioConcatenationConfiguration audio);

        /**
         * <p>
         * The configuration for the audio artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioConcatenationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioConcatenationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #audio(AudioConcatenationConfiguration)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioConcatenationConfiguration)
         */
        default Builder audio(Consumer<AudioConcatenationConfiguration.Builder> audio) {
            return audio(AudioConcatenationConfiguration.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * The configuration for the video artifacts concatenation.
         * </p>
         * 
         * @param video
         *        The configuration for the video artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoConcatenationConfiguration video);

        /**
         * <p>
         * The configuration for the video artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoConcatenationConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoConcatenationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #video(VideoConcatenationConfiguration)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoConcatenationConfiguration)
         */
        default Builder video(Consumer<VideoConcatenationConfiguration.Builder> video) {
            return video(VideoConcatenationConfiguration.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * The configuration for the content artifacts concatenation.
         * </p>
         * 
         * @param content
         *        The configuration for the content artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ContentConcatenationConfiguration content);

        /**
         * <p>
         * The configuration for the content artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContentConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link ContentConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentConcatenationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #content(ContentConcatenationConfiguration)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ContentConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ContentConcatenationConfiguration)
         */
        default Builder content(Consumer<ContentConcatenationConfiguration.Builder> content) {
            return content(ContentConcatenationConfiguration.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The configuration for the data channel artifacts concatenation.
         * </p>
         * 
         * @param dataChannel
         *        The configuration for the data channel artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataChannel(DataChannelConcatenationConfiguration dataChannel);

        /**
         * <p>
         * The configuration for the data channel artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataChannelConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link DataChannelConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataChannelConcatenationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataChannel(DataChannelConcatenationConfiguration)}.
         * 
         * @param dataChannel
         *        a consumer that will call methods on {@link DataChannelConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataChannel(DataChannelConcatenationConfiguration)
         */
        default Builder dataChannel(Consumer<DataChannelConcatenationConfiguration.Builder> dataChannel) {
            return dataChannel(DataChannelConcatenationConfiguration.builder().applyMutation(dataChannel).build());
        }

        /**
         * <p>
         * The configuration for the transcription messages artifacts concatenation.
         * </p>
         * 
         * @param transcriptionMessages
         *        The configuration for the transcription messages artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcriptionMessages(TranscriptionMessagesConcatenationConfiguration transcriptionMessages);

        /**
         * <p>
         * The configuration for the transcription messages artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TranscriptionMessagesConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link TranscriptionMessagesConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranscriptionMessagesConcatenationConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #transcriptionMessages(TranscriptionMessagesConcatenationConfiguration)}.
         * 
         * @param transcriptionMessages
         *        a consumer that will call methods on {@link TranscriptionMessagesConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transcriptionMessages(TranscriptionMessagesConcatenationConfiguration)
         */
        default Builder transcriptionMessages(
                Consumer<TranscriptionMessagesConcatenationConfiguration.Builder> transcriptionMessages) {
            return transcriptionMessages(TranscriptionMessagesConcatenationConfiguration.builder()
                    .applyMutation(transcriptionMessages).build());
        }

        /**
         * <p>
         * The configuration for the meeting events artifacts concatenation.
         * </p>
         * 
         * @param meetingEvents
         *        The configuration for the meeting events artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingEvents(MeetingEventsConcatenationConfiguration meetingEvents);

        /**
         * <p>
         * The configuration for the meeting events artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MeetingEventsConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link MeetingEventsConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeetingEventsConcatenationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #meetingEvents(MeetingEventsConcatenationConfiguration)}.
         * 
         * @param meetingEvents
         *        a consumer that will call methods on {@link MeetingEventsConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingEvents(MeetingEventsConcatenationConfiguration)
         */
        default Builder meetingEvents(Consumer<MeetingEventsConcatenationConfiguration.Builder> meetingEvents) {
            return meetingEvents(MeetingEventsConcatenationConfiguration.builder().applyMutation(meetingEvents).build());
        }

        /**
         * <p>
         * The configuration for the composited video artifacts concatenation.
         * </p>
         * 
         * @param compositedVideo
         *        The configuration for the composited video artifacts concatenation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositedVideo(CompositedVideoConcatenationConfiguration compositedVideo);

        /**
         * <p>
         * The configuration for the composited video artifacts concatenation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompositedVideoConcatenationConfiguration.Builder} avoiding the need to create one manually via
         * {@link CompositedVideoConcatenationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositedVideoConcatenationConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #compositedVideo(CompositedVideoConcatenationConfiguration)}.
         * 
         * @param compositedVideo
         *        a consumer that will call methods on {@link CompositedVideoConcatenationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositedVideo(CompositedVideoConcatenationConfiguration)
         */
        default Builder compositedVideo(Consumer<CompositedVideoConcatenationConfiguration.Builder> compositedVideo) {
            return compositedVideo(CompositedVideoConcatenationConfiguration.builder().applyMutation(compositedVideo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioConcatenationConfiguration audio;

        private VideoConcatenationConfiguration video;

        private ContentConcatenationConfiguration content;

        private DataChannelConcatenationConfiguration dataChannel;

        private TranscriptionMessagesConcatenationConfiguration transcriptionMessages;

        private MeetingEventsConcatenationConfiguration meetingEvents;

        private CompositedVideoConcatenationConfiguration compositedVideo;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactsConcatenationConfiguration model) {
            audio(model.audio);
            video(model.video);
            content(model.content);
            dataChannel(model.dataChannel);
            transcriptionMessages(model.transcriptionMessages);
            meetingEvents(model.meetingEvents);
            compositedVideo(model.compositedVideo);
        }

        public final AudioConcatenationConfiguration.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioConcatenationConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioConcatenationConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public final VideoConcatenationConfiguration.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoConcatenationConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoConcatenationConfiguration video) {
            this.video = video;
            return this;
        }

        public final ContentConcatenationConfiguration.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ContentConcatenationConfiguration.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ContentConcatenationConfiguration content) {
            this.content = content;
            return this;
        }

        public final DataChannelConcatenationConfiguration.Builder getDataChannel() {
            return dataChannel != null ? dataChannel.toBuilder() : null;
        }

        public final void setDataChannel(DataChannelConcatenationConfiguration.BuilderImpl dataChannel) {
            this.dataChannel = dataChannel != null ? dataChannel.build() : null;
        }

        @Override
        public final Builder dataChannel(DataChannelConcatenationConfiguration dataChannel) {
            this.dataChannel = dataChannel;
            return this;
        }

        public final TranscriptionMessagesConcatenationConfiguration.Builder getTranscriptionMessages() {
            return transcriptionMessages != null ? transcriptionMessages.toBuilder() : null;
        }

        public final void setTranscriptionMessages(
                TranscriptionMessagesConcatenationConfiguration.BuilderImpl transcriptionMessages) {
            this.transcriptionMessages = transcriptionMessages != null ? transcriptionMessages.build() : null;
        }

        @Override
        public final Builder transcriptionMessages(TranscriptionMessagesConcatenationConfiguration transcriptionMessages) {
            this.transcriptionMessages = transcriptionMessages;
            return this;
        }

        public final MeetingEventsConcatenationConfiguration.Builder getMeetingEvents() {
            return meetingEvents != null ? meetingEvents.toBuilder() : null;
        }

        public final void setMeetingEvents(MeetingEventsConcatenationConfiguration.BuilderImpl meetingEvents) {
            this.meetingEvents = meetingEvents != null ? meetingEvents.build() : null;
        }

        @Override
        public final Builder meetingEvents(MeetingEventsConcatenationConfiguration meetingEvents) {
            this.meetingEvents = meetingEvents;
            return this;
        }

        public final CompositedVideoConcatenationConfiguration.Builder getCompositedVideo() {
            return compositedVideo != null ? compositedVideo.toBuilder() : null;
        }

        public final void setCompositedVideo(CompositedVideoConcatenationConfiguration.BuilderImpl compositedVideo) {
            this.compositedVideo = compositedVideo != null ? compositedVideo.build() : null;
        }

        @Override
        public final Builder compositedVideo(CompositedVideoConcatenationConfiguration compositedVideo) {
            this.compositedVideo = compositedVideo;
            return this;
        }

        @Override
        public ArtifactsConcatenationConfiguration build() {
            return new ArtifactsConcatenationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
