/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media pipeline's configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChimeSdkMeetingLiveConnectorConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChimeSdkMeetingLiveConnectorConfiguration.Builder, ChimeSdkMeetingLiveConnectorConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ChimeSdkMeetingLiveConnectorConfiguration::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> MUX_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MuxType").getter(getter(ChimeSdkMeetingLiveConnectorConfiguration::muxTypeAsString))
            .setter(setter(Builder::muxType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuxType").build()).build();

    private static final SdkField<CompositedVideoArtifactsConfiguration> COMPOSITED_VIDEO_FIELD = SdkField
            .<CompositedVideoArtifactsConfiguration> builder(MarshallingType.SDK_POJO).memberName("CompositedVideo")
            .getter(getter(ChimeSdkMeetingLiveConnectorConfiguration::compositedVideo)).setter(setter(Builder::compositedVideo))
            .constructor(CompositedVideoArtifactsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositedVideo").build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceConfiguration")
            .getter(getter(ChimeSdkMeetingLiveConnectorConfiguration::sourceConfiguration))
            .setter(setter(Builder::sourceConfiguration)).constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MUX_TYPE_FIELD,
            COMPOSITED_VIDEO_FIELD, SOURCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String muxType;

    private final CompositedVideoArtifactsConfiguration compositedVideo;

    private final SourceConfiguration sourceConfiguration;

    private ChimeSdkMeetingLiveConnectorConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.muxType = builder.muxType;
        this.compositedVideo = builder.compositedVideo;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    /**
     * <p>
     * The configuration object's Chime SDK meeting ARN.
     * </p>
     * 
     * @return The configuration object's Chime SDK meeting ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration object's multiplex type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #muxType} will
     * return {@link LiveConnectorMuxType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #muxTypeAsString}.
     * </p>
     * 
     * @return The configuration object's multiplex type.
     * @see LiveConnectorMuxType
     */
    public final LiveConnectorMuxType muxType() {
        return LiveConnectorMuxType.fromValue(muxType);
    }

    /**
     * <p>
     * The configuration object's multiplex type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #muxType} will
     * return {@link LiveConnectorMuxType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #muxTypeAsString}.
     * </p>
     * 
     * @return The configuration object's multiplex type.
     * @see LiveConnectorMuxType
     */
    public final String muxTypeAsString() {
        return muxType;
    }

    /**
     * <p>
     * The media pipeline's composited video.
     * </p>
     * 
     * @return The media pipeline's composited video.
     */
    public final CompositedVideoArtifactsConfiguration compositedVideo() {
        return compositedVideo;
    }

    /**
     * <p>
     * The source configuration settings of the media pipeline's configuration object.
     * </p>
     * 
     * @return The source configuration settings of the media pipeline's configuration object.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(muxTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compositedVideo());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChimeSdkMeetingLiveConnectorConfiguration)) {
            return false;
        }
        ChimeSdkMeetingLiveConnectorConfiguration other = (ChimeSdkMeetingLiveConnectorConfiguration) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(muxTypeAsString(), other.muxTypeAsString())
                && Objects.equals(compositedVideo(), other.compositedVideo())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChimeSdkMeetingLiveConnectorConfiguration")
                .add("Arn", arn() == null ? null : "*** Sensitive Data Redacted ***").add("MuxType", muxTypeAsString())
                .add("CompositedVideo", compositedVideo()).add("SourceConfiguration", sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "MuxType":
            return Optional.ofNullable(clazz.cast(muxTypeAsString()));
        case "CompositedVideo":
            return Optional.ofNullable(clazz.cast(compositedVideo()));
        case "SourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("MuxType", MUX_TYPE_FIELD);
        map.put("CompositedVideo", COMPOSITED_VIDEO_FIELD);
        map.put("SourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChimeSdkMeetingLiveConnectorConfiguration, T> g) {
        return obj -> g.apply((ChimeSdkMeetingLiveConnectorConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChimeSdkMeetingLiveConnectorConfiguration> {
        /**
         * <p>
         * The configuration object's Chime SDK meeting ARN.
         * </p>
         * 
         * @param arn
         *        The configuration object's Chime SDK meeting ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration object's multiplex type.
         * </p>
         * 
         * @param muxType
         *        The configuration object's multiplex type.
         * @see LiveConnectorMuxType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorMuxType
         */
        Builder muxType(String muxType);

        /**
         * <p>
         * The configuration object's multiplex type.
         * </p>
         * 
         * @param muxType
         *        The configuration object's multiplex type.
         * @see LiveConnectorMuxType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorMuxType
         */
        Builder muxType(LiveConnectorMuxType muxType);

        /**
         * <p>
         * The media pipeline's composited video.
         * </p>
         * 
         * @param compositedVideo
         *        The media pipeline's composited video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositedVideo(CompositedVideoArtifactsConfiguration compositedVideo);

        /**
         * <p>
         * The media pipeline's composited video.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CompositedVideoArtifactsConfiguration.Builder} avoiding the need to create one manually via
         * {@link CompositedVideoArtifactsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositedVideoArtifactsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #compositedVideo(CompositedVideoArtifactsConfiguration)}.
         * 
         * @param compositedVideo
         *        a consumer that will call methods on {@link CompositedVideoArtifactsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositedVideo(CompositedVideoArtifactsConfiguration)
         */
        default Builder compositedVideo(Consumer<CompositedVideoArtifactsConfiguration.Builder> compositedVideo) {
            return compositedVideo(CompositedVideoArtifactsConfiguration.builder().applyMutation(compositedVideo).build());
        }

        /**
         * <p>
         * The source configuration settings of the media pipeline's configuration object.
         * </p>
         * 
         * @param sourceConfiguration
         *        The source configuration settings of the media pipeline's configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The source configuration settings of the media pipeline's configuration object.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String muxType;

        private CompositedVideoArtifactsConfiguration compositedVideo;

        private SourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ChimeSdkMeetingLiveConnectorConfiguration model) {
            arn(model.arn);
            muxType(model.muxType);
            compositedVideo(model.compositedVideo);
            sourceConfiguration(model.sourceConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getMuxType() {
            return muxType;
        }

        public final void setMuxType(String muxType) {
            this.muxType = muxType;
        }

        @Override
        public final Builder muxType(String muxType) {
            this.muxType = muxType;
            return this;
        }

        @Override
        public final Builder muxType(LiveConnectorMuxType muxType) {
            this.muxType(muxType == null ? null : muxType.toString());
            return this;
        }

        public final CompositedVideoArtifactsConfiguration.Builder getCompositedVideo() {
            return compositedVideo != null ? compositedVideo.toBuilder() : null;
        }

        public final void setCompositedVideo(CompositedVideoArtifactsConfiguration.BuilderImpl compositedVideo) {
            this.compositedVideo = compositedVideo != null ? compositedVideo.build() : null;
        }

        @Override
        public final Builder compositedVideo(CompositedVideoArtifactsConfiguration compositedVideo) {
            this.compositedVideo = compositedVideo;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        @Override
        public ChimeSdkMeetingLiveConnectorConfiguration build() {
            return new ChimeSdkMeetingLiveConnectorConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
