/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamPoolStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisVideoStreamPoolConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisVideoStreamPoolConfiguration> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolArn").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::poolArn)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::poolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()}).build();
    private static final SdkField<String> POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolName").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::poolName)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::poolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::poolId)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> POOL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolStatus").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::poolStatusAsString)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::poolStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolStatus").build()}).build();
    private static final SdkField<Integer> POOL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PoolSize").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::poolSize)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::poolSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolSize").build()}).build();
    private static final SdkField<KinesisVideoStreamConfiguration> STREAM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamConfiguration").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::streamConfiguration)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::streamConfiguration)).constructor(KinesisVideoStreamConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::createdTimestamp)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(KinesisVideoStreamPoolConfiguration.getter(KinesisVideoStreamPoolConfiguration::updatedTimestamp)).setter(KinesisVideoStreamPoolConfiguration.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD, POOL_NAME_FIELD, POOL_ID_FIELD, POOL_STATUS_FIELD, POOL_SIZE_FIELD, STREAM_CONFIGURATION_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisVideoStreamPoolConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String poolArn;
    private final String poolName;
    private final String poolId;
    private final String poolStatus;
    private final Integer poolSize;
    private final KinesisVideoStreamConfiguration streamConfiguration;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private KinesisVideoStreamPoolConfiguration(BuilderImpl builder) {
        this.poolArn = builder.poolArn;
        this.poolName = builder.poolName;
        this.poolId = builder.poolId;
        this.poolStatus = builder.poolStatus;
        this.poolSize = builder.poolSize;
        this.streamConfiguration = builder.streamConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String poolArn() {
        return this.poolArn;
    }

    public final String poolName() {
        return this.poolName;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final KinesisVideoStreamPoolStatus poolStatus() {
        return KinesisVideoStreamPoolStatus.fromValue(this.poolStatus);
    }

    public final String poolStatusAsString() {
        return this.poolStatus;
    }

    public final Integer poolSize() {
        return this.poolSize;
    }

    public final KinesisVideoStreamConfiguration streamConfiguration() {
        return this.streamConfiguration;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamPoolConfiguration)) {
            return false;
        }
        KinesisVideoStreamPoolConfiguration other = (KinesisVideoStreamPoolConfiguration)obj;
        return Objects.equals(this.poolArn(), other.poolArn()) && Objects.equals(this.poolName(), other.poolName()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.poolStatusAsString(), other.poolStatusAsString()) && Objects.equals(this.poolSize(), other.poolSize()) && Objects.equals(this.streamConfiguration(), other.streamConfiguration()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisVideoStreamPoolConfiguration").add("PoolArn", (Object)(this.poolArn() == null ? null : "*** Sensitive Data Redacted ***")).add("PoolName", (Object)this.poolName()).add("PoolId", (Object)this.poolId()).add("PoolStatus", (Object)this.poolStatusAsString()).add("PoolSize", (Object)this.poolSize()).add("StreamConfiguration", (Object)this.streamConfiguration()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolArn": {
                return Optional.ofNullable(clazz.cast(this.poolArn()));
            }
            case "PoolName": {
                return Optional.ofNullable(clazz.cast(this.poolName()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "PoolStatus": {
                return Optional.ofNullable(clazz.cast(this.poolStatusAsString()));
            }
            case "PoolSize": {
                return Optional.ofNullable(clazz.cast(this.poolSize()));
            }
            case "StreamConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamConfiguration()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("PoolStatus", POOL_STATUS_FIELD);
        map.put("PoolSize", POOL_SIZE_FIELD);
        map.put("StreamConfiguration", STREAM_CONFIGURATION_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamPoolConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamPoolConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String poolArn;
        private String poolName;
        private String poolId;
        private String poolStatus;
        private Integer poolSize;
        private KinesisVideoStreamConfiguration streamConfiguration;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamPoolConfiguration model) {
            this.poolArn(model.poolArn);
            this.poolName(model.poolName);
            this.poolId(model.poolId);
            this.poolStatus(model.poolStatus);
            this.poolSize(model.poolSize);
            this.streamConfiguration(model.streamConfiguration);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getPoolArn() {
            return this.poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolName() {
            return this.poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolStatus() {
            return this.poolStatus;
        }

        public final void setPoolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
        }

        @Override
        public final Builder poolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
            return this;
        }

        @Override
        public final Builder poolStatus(KinesisVideoStreamPoolStatus poolStatus) {
            this.poolStatus(poolStatus == null ? null : poolStatus.toString());
            return this;
        }

        public final Integer getPoolSize() {
            return this.poolSize;
        }

        public final void setPoolSize(Integer poolSize) {
            this.poolSize = poolSize;
        }

        @Override
        public final Builder poolSize(Integer poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public final KinesisVideoStreamConfiguration.Builder getStreamConfiguration() {
            return this.streamConfiguration != null ? this.streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(KinesisVideoStreamConfiguration.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        public final Builder streamConfiguration(KinesisVideoStreamConfiguration streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public KinesisVideoStreamPoolConfiguration build() {
            return new KinesisVideoStreamPoolConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisVideoStreamPoolConfiguration> {
        public Builder poolArn(String var1);

        public Builder poolName(String var1);

        public Builder poolId(String var1);

        public Builder poolStatus(String var1);

        public Builder poolStatus(KinesisVideoStreamPoolStatus var1);

        public Builder poolSize(Integer var1);

        public Builder streamConfiguration(KinesisVideoStreamConfiguration var1);

        default public Builder streamConfiguration(Consumer<KinesisVideoStreamConfiguration.Builder> streamConfiguration) {
            return this.streamConfiguration((KinesisVideoStreamConfiguration)((KinesisVideoStreamConfiguration.Builder)KinesisVideoStreamConfiguration.builder().applyMutation(streamConfiguration)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

