/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaEncoding;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StreamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KinesisVideoStreamSourceRuntimeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KinesisVideoStreamSourceRuntimeConfiguration> {
    private static final SdkField<List<StreamConfiguration>> STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Streams").getter(KinesisVideoStreamSourceRuntimeConfiguration.getter(KinesisVideoStreamSourceRuntimeConfiguration::streams)).setter(KinesisVideoStreamSourceRuntimeConfiguration.setter(Builder::streams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Streams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaEncoding").getter(KinesisVideoStreamSourceRuntimeConfiguration.getter(KinesisVideoStreamSourceRuntimeConfiguration::mediaEncodingAsString)).setter(KinesisVideoStreamSourceRuntimeConfiguration.setter(Builder::mediaEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaEncoding").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRate").getter(KinesisVideoStreamSourceRuntimeConfiguration.getter(KinesisVideoStreamSourceRuntimeConfiguration::mediaSampleRate)).setter(KinesisVideoStreamSourceRuntimeConfiguration.setter(Builder::mediaSampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMS_FIELD, MEDIA_ENCODING_FIELD, MEDIA_SAMPLE_RATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KinesisVideoStreamSourceRuntimeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StreamConfiguration> streams;
    private final String mediaEncoding;
    private final Integer mediaSampleRate;

    private KinesisVideoStreamSourceRuntimeConfiguration(BuilderImpl builder) {
        this.streams = builder.streams;
        this.mediaEncoding = builder.mediaEncoding;
        this.mediaSampleRate = builder.mediaSampleRate;
    }

    public final boolean hasStreams() {
        return this.streams != null && !(this.streams instanceof SdkAutoConstructList);
    }

    public final List<StreamConfiguration> streams() {
        return this.streams;
    }

    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(this.mediaEncoding);
    }

    public final String mediaEncodingAsString() {
        return this.mediaEncoding;
    }

    public final Integer mediaSampleRate() {
        return this.mediaSampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreams() ? this.streams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamSourceRuntimeConfiguration)) {
            return false;
        }
        KinesisVideoStreamSourceRuntimeConfiguration other = (KinesisVideoStreamSourceRuntimeConfiguration)obj;
        return this.hasStreams() == other.hasStreams() && Objects.equals(this.streams(), other.streams()) && Objects.equals(this.mediaEncodingAsString(), other.mediaEncodingAsString()) && Objects.equals(this.mediaSampleRate(), other.mediaSampleRate());
    }

    public final String toString() {
        return ToString.builder((String)"KinesisVideoStreamSourceRuntimeConfiguration").add("Streams", this.hasStreams() ? this.streams() : null).add("MediaEncoding", (Object)this.mediaEncodingAsString()).add("MediaSampleRate", (Object)this.mediaSampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Streams": {
                return Optional.ofNullable(clazz.cast(this.streams()));
            }
            case "MediaEncoding": {
                return Optional.ofNullable(clazz.cast(this.mediaEncodingAsString()));
            }
            case "MediaSampleRate": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Streams", STREAMS_FIELD);
        map.put("MediaEncoding", MEDIA_ENCODING_FIELD);
        map.put("MediaSampleRate", MEDIA_SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamSourceRuntimeConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamSourceRuntimeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StreamConfiguration> streams = DefaultSdkAutoConstructList.getInstance();
        private String mediaEncoding;
        private Integer mediaSampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamSourceRuntimeConfiguration model) {
            this.streams(model.streams);
            this.mediaEncoding(model.mediaEncoding);
            this.mediaSampleRate(model.mediaSampleRate);
        }

        public final List<StreamConfiguration.Builder> getStreams() {
            List<StreamConfiguration.Builder> result = StreamsCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<StreamConfiguration.BuilderImpl> streams) {
            this.streams = StreamsCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<StreamConfiguration> streams) {
            this.streams = StreamsCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(StreamConfiguration ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<StreamConfiguration.Builder> ... streams) {
            this.streams(Stream.of(streams).map(c -> (StreamConfiguration)((StreamConfiguration.Builder)StreamConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMediaEncoding() {
            return this.mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final Integer getMediaSampleRate() {
            return this.mediaSampleRate;
        }

        public final void setMediaSampleRate(Integer mediaSampleRate) {
            this.mediaSampleRate = mediaSampleRate;
        }

        @Override
        public final Builder mediaSampleRate(Integer mediaSampleRate) {
            this.mediaSampleRate = mediaSampleRate;
            return this;
        }

        public KinesisVideoStreamSourceRuntimeConfiguration build() {
            return new KinesisVideoStreamSourceRuntimeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KinesisVideoStreamSourceRuntimeConfiguration> {
        public Builder streams(Collection<StreamConfiguration> var1);

        public Builder streams(StreamConfiguration ... var1);

        public Builder streams(Consumer<StreamConfiguration.Builder> ... var1);

        public Builder mediaEncoding(String var1);

        public Builder mediaEncoding(MediaEncoding var1);

        public Builder mediaSampleRate(Integer var1);
    }
}

