/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the timestamp range and timestamp origin of a range of fragments.
 * </p>
 * <p>
 * Only fragments with a start timestamp greater than or equal to the given start time and less than or equal to the end
 * time are returned. For example, say a stream contains fragments with the following start timestamps:
 * </p>
 * <ul>
 * <li>
 * <p>
 * 00:00:00
 * </p>
 * </li>
 * <li>
 * <p>
 * 00:00:02
 * </p>
 * </li>
 * <li>
 * <p>
 * 00:00:04
 * </p>
 * </li>
 * <li>
 * <p>
 * 00:00:06
 * </p>
 * </li>
 * </ul>
 * <p>
 * A fragment selector range with a start time of 00:00:01 and end time of 00:00:04 would return the fragments with
 * start times of 00:00:02 and 00:00:04.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FragmentSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<FragmentSelector.Builder, FragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentSelectorType").getter(getter(FragmentSelector::fragmentSelectorTypeAsString))
            .setter(setter(Builder::fragmentSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build())
            .build();

    private static final SdkField<TimestampRange> TIMESTAMP_RANGE_FIELD = SdkField
            .<TimestampRange> builder(MarshallingType.SDK_POJO).memberName("TimestampRange")
            .getter(getter(FragmentSelector::timestampRange)).setter(setter(Builder::timestampRange))
            .constructor(TimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD,
            TIMESTAMP_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fragmentSelectorType;

    private final TimestampRange timestampRange;

    private FragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    /**
     * <p>
     * The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">StartSelectorType
     * </a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link FragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">
     *         StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
     * @see FragmentSelectorType
     */
    public final FragmentSelectorType fragmentSelectorType() {
        return FragmentSelectorType.fromValue(fragmentSelectorType);
    }

    /**
     * <p>
     * The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information, see <a
     * href
     * ="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">StartSelectorType
     * </a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link FragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">
     *         StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
     * @see FragmentSelectorType
     */
    public final String fragmentSelectorTypeAsString() {
        return fragmentSelectorType;
    }

    /**
     * <p>
     * The range of timestamps to return.
     * </p>
     * 
     * @return The range of timestamps to return.
     */
    public final TimestampRange timestampRange() {
        return timestampRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FragmentSelector)) {
            return false;
        }
        FragmentSelector other = (FragmentSelector) obj;
        return Objects.equals(fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString())
                && Objects.equals(timestampRange(), other.timestampRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FragmentSelector").add("FragmentSelectorType", fragmentSelectorTypeAsString())
                .add("TimestampRange", timestampRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FragmentSelectorType":
            return Optional.ofNullable(clazz.cast(fragmentSelectorTypeAsString()));
        case "TimestampRange":
            return Optional.ofNullable(clazz.cast(timestampRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FragmentSelectorType", FRAGMENT_SELECTOR_TYPE_FIELD);
        map.put("TimestampRange", TIMESTAMP_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FragmentSelector, T> g) {
        return obj -> g.apply((FragmentSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FragmentSelector> {
        /**
         * <p>
         * The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">
         * StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html"
         *        >StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
         * @see FragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FragmentSelectorType
         */
        Builder fragmentSelectorType(String fragmentSelectorType);

        /**
         * <p>
         * The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html">
         * StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The origin of the timestamps to use, <code>Server</code> or <code>Producer</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_dataplane_StartSelector.html"
         *        >StartSelectorType</a> in the <i>Amazon Kinesis Video Streams Developer Guide</i>.
         * @see FragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FragmentSelectorType
         */
        Builder fragmentSelectorType(FragmentSelectorType fragmentSelectorType);

        /**
         * <p>
         * The range of timestamps to return.
         * </p>
         * 
         * @param timestampRange
         *        The range of timestamps to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampRange(TimestampRange timestampRange);

        /**
         * <p>
         * The range of timestamps to return.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestampRange.Builder} avoiding the need
         * to create one manually via {@link TimestampRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampRange(TimestampRange)}.
         * 
         * @param timestampRange
         *        a consumer that will call methods on {@link TimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampRange(TimestampRange)
         */
        default Builder timestampRange(Consumer<TimestampRange.Builder> timestampRange) {
            return timestampRange(TimestampRange.builder().applyMutation(timestampRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fragmentSelectorType;

        private TimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(FragmentSelector model) {
            fragmentSelectorType(model.fragmentSelectorType);
            timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorType() {
            return fragmentSelectorType;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(FragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType == null ? null : fragmentSelectorType.toString());
            return this;
        }

        public final TimestampRange.Builder getTimestampRange() {
            return timestampRange != null ? timestampRange.toBuilder() : null;
        }

        public final void setTimestampRange(TimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        @Override
        public final Builder timestampRange(TimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        @Override
        public FragmentSelector build() {
            return new FragmentSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
