/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The updated Kinesis video stream configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamConfigurationUpdate.Builder, KinesisVideoStreamConfigurationUpdate> {
    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRetentionInHours").getter(getter(KinesisVideoStreamConfigurationUpdate::dataRetentionInHours))
            .setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DATA_RETENTION_IN_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dataRetentionInHours;

    private KinesisVideoStreamConfigurationUpdate(BuilderImpl builder) {
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    /**
     * <p>
     * The updated time that data is retained.
     * </p>
     * 
     * @return The updated time that data is retained.
     */
    public final Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamConfigurationUpdate)) {
            return false;
        }
        KinesisVideoStreamConfigurationUpdate other = (KinesisVideoStreamConfigurationUpdate) obj;
        return Objects.equals(dataRetentionInHours(), other.dataRetentionInHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamConfigurationUpdate").add("DataRetentionInHours", dataRetentionInHours())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataRetentionInHours", DATA_RETENTION_IN_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamConfigurationUpdate, T> g) {
        return obj -> g.apply((KinesisVideoStreamConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamConfigurationUpdate> {
        /**
         * <p>
         * The updated time that data is retained.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The updated time that data is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);
    }

    static final class BuilderImpl implements Builder {
        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamConfigurationUpdate model) {
            dataRetentionInHours(model.dataRetentionInHours);
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        @Override
        public KinesisVideoStreamConfigurationUpdate build() {
            return new KinesisVideoStreamConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
