/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The video stream pool configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamPoolConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamPoolConfiguration.Builder, KinesisVideoStreamPoolConfiguration> {
    private static final SdkField<String> POOL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolArn").getter(getter(KinesisVideoStreamPoolConfiguration::poolArn)).setter(setter(Builder::poolArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolArn").build()).build();

    private static final SdkField<String> POOL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolName").getter(getter(KinesisVideoStreamPoolConfiguration::poolName))
            .setter(setter(Builder::poolName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolName").build()).build();

    private static final SdkField<String> POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("PoolId")
            .getter(getter(KinesisVideoStreamPoolConfiguration::poolId)).setter(setter(Builder::poolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()).build();

    private static final SdkField<String> POOL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PoolStatus").getter(getter(KinesisVideoStreamPoolConfiguration::poolStatusAsString))
            .setter(setter(Builder::poolStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolStatus").build()).build();

    private static final SdkField<Integer> POOL_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PoolSize").getter(getter(KinesisVideoStreamPoolConfiguration::poolSize))
            .setter(setter(Builder::poolSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolSize").build()).build();

    private static final SdkField<KinesisVideoStreamConfiguration> STREAM_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamConfiguration> builder(MarshallingType.SDK_POJO).memberName("StreamConfiguration")
            .getter(getter(KinesisVideoStreamPoolConfiguration::streamConfiguration))
            .setter(setter(Builder::streamConfiguration)).constructor(KinesisVideoStreamConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(KinesisVideoStreamPoolConfiguration::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(KinesisVideoStreamPoolConfiguration::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ARN_FIELD,
            POOL_NAME_FIELD, POOL_ID_FIELD, POOL_STATUS_FIELD, POOL_SIZE_FIELD, STREAM_CONFIGURATION_FIELD,
            CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String poolArn;

    private final String poolName;

    private final String poolId;

    private final String poolStatus;

    private final Integer poolSize;

    private final KinesisVideoStreamConfiguration streamConfiguration;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private KinesisVideoStreamPoolConfiguration(BuilderImpl builder) {
        this.poolArn = builder.poolArn;
        this.poolName = builder.poolName;
        this.poolId = builder.poolId;
        this.poolStatus = builder.poolStatus;
        this.poolSize = builder.poolSize;
        this.streamConfiguration = builder.streamConfiguration;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ARN of the video stream pool configuration.
     * </p>
     * 
     * @return The ARN of the video stream pool configuration.
     */
    public final String poolArn() {
        return poolArn;
    }

    /**
     * <p>
     * The name of the video stream pool configuration.
     * </p>
     * 
     * @return The name of the video stream pool configuration.
     */
    public final String poolName() {
        return poolName;
    }

    /**
     * <p>
     * The ID of the video stream pool in the configuration.
     * </p>
     * 
     * @return The ID of the video stream pool in the configuration.
     */
    public final String poolId() {
        return poolId;
    }

    /**
     * <p>
     * The status of the video stream pool in the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolStatus} will
     * return {@link KinesisVideoStreamPoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #poolStatusAsString}.
     * </p>
     * 
     * @return The status of the video stream pool in the configuration.
     * @see KinesisVideoStreamPoolStatus
     */
    public final KinesisVideoStreamPoolStatus poolStatus() {
        return KinesisVideoStreamPoolStatus.fromValue(poolStatus);
    }

    /**
     * <p>
     * The status of the video stream pool in the configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #poolStatus} will
     * return {@link KinesisVideoStreamPoolStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #poolStatusAsString}.
     * </p>
     * 
     * @return The status of the video stream pool in the configuration.
     * @see KinesisVideoStreamPoolStatus
     */
    public final String poolStatusAsString() {
        return poolStatus;
    }

    /**
     * <p>
     * The size of the video stream pool in the configuration.
     * </p>
     * 
     * @return The size of the video stream pool in the configuration.
     */
    public final Integer poolSize() {
        return poolSize;
    }

    /**
     * <p>
     * The Kinesis video stream pool configuration object.
     * </p>
     * 
     * @return The Kinesis video stream pool configuration object.
     */
    public final KinesisVideoStreamConfiguration streamConfiguration() {
        return streamConfiguration;
    }

    /**
     * <p>
     * The time at which the configuration was created.
     * </p>
     * 
     * @return The time at which the configuration was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the configuration was updated.
     * </p>
     * 
     * @return The time at which the configuration was updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(poolArn());
        hashCode = 31 * hashCode + Objects.hashCode(poolName());
        hashCode = 31 * hashCode + Objects.hashCode(poolId());
        hashCode = 31 * hashCode + Objects.hashCode(poolStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(poolSize());
        hashCode = 31 * hashCode + Objects.hashCode(streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamPoolConfiguration)) {
            return false;
        }
        KinesisVideoStreamPoolConfiguration other = (KinesisVideoStreamPoolConfiguration) obj;
        return Objects.equals(poolArn(), other.poolArn()) && Objects.equals(poolName(), other.poolName())
                && Objects.equals(poolId(), other.poolId()) && Objects.equals(poolStatusAsString(), other.poolStatusAsString())
                && Objects.equals(poolSize(), other.poolSize())
                && Objects.equals(streamConfiguration(), other.streamConfiguration())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamPoolConfiguration")
                .add("PoolArn", poolArn() == null ? null : "*** Sensitive Data Redacted ***").add("PoolName", poolName())
                .add("PoolId", poolId()).add("PoolStatus", poolStatusAsString()).add("PoolSize", poolSize())
                .add("StreamConfiguration", streamConfiguration()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PoolArn":
            return Optional.ofNullable(clazz.cast(poolArn()));
        case "PoolName":
            return Optional.ofNullable(clazz.cast(poolName()));
        case "PoolId":
            return Optional.ofNullable(clazz.cast(poolId()));
        case "PoolStatus":
            return Optional.ofNullable(clazz.cast(poolStatusAsString()));
        case "PoolSize":
            return Optional.ofNullable(clazz.cast(poolSize()));
        case "StreamConfiguration":
            return Optional.ofNullable(clazz.cast(streamConfiguration()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PoolArn", POOL_ARN_FIELD);
        map.put("PoolName", POOL_NAME_FIELD);
        map.put("PoolId", POOL_ID_FIELD);
        map.put("PoolStatus", POOL_STATUS_FIELD);
        map.put("PoolSize", POOL_SIZE_FIELD);
        map.put("StreamConfiguration", STREAM_CONFIGURATION_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamPoolConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamPoolConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamPoolConfiguration> {
        /**
         * <p>
         * The ARN of the video stream pool configuration.
         * </p>
         * 
         * @param poolArn
         *        The ARN of the video stream pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolArn(String poolArn);

        /**
         * <p>
         * The name of the video stream pool configuration.
         * </p>
         * 
         * @param poolName
         *        The name of the video stream pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolName(String poolName);

        /**
         * <p>
         * The ID of the video stream pool in the configuration.
         * </p>
         * 
         * @param poolId
         *        The ID of the video stream pool in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolId(String poolId);

        /**
         * <p>
         * The status of the video stream pool in the configuration.
         * </p>
         * 
         * @param poolStatus
         *        The status of the video stream pool in the configuration.
         * @see KinesisVideoStreamPoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KinesisVideoStreamPoolStatus
         */
        Builder poolStatus(String poolStatus);

        /**
         * <p>
         * The status of the video stream pool in the configuration.
         * </p>
         * 
         * @param poolStatus
         *        The status of the video stream pool in the configuration.
         * @see KinesisVideoStreamPoolStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KinesisVideoStreamPoolStatus
         */
        Builder poolStatus(KinesisVideoStreamPoolStatus poolStatus);

        /**
         * <p>
         * The size of the video stream pool in the configuration.
         * </p>
         * 
         * @param poolSize
         *        The size of the video stream pool in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolSize(Integer poolSize);

        /**
         * <p>
         * The Kinesis video stream pool configuration object.
         * </p>
         * 
         * @param streamConfiguration
         *        The Kinesis video stream pool configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamConfiguration(KinesisVideoStreamConfiguration streamConfiguration);

        /**
         * <p>
         * The Kinesis video stream pool configuration object.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisVideoStreamConfiguration.Builder}
         * avoiding the need to create one manually via {@link KinesisVideoStreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #streamConfiguration(KinesisVideoStreamConfiguration)}.
         * 
         * @param streamConfiguration
         *        a consumer that will call methods on {@link KinesisVideoStreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamConfiguration(KinesisVideoStreamConfiguration)
         */
        default Builder streamConfiguration(Consumer<KinesisVideoStreamConfiguration.Builder> streamConfiguration) {
            return streamConfiguration(KinesisVideoStreamConfiguration.builder().applyMutation(streamConfiguration).build());
        }

        /**
         * <p>
         * The time at which the configuration was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the configuration was updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the configuration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String poolArn;

        private String poolName;

        private String poolId;

        private String poolStatus;

        private Integer poolSize;

        private KinesisVideoStreamConfiguration streamConfiguration;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamPoolConfiguration model) {
            poolArn(model.poolArn);
            poolName(model.poolName);
            poolId(model.poolId);
            poolStatus(model.poolStatus);
            poolSize(model.poolSize);
            streamConfiguration(model.streamConfiguration);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getPoolArn() {
            return poolArn;
        }

        public final void setPoolArn(String poolArn) {
            this.poolArn = poolArn;
        }

        @Override
        public final Builder poolArn(String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        public final String getPoolName() {
            return poolName;
        }

        public final void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public final Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public final String getPoolId() {
            return poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getPoolStatus() {
            return poolStatus;
        }

        public final void setPoolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
        }

        @Override
        public final Builder poolStatus(String poolStatus) {
            this.poolStatus = poolStatus;
            return this;
        }

        @Override
        public final Builder poolStatus(KinesisVideoStreamPoolStatus poolStatus) {
            this.poolStatus(poolStatus == null ? null : poolStatus.toString());
            return this;
        }

        public final Integer getPoolSize() {
            return poolSize;
        }

        public final void setPoolSize(Integer poolSize) {
            this.poolSize = poolSize;
        }

        @Override
        public final Builder poolSize(Integer poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public final KinesisVideoStreamConfiguration.Builder getStreamConfiguration() {
            return streamConfiguration != null ? streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(KinesisVideoStreamConfiguration.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        public final Builder streamConfiguration(KinesisVideoStreamConfiguration streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public KinesisVideoStreamPoolConfiguration build() {
            return new KinesisVideoStreamPoolConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
