/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The video streams for a specified media pipeline. The total number of video streams can't exceed 25.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectedVideoStreams implements SdkPojo, Serializable,
        ToCopyableBuilder<SelectedVideoStreams.Builder, SelectedVideoStreams> {
    private static final SdkField<List<String>> ATTENDEE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttendeeIds")
            .getter(getter(SelectedVideoStreams::attendeeIds))
            .setter(setter(Builder::attendeeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttendeeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXTERNAL_USER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExternalUserIds")
            .getter(getter(SelectedVideoStreams::externalUserIds))
            .setter(setter(Builder::externalUserIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTENDEE_IDS_FIELD,
            EXTERNAL_USER_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> attendeeIds;

    private final List<String> externalUserIds;

    private SelectedVideoStreams(BuilderImpl builder) {
        this.attendeeIds = builder.attendeeIds;
        this.externalUserIds = builder.externalUserIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttendeeIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttendeeIds() {
        return attendeeIds != null && !(attendeeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attendee IDs of the streams selected for a media pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttendeeIds} method.
     * </p>
     * 
     * @return The attendee IDs of the streams selected for a media pipeline.
     */
    public final List<String> attendeeIds() {
        return attendeeIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExternalUserIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExternalUserIds() {
        return externalUserIds != null && !(externalUserIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The external user IDs of the streams selected for a media pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExternalUserIds} method.
     * </p>
     * 
     * @return The external user IDs of the streams selected for a media pipeline.
     */
    public final List<String> externalUserIds() {
        return externalUserIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendeeIds() ? attendeeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExternalUserIds() ? externalUserIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectedVideoStreams)) {
            return false;
        }
        SelectedVideoStreams other = (SelectedVideoStreams) obj;
        return hasAttendeeIds() == other.hasAttendeeIds() && Objects.equals(attendeeIds(), other.attendeeIds())
                && hasExternalUserIds() == other.hasExternalUserIds()
                && Objects.equals(externalUserIds(), other.externalUserIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectedVideoStreams").add("AttendeeIds", hasAttendeeIds() ? attendeeIds() : null)
                .add("ExternalUserIds", externalUserIds() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttendeeIds":
            return Optional.ofNullable(clazz.cast(attendeeIds()));
        case "ExternalUserIds":
            return Optional.ofNullable(clazz.cast(externalUserIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttendeeIds", ATTENDEE_IDS_FIELD);
        map.put("ExternalUserIds", EXTERNAL_USER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectedVideoStreams, T> g) {
        return obj -> g.apply((SelectedVideoStreams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectedVideoStreams> {
        /**
         * <p>
         * The attendee IDs of the streams selected for a media pipeline.
         * </p>
         * 
         * @param attendeeIds
         *        The attendee IDs of the streams selected for a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendeeIds(Collection<String> attendeeIds);

        /**
         * <p>
         * The attendee IDs of the streams selected for a media pipeline.
         * </p>
         * 
         * @param attendeeIds
         *        The attendee IDs of the streams selected for a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendeeIds(String... attendeeIds);

        /**
         * <p>
         * The external user IDs of the streams selected for a media pipeline.
         * </p>
         * 
         * @param externalUserIds
         *        The external user IDs of the streams selected for a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserIds(Collection<String> externalUserIds);

        /**
         * <p>
         * The external user IDs of the streams selected for a media pipeline.
         * </p>
         * 
         * @param externalUserIds
         *        The external user IDs of the streams selected for a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserIds(String... externalUserIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> attendeeIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> externalUserIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectedVideoStreams model) {
            attendeeIds(model.attendeeIds);
            externalUserIds(model.externalUserIds);
        }

        public final Collection<String> getAttendeeIds() {
            if (attendeeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return attendeeIds;
        }

        public final void setAttendeeIds(Collection<String> attendeeIds) {
            this.attendeeIds = AttendeeIdListCopier.copy(attendeeIds);
        }

        @Override
        public final Builder attendeeIds(Collection<String> attendeeIds) {
            this.attendeeIds = AttendeeIdListCopier.copy(attendeeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendeeIds(String... attendeeIds) {
            attendeeIds(Arrays.asList(attendeeIds));
            return this;
        }

        public final Collection<String> getExternalUserIds() {
            if (externalUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return externalUserIds;
        }

        public final void setExternalUserIds(Collection<String> externalUserIds) {
            this.externalUserIds = ExternalUserIdListCopier.copy(externalUserIds);
        }

        @Override
        public final Builder externalUserIds(Collection<String> externalUserIds) {
            this.externalUserIds = ExternalUserIdListCopier.copy(externalUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder externalUserIds(String... externalUserIds) {
            externalUserIds(Arrays.asList(externalUserIds));
            return this;
        }

        @Override
        public SelectedVideoStreams build() {
            return new SelectedVideoStreams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
