/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.chimesdkmediapipelines.internal.ChimeSdkMediaPipelinesServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.BadRequestException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ConflictException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaConcatenationPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaInsightsPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaLiveConnectorPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.CreateMediaStreamPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.DeleteMediaPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ForbiddenException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetMediaPipelineResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.GetVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaInsightsPipelineConfigurationsResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelineKinesisVideoStreamPoolsResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaPipelinesResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.NotFoundException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ServiceFailureException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ServiceUnavailableException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StartVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.StopVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ThrottledClientException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UnauthorizedClientException;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineConfigurationResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaInsightsPipelineStatusResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.UpdateMediaPipelineKinesisVideoStreamPoolResponse;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaConcatenationPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaInsightsPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaLiveConnectorPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.CreateMediaStreamPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.DeleteMediaPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaCapturePipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetMediaPipelineRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.GetVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaCapturePipelinesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaInsightsPipelineConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaPipelineKinesisVideoStreamPoolsRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListMediaPipelinesRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StartSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StartVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StopSpeakerSearchTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.StopVoiceToneAnalysisTaskRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaInsightsPipelineConfigurationRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaInsightsPipelineStatusRequestMarshaller;
import software.amazon.awssdk.services.chimesdkmediapipelines.transform.UpdateMediaPipelineKinesisVideoStreamPoolRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ChimeSdkMediaPipelinesAsyncClient}.
 *
 * @see ChimeSdkMediaPipelinesAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultChimeSdkMediaPipelinesAsyncClient implements ChimeSdkMediaPipelinesAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultChimeSdkMediaPipelinesAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultChimeSdkMediaPipelinesAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a media pipeline.
     * </p>
     *
     * @param createMediaCapturePipelineRequest
     * @return A Java Future containing the result of the CreateMediaCapturePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaCapturePipelineResponse> createMediaCapturePipeline(
            CreateMediaCapturePipelineRequest createMediaCapturePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMediaCapturePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaCapturePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMediaCapturePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaCapturePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaCapturePipelineRequest, CreateMediaCapturePipelineResponse>()
                            .withOperationName("CreateMediaCapturePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaCapturePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaCapturePipelineRequest));
            CompletableFuture<CreateMediaCapturePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a media concatenation pipeline.
     * </p>
     *
     * @param createMediaConcatenationPipelineRequest
     * @return A Java Future containing the result of the CreateMediaConcatenationPipeline operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaConcatenationPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaConcatenationPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaConcatenationPipelineResponse> createMediaConcatenationPipeline(
            CreateMediaConcatenationPipelineRequest createMediaConcatenationPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMediaConcatenationPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaConcatenationPipelineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaConcatenationPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaConcatenationPipelineResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateMediaConcatenationPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaConcatenationPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaConcatenationPipelineRequest, CreateMediaConcatenationPipelineResponse>()
                            .withOperationName("CreateMediaConcatenationPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaConcatenationPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaConcatenationPipelineRequest));
            CompletableFuture<CreateMediaConcatenationPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a media insights pipeline.
     * </p>
     *
     * @param createMediaInsightsPipelineRequest
     * @return A Java Future containing the result of the CreateMediaInsightsPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaInsightsPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaInsightsPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaInsightsPipelineResponse> createMediaInsightsPipeline(
            CreateMediaInsightsPipelineRequest createMediaInsightsPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMediaInsightsPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaInsightsPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaInsightsPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaInsightsPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMediaInsightsPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaInsightsPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaInsightsPipelineRequest, CreateMediaInsightsPipelineResponse>()
                            .withOperationName("CreateMediaInsightsPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaInsightsPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaInsightsPipelineRequest));
            CompletableFuture<CreateMediaInsightsPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * A structure that contains the static configurations for a media insights pipeline.
     * </p>
     *
     * @param createMediaInsightsPipelineConfigurationRequest
     * @return A Java Future containing the result of the CreateMediaInsightsPipelineConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaInsightsPipelineConfigurationResponse> createMediaInsightsPipelineConfiguration(
            CreateMediaInsightsPipelineConfigurationRequest createMediaInsightsPipelineConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createMediaInsightsPipelineConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaInsightsPipelineConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateMediaInsightsPipelineConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaInsightsPipelineConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaInsightsPipelineConfigurationRequest, CreateMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("CreateMediaInsightsPipelineConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaInsightsPipelineConfigurationRequest));
            CompletableFuture<CreateMediaInsightsPipelineConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a media live connector pipeline in an Amazon Chime SDK meeting.
     * </p>
     *
     * @param createMediaLiveConnectorPipelineRequest
     * @return A Java Future containing the result of the CreateMediaLiveConnectorPipeline operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaLiveConnectorPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaLiveConnectorPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaLiveConnectorPipelineResponse> createMediaLiveConnectorPipeline(
            CreateMediaLiveConnectorPipelineRequest createMediaLiveConnectorPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMediaLiveConnectorPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaLiveConnectorPipelineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaLiveConnectorPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaLiveConnectorPipelineResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateMediaLiveConnectorPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaLiveConnectorPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaLiveConnectorPipelineRequest, CreateMediaLiveConnectorPipelineResponse>()
                            .withOperationName("CreateMediaLiveConnectorPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaLiveConnectorPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaLiveConnectorPipelineRequest));
            CompletableFuture<CreateMediaLiveConnectorPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Kinesis Video Stream pool for use with media stream pipelines.
     * </p>
     * <note>
     * <p>
     * If a meeting uses an opt-in Region as its <a href=
     * "https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion"
     * >MediaRegion</a>, the KVS stream must be in that same Region. For example, if a meeting uses the
     * <code>af-south-1</code> Region, the KVS stream must also be in <code>af-south-1</code>. However, if the meeting
     * uses a Region that AWS turns on by default, the KVS stream can be in any available Region, including an opt-in
     * Region. For example, if the meeting uses <code>ca-central-1</code>, the KVS stream can be in
     * <code>eu-west-2</code>, <code>us-east-1</code>, <code>af-south-1</code>, or any other Region that the Amazon
     * Chime SDK supports.
     * </p>
     * <p>
     * To learn which AWS Region a meeting uses, call the <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_GetMeeting.html">GetMeeting</a>
     * API and use the <a href=
     * "https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_CreateMeeting.html#chimesdk-meeting-chime_CreateMeeting-request-MediaRegion"
     * >MediaRegion</a> parameter from the response.
     * </p>
     * <p>
     * For more information about opt-in Regions, refer to <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html">Available Regions</a> in the
     * <i>Amazon Chime SDK Developer Guide</i>, and <a
     * href="https://docs.aws.amazon.com/accounts/latest/reference/manage-acct-regions.html#rande-manage-enable.html"
     * >Specify which AWS Regions your account can use</a>, in the <i>AWS Account Management Reference Guide</i>.
     * </p>
     * </note>
     *
     * @param createMediaPipelineKinesisVideoStreamPoolRequest
     * @return A Java Future containing the result of the CreateMediaPipelineKinesisVideoStreamPool operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaPipelineKinesisVideoStreamPoolResponse> createMediaPipelineKinesisVideoStreamPool(
            CreateMediaPipelineKinesisVideoStreamPoolRequest createMediaPipelineKinesisVideoStreamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createMediaPipelineKinesisVideoStreamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaPipelineKinesisVideoStreamPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateMediaPipelineKinesisVideoStreamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaPipelineKinesisVideoStreamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaPipelineKinesisVideoStreamPoolRequest, CreateMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("CreateMediaPipelineKinesisVideoStreamPool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaPipelineKinesisVideoStreamPoolRequest));
            CompletableFuture<CreateMediaPipelineKinesisVideoStreamPoolResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a streaming media pipeline.
     * </p>
     *
     * @param createMediaStreamPipelineRequest
     * @return A Java Future containing the result of the CreateMediaStreamPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.CreateMediaStreamPipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaStreamPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMediaStreamPipelineResponse> createMediaStreamPipeline(
            CreateMediaStreamPipelineRequest createMediaStreamPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMediaStreamPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMediaStreamPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMediaStreamPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMediaStreamPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMediaStreamPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMediaStreamPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMediaStreamPipelineRequest, CreateMediaStreamPipelineResponse>()
                            .withOperationName("CreateMediaStreamPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMediaStreamPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMediaStreamPipelineRequest));
            CompletableFuture<CreateMediaStreamPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the media pipeline.
     * </p>
     *
     * @param deleteMediaCapturePipelineRequest
     * @return A Java Future containing the result of the DeleteMediaCapturePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.DeleteMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMediaCapturePipelineResponse> deleteMediaCapturePipeline(
            DeleteMediaCapturePipelineRequest deleteMediaCapturePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMediaCapturePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaCapturePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMediaCapturePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMediaCapturePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaCapturePipelineRequest, DeleteMediaCapturePipelineResponse>()
                            .withOperationName("DeleteMediaCapturePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMediaCapturePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMediaCapturePipelineRequest));
            CompletableFuture<DeleteMediaCapturePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified configuration settings.
     * </p>
     *
     * @param deleteMediaInsightsPipelineConfigurationRequest
     * @return A Java Future containing the result of the DeleteMediaInsightsPipelineConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.DeleteMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMediaInsightsPipelineConfigurationResponse> deleteMediaInsightsPipelineConfiguration(
            DeleteMediaInsightsPipelineConfigurationRequest deleteMediaInsightsPipelineConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteMediaInsightsPipelineConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaInsightsPipelineConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteMediaInsightsPipelineConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMediaInsightsPipelineConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaInsightsPipelineConfigurationRequest, DeleteMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("DeleteMediaInsightsPipelineConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMediaInsightsPipelineConfigurationRequest));
            CompletableFuture<DeleteMediaInsightsPipelineConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the media pipeline.
     * </p>
     *
     * @param deleteMediaPipelineRequest
     * @return A Java Future containing the result of the DeleteMediaPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.DeleteMediaPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMediaPipelineResponse> deleteMediaPipeline(
            DeleteMediaPipelineRequest deleteMediaPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMediaPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMediaPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMediaPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMediaPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMediaPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaPipelineRequest, DeleteMediaPipelineResponse>()
                            .withOperationName("DeleteMediaPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMediaPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMediaPipelineRequest));
            CompletableFuture<DeleteMediaPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Kinesis Video Stream pool.
     * </p>
     *
     * @param deleteMediaPipelineKinesisVideoStreamPoolRequest
     * @return A Java Future containing the result of the DeleteMediaPipelineKinesisVideoStreamPool operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.DeleteMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMediaPipelineKinesisVideoStreamPoolResponse> deleteMediaPipelineKinesisVideoStreamPool(
            DeleteMediaPipelineKinesisVideoStreamPoolRequest deleteMediaPipelineKinesisVideoStreamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteMediaPipelineKinesisVideoStreamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMediaPipelineKinesisVideoStreamPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteMediaPipelineKinesisVideoStreamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMediaPipelineKinesisVideoStreamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMediaPipelineKinesisVideoStreamPoolRequest, DeleteMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("DeleteMediaPipelineKinesisVideoStreamPool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMediaPipelineKinesisVideoStreamPoolRequest));
            CompletableFuture<DeleteMediaPipelineKinesisVideoStreamPoolResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an existing media pipeline.
     * </p>
     *
     * @param getMediaCapturePipelineRequest
     * @return A Java Future containing the result of the GetMediaCapturePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetMediaCapturePipeline
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMediaCapturePipelineResponse> getMediaCapturePipeline(
            GetMediaCapturePipelineRequest getMediaCapturePipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaCapturePipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaCapturePipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaCapturePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMediaCapturePipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMediaCapturePipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMediaCapturePipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMediaCapturePipelineRequest, GetMediaCapturePipelineResponse>()
                            .withOperationName("GetMediaCapturePipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMediaCapturePipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMediaCapturePipelineRequest));
            CompletableFuture<GetMediaCapturePipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the configuration settings for a media insights pipeline.
     * </p>
     *
     * @param getMediaInsightsPipelineConfigurationRequest
     * @return A Java Future containing the result of the GetMediaInsightsPipelineConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMediaInsightsPipelineConfigurationResponse> getMediaInsightsPipelineConfiguration(
            GetMediaInsightsPipelineConfigurationRequest getMediaInsightsPipelineConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaInsightsPipelineConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaInsightsPipelineConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetMediaInsightsPipelineConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMediaInsightsPipelineConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMediaInsightsPipelineConfigurationRequest, GetMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("GetMediaInsightsPipelineConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMediaInsightsPipelineConfigurationRequest));
            CompletableFuture<GetMediaInsightsPipelineConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an existing media pipeline.
     * </p>
     *
     * @param getMediaPipelineRequest
     * @return A Java Future containing the result of the GetMediaPipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetMediaPipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipeline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMediaPipelineResponse> getMediaPipeline(GetMediaPipelineRequest getMediaPipelineRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaPipelineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMediaPipelineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMediaPipelineResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMediaPipelineResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMediaPipelineResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMediaPipelineRequest, GetMediaPipelineResponse>()
                            .withOperationName("GetMediaPipeline").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMediaPipelineRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMediaPipelineRequest));
            CompletableFuture<GetMediaPipelineResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an Kinesis video stream pool.
     * </p>
     *
     * @param getMediaPipelineKinesisVideoStreamPoolRequest
     * @return A Java Future containing the result of the GetMediaPipelineKinesisVideoStreamPool operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMediaPipelineKinesisVideoStreamPoolResponse> getMediaPipelineKinesisVideoStreamPool(
            GetMediaPipelineKinesisVideoStreamPoolRequest getMediaPipelineKinesisVideoStreamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMediaPipelineKinesisVideoStreamPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMediaPipelineKinesisVideoStreamPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetMediaPipelineKinesisVideoStreamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMediaPipelineKinesisVideoStreamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMediaPipelineKinesisVideoStreamPoolRequest, GetMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("GetMediaPipelineKinesisVideoStreamPool").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMediaPipelineKinesisVideoStreamPoolRequest));
            CompletableFuture<GetMediaPipelineKinesisVideoStreamPoolResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of the specified speaker search task.
     * </p>
     *
     * @param getSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the GetSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSpeakerSearchTaskResponse> getSpeakerSearchTask(
            GetSpeakerSearchTaskRequest getSpeakerSearchTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSpeakerSearchTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSpeakerSearchTaskRequest, GetSpeakerSearchTaskResponse>()
                            .withOperationName("GetSpeakerSearchTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSpeakerSearchTaskRequest));
            CompletableFuture<GetSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a voice tone analysis task.
     * </p>
     *
     * @param getVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the GetVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.GetVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetVoiceToneAnalysisTaskResponse> getVoiceToneAnalysisTask(
            GetVoiceToneAnalysisTaskRequest getVoiceToneAnalysisTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVoiceToneAnalysisTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVoiceToneAnalysisTaskRequest, GetVoiceToneAnalysisTaskResponse>()
                            .withOperationName("GetVoiceToneAnalysisTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getVoiceToneAnalysisTaskRequest));
            CompletableFuture<GetVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of media pipelines.
     * </p>
     *
     * @param listMediaCapturePipelinesRequest
     * @return A Java Future containing the result of the ListMediaCapturePipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.ListMediaCapturePipelines
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMediaCapturePipelinesResponse> listMediaCapturePipelines(
            ListMediaCapturePipelinesRequest listMediaCapturePipelinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMediaCapturePipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMediaCapturePipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaCapturePipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMediaCapturePipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMediaCapturePipelinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMediaCapturePipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMediaCapturePipelinesRequest, ListMediaCapturePipelinesResponse>()
                            .withOperationName("ListMediaCapturePipelines").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMediaCapturePipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMediaCapturePipelinesRequest));
            CompletableFuture<ListMediaCapturePipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the available media insights pipeline configurations.
     * </p>
     *
     * @param listMediaInsightsPipelineConfigurationsRequest
     * @return A Java Future containing the result of the ListMediaInsightsPipelineConfigurations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.ListMediaInsightsPipelineConfigurations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaInsightsPipelineConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMediaInsightsPipelineConfigurationsResponse> listMediaInsightsPipelineConfigurations(
            ListMediaInsightsPipelineConfigurationsRequest listMediaInsightsPipelineConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMediaInsightsPipelineConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMediaInsightsPipelineConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaInsightsPipelineConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMediaInsightsPipelineConfigurationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListMediaInsightsPipelineConfigurationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMediaInsightsPipelineConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMediaInsightsPipelineConfigurationsRequest, ListMediaInsightsPipelineConfigurationsResponse>()
                            .withOperationName("ListMediaInsightsPipelineConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMediaInsightsPipelineConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMediaInsightsPipelineConfigurationsRequest));
            CompletableFuture<ListMediaInsightsPipelineConfigurationsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the video stream pools in the media pipeline.
     * </p>
     *
     * @param listMediaPipelineKinesisVideoStreamPoolsRequest
     * @return A Java Future containing the result of the ListMediaPipelineKinesisVideoStreamPools operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.ListMediaPipelineKinesisVideoStreamPools
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelineKinesisVideoStreamPools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMediaPipelineKinesisVideoStreamPoolsResponse> listMediaPipelineKinesisVideoStreamPools(
            ListMediaPipelineKinesisVideoStreamPoolsRequest listMediaPipelineKinesisVideoStreamPoolsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listMediaPipelineKinesisVideoStreamPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMediaPipelineKinesisVideoStreamPoolsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaPipelineKinesisVideoStreamPools");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMediaPipelineKinesisVideoStreamPoolsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListMediaPipelineKinesisVideoStreamPoolsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMediaPipelineKinesisVideoStreamPoolsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMediaPipelineKinesisVideoStreamPoolsRequest, ListMediaPipelineKinesisVideoStreamPoolsResponse>()
                            .withOperationName("ListMediaPipelineKinesisVideoStreamPools").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMediaPipelineKinesisVideoStreamPoolsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMediaPipelineKinesisVideoStreamPoolsRequest));
            CompletableFuture<ListMediaPipelineKinesisVideoStreamPoolsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of media pipelines.
     * </p>
     *
     * @param listMediaPipelinesRequest
     * @return A Java Future containing the result of the ListMediaPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.ListMediaPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMediaPipelinesResponse> listMediaPipelines(ListMediaPipelinesRequest listMediaPipelinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMediaPipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMediaPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMediaPipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMediaPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMediaPipelinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMediaPipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMediaPipelinesRequest, ListMediaPipelinesResponse>()
                            .withOperationName("ListMediaPipelines").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMediaPipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMediaPipelinesRequest));
            CompletableFuture<ListMediaPipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags available for a media pipeline.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a speaker search task.
     * </p>
     * <important>
     * <p>
     * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker
     * as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StartSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.StartSpeakerSearchTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StartSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSpeakerSearchTaskResponse> startSpeakerSearchTask(
            StartSpeakerSearchTaskRequest startSpeakerSearchTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSpeakerSearchTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSpeakerSearchTaskRequest, StartSpeakerSearchTaskResponse>()
                            .withOperationName("StartSpeakerSearchTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startSpeakerSearchTaskRequest));
            CompletableFuture<StartSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a voice tone analysis task. For more information about voice tone analysis, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/voice-analytics.html">Using Amazon Chime SDK voice
     * analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the
     * speaker as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StartVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.StartVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StartVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartVoiceToneAnalysisTaskResponse> startVoiceToneAnalysisTask(
            StartVoiceToneAnalysisTaskRequest startVoiceToneAnalysisTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startVoiceToneAnalysisTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartVoiceToneAnalysisTaskRequest, StartVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StartVoiceToneAnalysisTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startVoiceToneAnalysisTaskRequest));
            CompletableFuture<StartVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a speaker search task.
     * </p>
     *
     * @param stopSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StopSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.StopSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StopSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopSpeakerSearchTaskResponse> stopSpeakerSearchTask(
            StopSpeakerSearchTaskRequest stopSpeakerSearchTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopSpeakerSearchTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSpeakerSearchTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSpeakerSearchTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSpeakerSearchTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopSpeakerSearchTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopSpeakerSearchTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSpeakerSearchTaskRequest, StopSpeakerSearchTaskResponse>()
                            .withOperationName("StopSpeakerSearchTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopSpeakerSearchTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopSpeakerSearchTaskRequest));
            CompletableFuture<StopSpeakerSearchTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a voice tone analysis task.
     * </p>
     *
     * @param stopVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StopVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.StopVoiceToneAnalysisTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/StopVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopVoiceToneAnalysisTaskResponse> stopVoiceToneAnalysisTask(
            StopVoiceToneAnalysisTaskRequest stopVoiceToneAnalysisTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopVoiceToneAnalysisTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopVoiceToneAnalysisTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopVoiceToneAnalysisTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopVoiceToneAnalysisTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopVoiceToneAnalysisTaskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopVoiceToneAnalysisTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopVoiceToneAnalysisTaskRequest, StopVoiceToneAnalysisTaskResponse>()
                            .withOperationName("StopVoiceToneAnalysisTask").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopVoiceToneAnalysisTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopVoiceToneAnalysisTaskRequest));
            CompletableFuture<StopVoiceToneAnalysisTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * The ARN of the media pipeline that you want to tag. Consists of the pipeline's endpoint region, resource ID, and
     * pipeline ID.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes any tags from a media pipeline.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the media insights pipeline's configuration settings.
     * </p>
     *
     * @param updateMediaInsightsPipelineConfigurationRequest
     * @return A Java Future containing the result of the UpdateMediaInsightsPipelineConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.UpdateMediaInsightsPipelineConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaInsightsPipelineConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMediaInsightsPipelineConfigurationResponse> updateMediaInsightsPipelineConfiguration(
            UpdateMediaInsightsPipelineConfigurationRequest updateMediaInsightsPipelineConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateMediaInsightsPipelineConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaInsightsPipelineConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaInsightsPipelineConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMediaInsightsPipelineConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateMediaInsightsPipelineConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMediaInsightsPipelineConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaInsightsPipelineConfigurationRequest, UpdateMediaInsightsPipelineConfigurationResponse>()
                            .withOperationName("UpdateMediaInsightsPipelineConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMediaInsightsPipelineConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMediaInsightsPipelineConfigurationRequest));
            CompletableFuture<UpdateMediaInsightsPipelineConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the status of a media insights pipeline.
     * </p>
     *
     * @param updateMediaInsightsPipelineStatusRequest
     * @return A Java Future containing the result of the UpdateMediaInsightsPipelineStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.UpdateMediaInsightsPipelineStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaInsightsPipelineStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMediaInsightsPipelineStatusResponse> updateMediaInsightsPipelineStatus(
            UpdateMediaInsightsPipelineStatusRequest updateMediaInsightsPipelineStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMediaInsightsPipelineStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaInsightsPipelineStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaInsightsPipelineStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMediaInsightsPipelineStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateMediaInsightsPipelineStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMediaInsightsPipelineStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaInsightsPipelineStatusRequest, UpdateMediaInsightsPipelineStatusResponse>()
                            .withOperationName("UpdateMediaInsightsPipelineStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMediaInsightsPipelineStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMediaInsightsPipelineStatusRequest));
            CompletableFuture<UpdateMediaInsightsPipelineStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon Kinesis Video Stream pool in a media pipeline.
     * </p>
     *
     * @param updateMediaPipelineKinesisVideoStreamPoolRequest
     * @return A Java Future containing the result of the UpdateMediaPipelineKinesisVideoStreamPool operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException One or more of the resources in the request does not exist in the system.</li>
     *         <li>UnauthorizedClientException The client is not currently authorized to make the request.</li>
     *         <li>ThrottledClientException The client exceeded its request rate limit.</li>
     *         <li>ConflictException The request could not be processed because of conflict in the current state of the
     *         resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkMediaPipelinesException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkMediaPipelinesAsyncClient.UpdateMediaPipelineKinesisVideoStreamPool
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UpdateMediaPipelineKinesisVideoStreamPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMediaPipelineKinesisVideoStreamPoolResponse> updateMediaPipelineKinesisVideoStreamPool(
            UpdateMediaPipelineKinesisVideoStreamPoolRequest updateMediaPipelineKinesisVideoStreamPoolRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                updateMediaPipelineKinesisVideoStreamPoolRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMediaPipelineKinesisVideoStreamPoolRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Chime SDK Media Pipelines");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMediaPipelineKinesisVideoStreamPool");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMediaPipelineKinesisVideoStreamPoolResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateMediaPipelineKinesisVideoStreamPoolResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMediaPipelineKinesisVideoStreamPoolResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMediaPipelineKinesisVideoStreamPoolRequest, UpdateMediaPipelineKinesisVideoStreamPoolResponse>()
                            .withOperationName("UpdateMediaPipelineKinesisVideoStreamPool")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMediaPipelineKinesisVideoStreamPoolRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMediaPipelineKinesisVideoStreamPoolRequest));
            CompletableFuture<UpdateMediaPipelineKinesisVideoStreamPoolResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ChimeSdkMediaPipelinesServiceClientConfiguration serviceClientConfiguration() {
        return new ChimeSdkMediaPipelinesServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ChimeSdkMediaPipelinesException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedClientException")
                                .exceptionBuilderSupplier(UnauthorizedClientException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailureException")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottledClientException")
                                .exceptionBuilderSupplier(ThrottledClientException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceUnavailableException")
                                .exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ChimeSdkMediaPipelinesServiceClientConfigurationBuilder serviceConfigBuilder = new ChimeSdkMediaPipelinesServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
