/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaStreamPipelineResponse extends ChimeSdkMediaPipelinesResponse implements
        ToCopyableBuilder<CreateMediaStreamPipelineResponse.Builder, CreateMediaStreamPipelineResponse> {
    private static final SdkField<MediaStreamPipeline> MEDIA_STREAM_PIPELINE_FIELD = SdkField
            .<MediaStreamPipeline> builder(MarshallingType.SDK_POJO).memberName("MediaStreamPipeline")
            .getter(getter(CreateMediaStreamPipelineResponse::mediaStreamPipeline)).setter(setter(Builder::mediaStreamPipeline))
            .constructor(MediaStreamPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamPipeline").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_STREAM_PIPELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MediaStreamPipeline mediaStreamPipeline;

    private CreateMediaStreamPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.mediaStreamPipeline = builder.mediaStreamPipeline;
    }

    /**
     * <p>
     * The requested media pipeline.
     * </p>
     * 
     * @return The requested media pipeline.
     */
    public final MediaStreamPipeline mediaStreamPipeline() {
        return mediaStreamPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamPipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaStreamPipelineResponse)) {
            return false;
        }
        CreateMediaStreamPipelineResponse other = (CreateMediaStreamPipelineResponse) obj;
        return Objects.equals(mediaStreamPipeline(), other.mediaStreamPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaStreamPipelineResponse").add("MediaStreamPipeline", mediaStreamPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaStreamPipeline":
            return Optional.ofNullable(clazz.cast(mediaStreamPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaStreamPipeline", MEDIA_STREAM_PIPELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaStreamPipelineResponse, T> g) {
        return obj -> g.apply((CreateMediaStreamPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaStreamPipelineResponse> {
        /**
         * <p>
         * The requested media pipeline.
         * </p>
         * 
         * @param mediaStreamPipeline
         *        The requested media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamPipeline(MediaStreamPipeline mediaStreamPipeline);

        /**
         * <p>
         * The requested media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaStreamPipeline.Builder} avoiding the
         * need to create one manually via {@link MediaStreamPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaStreamPipeline.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaStreamPipeline(MediaStreamPipeline)}.
         * 
         * @param mediaStreamPipeline
         *        a consumer that will call methods on {@link MediaStreamPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreamPipeline(MediaStreamPipeline)
         */
        default Builder mediaStreamPipeline(Consumer<MediaStreamPipeline.Builder> mediaStreamPipeline) {
            return mediaStreamPipeline(MediaStreamPipeline.builder().applyMutation(mediaStreamPipeline).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private MediaStreamPipeline mediaStreamPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaStreamPipelineResponse model) {
            super(model);
            mediaStreamPipeline(model.mediaStreamPipeline);
        }

        public final MediaStreamPipeline.Builder getMediaStreamPipeline() {
            return mediaStreamPipeline != null ? mediaStreamPipeline.toBuilder() : null;
        }

        public final void setMediaStreamPipeline(MediaStreamPipeline.BuilderImpl mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline != null ? mediaStreamPipeline.build() : null;
        }

        @Override
        public final Builder mediaStreamPipeline(MediaStreamPipeline mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline;
            return this;
        }

        @Override
        public CreateMediaStreamPipelineResponse build() {
            return new CreateMediaStreamPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
