/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration settings for real-time alerts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeAlertConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeAlertConfiguration.Builder, RealTimeAlertConfiguration> {
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(RealTimeAlertConfiguration::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final SdkField<List<RealTimeAlertRule>> RULES_FIELD = SdkField
            .<List<RealTimeAlertRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(RealTimeAlertConfiguration::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeAlertRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeAlertRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLED_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean disabled;

    private final List<RealTimeAlertRule> rules;

    private RealTimeAlertConfiguration(BuilderImpl builder) {
        this.disabled = builder.disabled;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * Turns off real-time alerts.
     * </p>
     * 
     * @return Turns off real-time alerts.
     */
    public final Boolean disabled() {
        return disabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules in the alert. Rules specify the words or phrases that you want to be notified about.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules in the alert. Rules specify the words or phrases that you want to be notified about.
     */
    public final List<RealTimeAlertRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeAlertConfiguration)) {
            return false;
        }
        RealTimeAlertConfiguration other = (RealTimeAlertConfiguration) obj;
        return Objects.equals(disabled(), other.disabled()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeAlertConfiguration").add("Disabled", disabled())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Disabled", DISABLED_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeAlertConfiguration, T> g) {
        return obj -> g.apply((RealTimeAlertConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeAlertConfiguration> {
        /**
         * <p>
         * Turns off real-time alerts.
         * </p>
         * 
         * @param disabled
         *        Turns off real-time alerts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);

        /**
         * <p>
         * The rules in the alert. Rules specify the words or phrases that you want to be notified about.
         * </p>
         * 
         * @param rules
         *        The rules in the alert. Rules specify the words or phrases that you want to be notified about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RealTimeAlertRule> rules);

        /**
         * <p>
         * The rules in the alert. Rules specify the words or phrases that you want to be notified about.
         * </p>
         * 
         * @param rules
         *        The rules in the alert. Rules specify the words or phrases that you want to be notified about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RealTimeAlertRule... rules);

        /**
         * <p>
         * The rules in the alert. Rules specify the words or phrases that you want to be notified about.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule.Builder#build()} is
         * called immediately and its result is passed to {@link #rules(List<RealTimeAlertRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<RealTimeAlertRule>)
         */
        Builder rules(Consumer<RealTimeAlertRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private Boolean disabled;

        private List<RealTimeAlertRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeAlertConfiguration model) {
            disabled(model.disabled);
            rules(model.rules);
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final List<RealTimeAlertRule.Builder> getRules() {
            List<RealTimeAlertRule.Builder> result = RealTimeAlertRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RealTimeAlertRule.BuilderImpl> rules) {
            this.rules = RealTimeAlertRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RealTimeAlertRule> rules) {
            this.rules = RealTimeAlertRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RealTimeAlertRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RealTimeAlertRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RealTimeAlertRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RealTimeAlertConfiguration build() {
            return new RealTimeAlertConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
