/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration settings for a media insights pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaInsightsPipelineConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaInsightsPipelineConfiguration.Builder, MediaInsightsPipelineConfiguration> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationName")
            .getter(getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationName))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationName").build()).build();

    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationArn")
            .getter(getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationArn))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationArn").build()).build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAccessRoleArn").getter(getter(MediaInsightsPipelineConfiguration::resourceAccessRoleArn))
            .setter(setter(Builder::resourceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build())
            .build();

    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField
            .<RealTimeAlertConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RealTimeAlertConfiguration")
            .getter(getter(MediaInsightsPipelineConfiguration::realTimeAlertConfiguration))
            .setter(setter(Builder::realTimeAlertConfiguration))
            .constructor(RealTimeAlertConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build())
            .build();

    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField
            .<List<MediaInsightsPipelineConfigurationElement>> builder(MarshallingType.LIST)
            .memberName("Elements")
            .getter(getter(MediaInsightsPipelineConfiguration::elements))
            .setter(setter(Builder::elements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaInsightsPipelineConfigurationElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaInsightsPipelineConfigurationElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationId")
            .getter(getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationId))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(MediaInsightsPipelineConfiguration::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(MediaInsightsPipelineConfiguration::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD, MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD,
            RESOURCE_ACCESS_ROLE_ARN_FIELD, REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD,
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaInsightsPipelineConfigurationName;

    private final String mediaInsightsPipelineConfigurationArn;

    private final String resourceAccessRoleArn;

    private final RealTimeAlertConfiguration realTimeAlertConfiguration;

    private final List<MediaInsightsPipelineConfigurationElement> elements;

    private final String mediaInsightsPipelineConfigurationId;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private MediaInsightsPipelineConfiguration(BuilderImpl builder) {
        this.mediaInsightsPipelineConfigurationName = builder.mediaInsightsPipelineConfigurationName;
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
        this.mediaInsightsPipelineConfigurationId = builder.mediaInsightsPipelineConfigurationId;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The name of the configuration.
     * </p>
     * 
     * @return The name of the configuration.
     */
    public final String mediaInsightsPipelineConfigurationName() {
        return mediaInsightsPipelineConfigurationName;
    }

    /**
     * <p>
     * The ARN of the configuration.
     * </p>
     * 
     * @return The ARN of the configuration.
     */
    public final String mediaInsightsPipelineConfigurationArn() {
        return mediaInsightsPipelineConfigurationArn;
    }

    /**
     * <p>
     * The ARN of the role used by the service to access Amazon Web Services resources.
     * </p>
     * 
     * @return The ARN of the role used by the service to access Amazon Web Services resources.
     */
    public final String resourceAccessRoleArn() {
        return resourceAccessRoleArn;
    }

    /**
     * <p>
     * Lists the rules that trigger a real-time alert.
     * </p>
     * 
     * @return Lists the rules that trigger a real-time alert.
     */
    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return realTimeAlertConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Elements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElements() {
        return elements != null && !(elements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements in the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElements} method.
     * </p>
     * 
     * @return The elements in the configuration.
     */
    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return elements;
    }

    /**
     * <p>
     * The ID of the configuration.
     * </p>
     * 
     * @return The ID of the configuration.
     */
    public final String mediaInsightsPipelineConfigurationId() {
        return mediaInsightsPipelineConfigurationId;
    }

    /**
     * <p>
     * The time at which the configuration was created.
     * </p>
     * 
     * @return The time at which the configuration was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which the configuration was last updated.
     * </p>
     * 
     * @return The time at which the configuration was last updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasElements() ? elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineConfiguration)) {
            return false;
        }
        MediaInsightsPipelineConfiguration other = (MediaInsightsPipelineConfiguration) obj;
        return Objects.equals(mediaInsightsPipelineConfigurationName(), other.mediaInsightsPipelineConfigurationName())
                && Objects.equals(mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn())
                && Objects.equals(resourceAccessRoleArn(), other.resourceAccessRoleArn())
                && Objects.equals(realTimeAlertConfiguration(), other.realTimeAlertConfiguration())
                && hasElements() == other.hasElements() && Objects.equals(elements(), other.elements())
                && Objects.equals(mediaInsightsPipelineConfigurationId(), other.mediaInsightsPipelineConfigurationId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MediaInsightsPipelineConfiguration")
                .add("MediaInsightsPipelineConfigurationName", mediaInsightsPipelineConfigurationName())
                .add("MediaInsightsPipelineConfigurationArn",
                        mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceAccessRoleArn", resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RealTimeAlertConfiguration", realTimeAlertConfiguration())
                .add("Elements", hasElements() ? elements() : null)
                .add("MediaInsightsPipelineConfigurationId", mediaInsightsPipelineConfigurationId())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaInsightsPipelineConfigurationName":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationName()));
        case "MediaInsightsPipelineConfigurationArn":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationArn()));
        case "ResourceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(resourceAccessRoleArn()));
        case "RealTimeAlertConfiguration":
            return Optional.ofNullable(clazz.cast(realTimeAlertConfiguration()));
        case "Elements":
            return Optional.ofNullable(clazz.cast(elements()));
        case "MediaInsightsPipelineConfigurationId":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaInsightsPipelineConfigurationName", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD);
        map.put("MediaInsightsPipelineConfigurationArn", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("RealTimeAlertConfiguration", REAL_TIME_ALERT_CONFIGURATION_FIELD);
        map.put("Elements", ELEMENTS_FIELD);
        map.put("MediaInsightsPipelineConfigurationId", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineConfiguration, T> g) {
        return obj -> g.apply((MediaInsightsPipelineConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaInsightsPipelineConfiguration> {
        /**
         * <p>
         * The name of the configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationName
         *        The name of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName);

        /**
         * <p>
         * The ARN of the configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationArn
         *        The ARN of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn);

        /**
         * <p>
         * The ARN of the role used by the service to access Amazon Web Services resources.
         * </p>
         * 
         * @param resourceAccessRoleArn
         *        The ARN of the role used by the service to access Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRoleArn(String resourceAccessRoleArn);

        /**
         * <p>
         * Lists the rules that trigger a real-time alert.
         * </p>
         * 
         * @param realTimeAlertConfiguration
         *        Lists the rules that trigger a real-time alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration);

        /**
         * <p>
         * Lists the rules that trigger a real-time alert.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeAlertConfiguration.Builder}
         * avoiding the need to create one manually via {@link RealTimeAlertConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeAlertConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #realTimeAlertConfiguration(RealTimeAlertConfiguration)}.
         * 
         * @param realTimeAlertConfiguration
         *        a consumer that will call methods on {@link RealTimeAlertConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realTimeAlertConfiguration(RealTimeAlertConfiguration)
         */
        default Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return realTimeAlertConfiguration(RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)
                    .build());
        }

        /**
         * <p>
         * The elements in the configuration.
         * </p>
         * 
         * @param elements
         *        The elements in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements);

        /**
         * <p>
         * The elements in the configuration.
         * </p>
         * 
         * @param elements
         *        The elements in the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(MediaInsightsPipelineConfigurationElement... elements);

        /**
         * <p>
         * The elements in the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elements(List<MediaInsightsPipelineConfigurationElement>)}.
         * 
         * @param elements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elements(java.util.Collection<MediaInsightsPipelineConfigurationElement>)
         */
        Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements);

        /**
         * <p>
         * The ID of the configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationId
         *        The ID of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId);

        /**
         * <p>
         * The time at which the configuration was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which the configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which the configuration was last updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which the configuration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String mediaInsightsPipelineConfigurationName;

        private String mediaInsightsPipelineConfigurationArn;

        private String resourceAccessRoleArn;

        private RealTimeAlertConfiguration realTimeAlertConfiguration;

        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();

        private String mediaInsightsPipelineConfigurationId;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineConfiguration model) {
            mediaInsightsPipelineConfigurationName(model.mediaInsightsPipelineConfigurationName);
            mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
            resourceAccessRoleArn(model.resourceAccessRoleArn);
            realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            elements(model.elements);
            mediaInsightsPipelineConfigurationId(model.mediaInsightsPipelineConfigurationId);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getMediaInsightsPipelineConfigurationName() {
            return mediaInsightsPipelineConfigurationName;
        }

        public final void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return realTimeAlertConfiguration != null ? realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier
                    .copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement... elements) {
            elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements) {
            elements(Stream.of(elements).map(c -> MediaInsightsPipelineConfigurationElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationId() {
            return mediaInsightsPipelineConfigurationId;
        }

        public final void setMediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public MediaInsightsPipelineConfiguration build() {
            return new MediaInsightsPipelineConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
