/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the media insights pipeline configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaInsightsPipelineConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaInsightsPipelineConfigurationSummary.Builder, MediaInsightsPipelineConfigurationSummary> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationName")
            .getter(getter(MediaInsightsPipelineConfigurationSummary::mediaInsightsPipelineConfigurationName))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationName").build()).build();

    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationId")
            .getter(getter(MediaInsightsPipelineConfigurationSummary::mediaInsightsPipelineConfigurationId))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationId").build()).build();

    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationArn")
            .getter(getter(MediaInsightsPipelineConfigurationSummary::mediaInsightsPipelineConfigurationArn))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD, MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD,
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaInsightsPipelineConfigurationName;

    private final String mediaInsightsPipelineConfigurationId;

    private final String mediaInsightsPipelineConfigurationArn;

    private MediaInsightsPipelineConfigurationSummary(BuilderImpl builder) {
        this.mediaInsightsPipelineConfigurationName = builder.mediaInsightsPipelineConfigurationName;
        this.mediaInsightsPipelineConfigurationId = builder.mediaInsightsPipelineConfigurationId;
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
    }

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     * 
     * @return The name of the media insights pipeline configuration.
     */
    public final String mediaInsightsPipelineConfigurationName() {
        return mediaInsightsPipelineConfigurationName;
    }

    /**
     * <p>
     * The ID of the media insights pipeline configuration.
     * </p>
     * 
     * @return The ID of the media insights pipeline configuration.
     */
    public final String mediaInsightsPipelineConfigurationId() {
        return mediaInsightsPipelineConfigurationId;
    }

    /**
     * <p>
     * The ARN of the media insights pipeline configuration.
     * </p>
     * 
     * @return The ARN of the media insights pipeline configuration.
     */
    public final String mediaInsightsPipelineConfigurationArn() {
        return mediaInsightsPipelineConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineConfigurationSummary)) {
            return false;
        }
        MediaInsightsPipelineConfigurationSummary other = (MediaInsightsPipelineConfigurationSummary) obj;
        return Objects.equals(mediaInsightsPipelineConfigurationName(), other.mediaInsightsPipelineConfigurationName())
                && Objects.equals(mediaInsightsPipelineConfigurationId(), other.mediaInsightsPipelineConfigurationId())
                && Objects.equals(mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MediaInsightsPipelineConfigurationSummary")
                .add("MediaInsightsPipelineConfigurationName", mediaInsightsPipelineConfigurationName())
                .add("MediaInsightsPipelineConfigurationId", mediaInsightsPipelineConfigurationId())
                .add("MediaInsightsPipelineConfigurationArn",
                        mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaInsightsPipelineConfigurationName":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationName()));
        case "MediaInsightsPipelineConfigurationId":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationId()));
        case "MediaInsightsPipelineConfigurationArn":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaInsightsPipelineConfigurationName", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD);
        map.put("MediaInsightsPipelineConfigurationId", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD);
        map.put("MediaInsightsPipelineConfigurationArn", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineConfigurationSummary, T> g) {
        return obj -> g.apply((MediaInsightsPipelineConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaInsightsPipelineConfigurationSummary> {
        /**
         * <p>
         * The name of the media insights pipeline configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationName
         *        The name of the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName);

        /**
         * <p>
         * The ID of the media insights pipeline configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationId
         *        The ID of the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId);

        /**
         * <p>
         * The ARN of the media insights pipeline configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationArn
         *        The ARN of the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn);
    }

    static final class BuilderImpl implements Builder {
        private String mediaInsightsPipelineConfigurationName;

        private String mediaInsightsPipelineConfigurationId;

        private String mediaInsightsPipelineConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineConfigurationSummary model) {
            mediaInsightsPipelineConfigurationName(model.mediaInsightsPipelineConfigurationName);
            mediaInsightsPipelineConfigurationId(model.mediaInsightsPipelineConfigurationId);
            mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
        }

        public final String getMediaInsightsPipelineConfigurationName() {
            return mediaInsightsPipelineConfigurationName;
        }

        public final void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationId() {
            return mediaInsightsPipelineConfigurationId;
        }

        public final void setMediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        @Override
        public MediaInsightsPipelineConfigurationSummary build() {
            return new MediaInsightsPipelineConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
