/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data sink of the configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConcatenationSink implements SdkPojo, Serializable,
        ToCopyableBuilder<ConcatenationSink.Builder, ConcatenationSink> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ConcatenationSink::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<S3BucketSinkConfiguration> S3_BUCKET_SINK_CONFIGURATION_FIELD = SdkField
            .<S3BucketSinkConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3BucketSinkConfiguration")
            .getter(getter(ConcatenationSink::s3BucketSinkConfiguration)).setter(setter(Builder::s3BucketSinkConfiguration))
            .constructor(S3BucketSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSinkConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            S3_BUCKET_SINK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final S3BucketSinkConfiguration s3BucketSinkConfiguration;

    private ConcatenationSink(BuilderImpl builder) {
        this.type = builder.type;
        this.s3BucketSinkConfiguration = builder.s3BucketSinkConfiguration;
    }

    /**
     * <p>
     * The type of data sink in the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConcatenationSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data sink in the configuration object.
     * @see ConcatenationSinkType
     */
    public final ConcatenationSinkType type() {
        return ConcatenationSinkType.fromValue(type);
    }

    /**
     * <p>
     * The type of data sink in the configuration object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConcatenationSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data sink in the configuration object.
     * @see ConcatenationSinkType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration settings for an Amazon S3 bucket sink.
     * </p>
     * 
     * @return The configuration settings for an Amazon S3 bucket sink.
     */
    public final S3BucketSinkConfiguration s3BucketSinkConfiguration() {
        return s3BucketSinkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketSinkConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConcatenationSink)) {
            return false;
        }
        ConcatenationSink other = (ConcatenationSink) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(s3BucketSinkConfiguration(), other.s3BucketSinkConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConcatenationSink").add("Type", typeAsString())
                .add("S3BucketSinkConfiguration", s3BucketSinkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "S3BucketSinkConfiguration":
            return Optional.ofNullable(clazz.cast(s3BucketSinkConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("S3BucketSinkConfiguration", S3_BUCKET_SINK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConcatenationSink, T> g) {
        return obj -> g.apply((ConcatenationSink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConcatenationSink> {
        /**
         * <p>
         * The type of data sink in the configuration object.
         * </p>
         * 
         * @param type
         *        The type of data sink in the configuration object.
         * @see ConcatenationSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConcatenationSinkType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data sink in the configuration object.
         * </p>
         * 
         * @param type
         *        The type of data sink in the configuration object.
         * @see ConcatenationSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConcatenationSinkType
         */
        Builder type(ConcatenationSinkType type);

        /**
         * <p>
         * The configuration settings for an Amazon S3 bucket sink.
         * </p>
         * 
         * @param s3BucketSinkConfiguration
         *        The configuration settings for an Amazon S3 bucket sink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketSinkConfiguration(S3BucketSinkConfiguration s3BucketSinkConfiguration);

        /**
         * <p>
         * The configuration settings for an Amazon S3 bucket sink.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3BucketSinkConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3BucketSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3BucketSinkConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3BucketSinkConfiguration(S3BucketSinkConfiguration)}.
         * 
         * @param s3BucketSinkConfiguration
         *        a consumer that will call methods on {@link S3BucketSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BucketSinkConfiguration(S3BucketSinkConfiguration)
         */
        default Builder s3BucketSinkConfiguration(Consumer<S3BucketSinkConfiguration.Builder> s3BucketSinkConfiguration) {
            return s3BucketSinkConfiguration(S3BucketSinkConfiguration.builder().applyMutation(s3BucketSinkConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private S3BucketSinkConfiguration s3BucketSinkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConcatenationSink model) {
            type(model.type);
            s3BucketSinkConfiguration(model.s3BucketSinkConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConcatenationSinkType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3BucketSinkConfiguration.Builder getS3BucketSinkConfiguration() {
            return s3BucketSinkConfiguration != null ? s3BucketSinkConfiguration.toBuilder() : null;
        }

        public final void setS3BucketSinkConfiguration(S3BucketSinkConfiguration.BuilderImpl s3BucketSinkConfiguration) {
            this.s3BucketSinkConfiguration = s3BucketSinkConfiguration != null ? s3BucketSinkConfiguration.build() : null;
        }

        @Override
        public final Builder s3BucketSinkConfiguration(S3BucketSinkConfiguration s3BucketSinkConfiguration) {
            this.s3BucketSinkConfiguration = s3BucketSinkConfiguration;
            return this;
        }

        @Override
        public ConcatenationSink build() {
            return new ConcatenationSink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
