/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content artifact object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentArtifactsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentArtifactsConfiguration.Builder, ContentArtifactsConfiguration> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ContentArtifactsConfiguration::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> MUX_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MuxType").getter(getter(ContentArtifactsConfiguration::muxTypeAsString))
            .setter(setter(Builder::muxType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MuxType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, MUX_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String muxType;

    private ContentArtifactsConfiguration(BuilderImpl builder) {
        this.state = builder.state;
        this.muxType = builder.muxType;
    }

    /**
     * <p>
     * Indicates whether the content artifact is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArtifactsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates whether the content artifact is enabled or disabled.
     * @see ArtifactsState
     */
    public final ArtifactsState state() {
        return ArtifactsState.fromValue(state);
    }

    /**
     * <p>
     * Indicates whether the content artifact is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ArtifactsState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Indicates whether the content artifact is enabled or disabled.
     * @see ArtifactsState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The MUX type of the artifact configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #muxType} will
     * return {@link ContentMuxType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #muxTypeAsString}.
     * </p>
     * 
     * @return The MUX type of the artifact configuration.
     * @see ContentMuxType
     */
    public final ContentMuxType muxType() {
        return ContentMuxType.fromValue(muxType);
    }

    /**
     * <p>
     * The MUX type of the artifact configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #muxType} will
     * return {@link ContentMuxType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #muxTypeAsString}.
     * </p>
     * 
     * @return The MUX type of the artifact configuration.
     * @see ContentMuxType
     */
    public final String muxTypeAsString() {
        return muxType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(muxTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentArtifactsConfiguration)) {
            return false;
        }
        ContentArtifactsConfiguration other = (ContentArtifactsConfiguration) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(muxTypeAsString(), other.muxTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentArtifactsConfiguration").add("State", stateAsString()).add("MuxType", muxTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "MuxType":
            return Optional.ofNullable(clazz.cast(muxTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("MuxType", MUX_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentArtifactsConfiguration, T> g) {
        return obj -> g.apply((ContentArtifactsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentArtifactsConfiguration> {
        /**
         * <p>
         * Indicates whether the content artifact is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Indicates whether the content artifact is enabled or disabled.
         * @see ArtifactsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsState
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates whether the content artifact is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Indicates whether the content artifact is enabled or disabled.
         * @see ArtifactsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArtifactsState
         */
        Builder state(ArtifactsState state);

        /**
         * <p>
         * The MUX type of the artifact configuration.
         * </p>
         * 
         * @param muxType
         *        The MUX type of the artifact configuration.
         * @see ContentMuxType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentMuxType
         */
        Builder muxType(String muxType);

        /**
         * <p>
         * The MUX type of the artifact configuration.
         * </p>
         * 
         * @param muxType
         *        The MUX type of the artifact configuration.
         * @see ContentMuxType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentMuxType
         */
        Builder muxType(ContentMuxType muxType);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String muxType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContentArtifactsConfiguration model) {
            state(model.state);
            muxType(model.muxType);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ArtifactsState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getMuxType() {
            return muxType;
        }

        public final void setMuxType(String muxType) {
            this.muxType = muxType;
        }

        @Override
        public final Builder muxType(String muxType) {
            this.muxType = muxType;
            return this;
        }

        @Override
        public final Builder muxType(ContentMuxType muxType) {
            this.muxType(muxType == null ? null : muxType.toString());
            return this;
        }

        @Override
        public ContentArtifactsConfiguration build() {
            return new ContentArtifactsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
