/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaInsightsPipelineConfigurationRequest extends ChimeSdkMediaPipelinesRequest
        implements
        ToCopyableBuilder<CreateMediaInsightsPipelineConfigurationRequest.Builder, CreateMediaInsightsPipelineConfigurationRequest> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MediaInsightsPipelineConfigurationName")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::mediaInsightsPipelineConfigurationName))
            .setter(setter(Builder::mediaInsightsPipelineConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MediaInsightsPipelineConfigurationName").build()).build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAccessRoleArn")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::resourceAccessRoleArn))
            .setter(setter(Builder::resourceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build())
            .build();

    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField
            .<RealTimeAlertConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RealTimeAlertConfiguration")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::realTimeAlertConfiguration))
            .setter(setter(Builder::realTimeAlertConfiguration))
            .constructor(RealTimeAlertConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build())
            .build();

    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField
            .<List<MediaInsightsPipelineConfigurationElement>> builder(MarshallingType.LIST)
            .memberName("Elements")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::elements))
            .setter(setter(Builder::elements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaInsightsPipelineConfigurationElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaInsightsPipelineConfigurationElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMediaInsightsPipelineConfigurationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD,
            REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String mediaInsightsPipelineConfigurationName;

    private final String resourceAccessRoleArn;

    private final RealTimeAlertConfiguration realTimeAlertConfiguration;

    private final List<MediaInsightsPipelineConfigurationElement> elements;

    private final List<Tag> tags;

    private final String clientRequestToken;

    private CreateMediaInsightsPipelineConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurationName = builder.mediaInsightsPipelineConfigurationName;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the media insights pipeline configuration.
     * </p>
     * 
     * @return The name of the media insights pipeline configuration.
     */
    public final String mediaInsightsPipelineConfigurationName() {
        return mediaInsightsPipelineConfigurationName;
    }

    /**
     * <p>
     * The ARN of the role used by the service to access Amazon Web Services resources, including
     * <code>Transcribe</code> and <code>Transcribe Call Analytics</code>, on the caller’s behalf.
     * </p>
     * 
     * @return The ARN of the role used by the service to access Amazon Web Services resources, including
     *         <code>Transcribe</code> and <code>Transcribe Call Analytics</code>, on the caller’s behalf.
     */
    public final String resourceAccessRoleArn() {
        return resourceAccessRoleArn;
    }

    /**
     * <p>
     * The configuration settings for the real-time alerts in a media insights pipeline configuration.
     * </p>
     * 
     * @return The configuration settings for the real-time alerts in a media insights pipeline configuration.
     */
    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return realTimeAlertConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Elements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElements() {
        return elements != null && !(elements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElements} method.
     * </p>
     * 
     * @return The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
     *         Stream.
     */
    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return elements;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the media insights pipeline configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the media insights pipeline configuration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The unique identifier for the media insights pipeline configuration request.
     * </p>
     * 
     * @return The unique identifier for the media insights pipeline configuration request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipelineConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasElements() ? elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaInsightsPipelineConfigurationRequest)) {
            return false;
        }
        CreateMediaInsightsPipelineConfigurationRequest other = (CreateMediaInsightsPipelineConfigurationRequest) obj;
        return Objects.equals(mediaInsightsPipelineConfigurationName(), other.mediaInsightsPipelineConfigurationName())
                && Objects.equals(resourceAccessRoleArn(), other.resourceAccessRoleArn())
                && Objects.equals(realTimeAlertConfiguration(), other.realTimeAlertConfiguration())
                && hasElements() == other.hasElements() && Objects.equals(elements(), other.elements())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaInsightsPipelineConfigurationRequest")
                .add("MediaInsightsPipelineConfigurationName", mediaInsightsPipelineConfigurationName())
                .add("ResourceAccessRoleArn", resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RealTimeAlertConfiguration", realTimeAlertConfiguration())
                .add("Elements", hasElements() ? elements() : null).add("Tags", hasTags() ? tags() : null)
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaInsightsPipelineConfigurationName":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipelineConfigurationName()));
        case "ResourceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(resourceAccessRoleArn()));
        case "RealTimeAlertConfiguration":
            return Optional.ofNullable(clazz.cast(realTimeAlertConfiguration()));
        case "Elements":
            return Optional.ofNullable(clazz.cast(elements()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaInsightsPipelineConfigurationName", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("RealTimeAlertConfiguration", REAL_TIME_ALERT_CONFIGURATION_FIELD);
        map.put("Elements", ELEMENTS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaInsightsPipelineConfigurationRequest, T> g) {
        return obj -> g.apply((CreateMediaInsightsPipelineConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaInsightsPipelineConfigurationRequest> {
        /**
         * <p>
         * The name of the media insights pipeline configuration.
         * </p>
         * 
         * @param mediaInsightsPipelineConfigurationName
         *        The name of the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName);

        /**
         * <p>
         * The ARN of the role used by the service to access Amazon Web Services resources, including
         * <code>Transcribe</code> and <code>Transcribe Call Analytics</code>, on the caller’s behalf.
         * </p>
         * 
         * @param resourceAccessRoleArn
         *        The ARN of the role used by the service to access Amazon Web Services resources, including
         *        <code>Transcribe</code> and <code>Transcribe Call Analytics</code>, on the caller’s behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRoleArn(String resourceAccessRoleArn);

        /**
         * <p>
         * The configuration settings for the real-time alerts in a media insights pipeline configuration.
         * </p>
         * 
         * @param realTimeAlertConfiguration
         *        The configuration settings for the real-time alerts in a media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration);

        /**
         * <p>
         * The configuration settings for the real-time alerts in a media insights pipeline configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeAlertConfiguration.Builder}
         * avoiding the need to create one manually via {@link RealTimeAlertConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeAlertConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #realTimeAlertConfiguration(RealTimeAlertConfiguration)}.
         * 
         * @param realTimeAlertConfiguration
         *        a consumer that will call methods on {@link RealTimeAlertConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realTimeAlertConfiguration(RealTimeAlertConfiguration)
         */
        default Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return realTimeAlertConfiguration(RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)
                    .build());
        }

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream.
         * </p>
         * 
         * @param elements
         *        The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
         *        Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements);

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream.
         * </p>
         * 
         * @param elements
         *        The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
         *        Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(MediaInsightsPipelineConfigurationElement... elements);

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elements(List<MediaInsightsPipelineConfigurationElement>)}.
         * 
         * @param elements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elements(java.util.Collection<MediaInsightsPipelineConfigurationElement>)
         */
        Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements);

        /**
         * <p>
         * The tags assigned to the media insights pipeline configuration.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the media insights pipeline configuration.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the media insights pipeline configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The unique identifier for the media insights pipeline configuration request.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the media insights pipeline configuration request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String mediaInsightsPipelineConfigurationName;

        private String resourceAccessRoleArn;

        private RealTimeAlertConfiguration realTimeAlertConfiguration;

        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaInsightsPipelineConfigurationRequest model) {
            super(model);
            mediaInsightsPipelineConfigurationName(model.mediaInsightsPipelineConfigurationName);
            resourceAccessRoleArn(model.resourceAccessRoleArn);
            realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            elements(model.elements);
            tags(model.tags);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getMediaInsightsPipelineConfigurationName() {
            return mediaInsightsPipelineConfigurationName;
        }

        public final void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return realTimeAlertConfiguration != null ? realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier
                    .copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement... elements) {
            elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements) {
            elements(Stream.of(elements).map(c -> MediaInsightsPipelineConfigurationElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaInsightsPipelineConfigurationRequest build() {
            return new CreateMediaInsightsPipelineConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
