/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMediaStreamPipelineRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<CreateMediaStreamPipelineRequest.Builder, CreateMediaStreamPipelineRequest> {
    private static final SdkField<List<MediaStreamSource>> SOURCES_FIELD = SdkField
            .<List<MediaStreamSource>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(CreateMediaStreamPipelineRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStreamSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStreamSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MediaStreamSink>> SINKS_FIELD = SdkField
            .<List<MediaStreamSink>> builder(MarshallingType.LIST)
            .memberName("Sinks")
            .getter(getter(CreateMediaStreamPipelineRequest::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaStreamSink> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaStreamSink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateMediaStreamPipelineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMediaStreamPipelineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, SINKS_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MediaStreamSource> sources;

    private final List<MediaStreamSink> sinks;

    private final String clientRequestToken;

    private final List<Tag> tags;

    private CreateMediaStreamPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.sources = builder.sources;
        this.sinks = builder.sinks;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sources for the media pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The data sources for the media pipeline.
     */
    public final List<MediaStreamSource> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sinks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sink for the media pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSinks} method.
     * </p>
     * 
     * @return The data sink for the media pipeline.
     */
    public final List<MediaStreamSink> sinks() {
        return sinks;
    }

    /**
     * <p>
     * The token assigned to the client making the request.
     * </p>
     * 
     * @return The token assigned to the client making the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the media pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the media pipeline.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSinks() ? sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaStreamPipelineRequest)) {
            return false;
        }
        CreateMediaStreamPipelineRequest other = (CreateMediaStreamPipelineRequest) obj;
        return hasSources() == other.hasSources() && Objects.equals(sources(), other.sources()) && hasSinks() == other.hasSinks()
                && Objects.equals(sinks(), other.sinks()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMediaStreamPipelineRequest").add("Sources", hasSources() ? sources() : null)
                .add("Sinks", hasSinks() ? sinks() : null)
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Sources", SOURCES_FIELD);
        map.put("Sinks", SINKS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaStreamPipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaStreamPipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMediaStreamPipelineRequest> {
        /**
         * <p>
         * The data sources for the media pipeline.
         * </p>
         * 
         * @param sources
         *        The data sources for the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<MediaStreamSource> sources);

        /**
         * <p>
         * The data sources for the media pipeline.
         * </p>
         * 
         * @param sources
         *        The data sources for the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(MediaStreamSource... sources);

        /**
         * <p>
         * The data sources for the media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource.Builder#build()} is
         * called immediately and its result is passed to {@link #sources(List<MediaStreamSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<MediaStreamSource>)
         */
        Builder sources(Consumer<MediaStreamSource.Builder>... sources);

        /**
         * <p>
         * The data sink for the media pipeline.
         * </p>
         * 
         * @param sinks
         *        The data sink for the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<MediaStreamSink> sinks);

        /**
         * <p>
         * The data sink for the media pipeline.
         * </p>
         * 
         * @param sinks
         *        The data sink for the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(MediaStreamSink... sinks);

        /**
         * <p>
         * The data sink for the media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink.Builder#build()} is
         * called immediately and its result is passed to {@link #sinks(List<MediaStreamSink>)}.
         * 
         * @param sinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaStreamSink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sinks(java.util.Collection<MediaStreamSink>)
         */
        Builder sinks(Consumer<MediaStreamSink.Builder>... sinks);

        /**
         * <p>
         * The token assigned to the client making the request.
         * </p>
         * 
         * @param clientRequestToken
         *        The token assigned to the client making the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The tags assigned to the media pipeline.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the media pipeline.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private List<MediaStreamSource> sources = DefaultSdkAutoConstructList.getInstance();

        private List<MediaStreamSink> sinks = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaStreamPipelineRequest model) {
            super(model);
            sources(model.sources);
            sinks(model.sinks);
            clientRequestToken(model.clientRequestToken);
            tags(model.tags);
        }

        public final List<MediaStreamSource.Builder> getSources() {
            List<MediaStreamSource.Builder> result = MediaStreamSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<MediaStreamSource.BuilderImpl> sources) {
            this.sources = MediaStreamSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<MediaStreamSource> sources) {
            this.sources = MediaStreamSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(MediaStreamSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<MediaStreamSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> MediaStreamSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MediaStreamSink.Builder> getSinks() {
            List<MediaStreamSink.Builder> result = MediaStreamSinkListCopier.copyToBuilder(this.sinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSinks(Collection<MediaStreamSink.BuilderImpl> sinks) {
            this.sinks = MediaStreamSinkListCopier.copyFromBuilder(sinks);
        }

        @Override
        public final Builder sinks(Collection<MediaStreamSink> sinks) {
            this.sinks = MediaStreamSinkListCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(MediaStreamSink... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<MediaStreamSink.Builder>... sinks) {
            sinks(Stream.of(sinks).map(c -> MediaStreamSink.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaStreamPipelineRequest build() {
            return new CreateMediaStreamPipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
