/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The task configuration settings for the Kinesis video stream source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisVideoStreamSourceTaskConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisVideoStreamSourceTaskConfiguration.Builder, KinesisVideoStreamSourceTaskConfiguration> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(KinesisVideoStreamSourceTaskConfiguration::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<Integer> CHANNEL_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChannelId").getter(getter(KinesisVideoStreamSourceTaskConfiguration::channelId))
            .setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()).build();

    private static final SdkField<String> FRAGMENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentNumber").getter(getter(KinesisVideoStreamSourceTaskConfiguration::fragmentNumber))
            .setter(setter(Builder::fragmentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            CHANNEL_ID_FIELD, FRAGMENT_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final Integer channelId;

    private final String fragmentNumber;

    private KinesisVideoStreamSourceTaskConfiguration(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.channelId = builder.channelId;
        this.fragmentNumber = builder.fragmentNumber;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The channel ID.
     * </p>
     * 
     * @return The channel ID.
     */
    public final Integer channelId() {
        return channelId;
    }

    /**
     * <p>
     * The unique identifier of the fragment to begin processing.
     * </p>
     * 
     * @return The unique identifier of the fragment to begin processing.
     */
    public final String fragmentNumber() {
        return fragmentNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisVideoStreamSourceTaskConfiguration)) {
            return false;
        }
        KinesisVideoStreamSourceTaskConfiguration other = (KinesisVideoStreamSourceTaskConfiguration) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(channelId(), other.channelId())
                && Objects.equals(fragmentNumber(), other.fragmentNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisVideoStreamSourceTaskConfiguration").add("StreamArn", streamArn())
                .add("ChannelId", channelId()).add("FragmentNumber", fragmentNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "FragmentNumber":
            return Optional.ofNullable(clazz.cast(fragmentNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamArn", STREAM_ARN_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("FragmentNumber", FRAGMENT_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisVideoStreamSourceTaskConfiguration, T> g) {
        return obj -> g.apply((KinesisVideoStreamSourceTaskConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisVideoStreamSourceTaskConfiguration> {
        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The channel ID.
         * </p>
         * 
         * @param channelId
         *        The channel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(Integer channelId);

        /**
         * <p>
         * The unique identifier of the fragment to begin processing.
         * </p>
         * 
         * @param fragmentNumber
         *        The unique identifier of the fragment to begin processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentNumber(String fragmentNumber);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private Integer channelId;

        private String fragmentNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisVideoStreamSourceTaskConfiguration model) {
            streamArn(model.streamArn);
            channelId(model.channelId);
            fragmentNumber(model.fragmentNumber);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final Integer getChannelId() {
            return channelId;
        }

        public final void setChannelId(Integer channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(Integer channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getFragmentNumber() {
            return fragmentNumber;
        }

        public final void setFragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
        }

        @Override
        public final Builder fragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        @Override
        public KinesisVideoStreamSourceTaskConfiguration build() {
            return new KinesisVideoStreamSourceTaskConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
