/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media pipeline's RTMP configuration object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveConnectorRTMPConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveConnectorRTMPConfiguration.Builder, LiveConnectorRTMPConfiguration> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(LiveConnectorRTMPConfiguration::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> AUDIO_CHANNELS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioChannels").getter(getter(LiveConnectorRTMPConfiguration::audioChannelsAsString))
            .setter(setter(Builder::audioChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChannels").build()).build();

    private static final SdkField<String> AUDIO_SAMPLE_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioSampleRate").getter(getter(LiveConnectorRTMPConfiguration::audioSampleRate))
            .setter(setter(Builder::audioSampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioSampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            AUDIO_CHANNELS_FIELD, AUDIO_SAMPLE_RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String audioChannels;

    private final String audioSampleRate;

    private LiveConnectorRTMPConfiguration(BuilderImpl builder) {
        this.url = builder.url;
        this.audioChannels = builder.audioChannels;
        this.audioSampleRate = builder.audioSampleRate;
    }

    /**
     * <p>
     * The URL of the RTMP configuration.
     * </p>
     * 
     * @return The URL of the RTMP configuration.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The audio channels set for the RTMP configuration
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioChannels}
     * will return {@link AudioChannelsOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioChannelsAsString}.
     * </p>
     * 
     * @return The audio channels set for the RTMP configuration
     * @see AudioChannelsOption
     */
    public final AudioChannelsOption audioChannels() {
        return AudioChannelsOption.fromValue(audioChannels);
    }

    /**
     * <p>
     * The audio channels set for the RTMP configuration
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioChannels}
     * will return {@link AudioChannelsOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioChannelsAsString}.
     * </p>
     * 
     * @return The audio channels set for the RTMP configuration
     * @see AudioChannelsOption
     */
    public final String audioChannelsAsString() {
        return audioChannels;
    }

    /**
     * <p>
     * The audio sample rate set for the RTMP configuration. Default: 48000.
     * </p>
     * 
     * @return The audio sample rate set for the RTMP configuration. Default: 48000.
     */
    public final String audioSampleRate() {
        return audioSampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(audioChannelsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioSampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveConnectorRTMPConfiguration)) {
            return false;
        }
        LiveConnectorRTMPConfiguration other = (LiveConnectorRTMPConfiguration) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(audioChannelsAsString(), other.audioChannelsAsString())
                && Objects.equals(audioSampleRate(), other.audioSampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveConnectorRTMPConfiguration")
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AudioChannels", audioChannelsAsString()).add("AudioSampleRate", audioSampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "AudioChannels":
            return Optional.ofNullable(clazz.cast(audioChannelsAsString()));
        case "AudioSampleRate":
            return Optional.ofNullable(clazz.cast(audioSampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("AudioChannels", AUDIO_CHANNELS_FIELD);
        map.put("AudioSampleRate", AUDIO_SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveConnectorRTMPConfiguration, T> g) {
        return obj -> g.apply((LiveConnectorRTMPConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveConnectorRTMPConfiguration> {
        /**
         * <p>
         * The URL of the RTMP configuration.
         * </p>
         * 
         * @param url
         *        The URL of the RTMP configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The audio channels set for the RTMP configuration
         * </p>
         * 
         * @param audioChannels
         *        The audio channels set for the RTMP configuration
         * @see AudioChannelsOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelsOption
         */
        Builder audioChannels(String audioChannels);

        /**
         * <p>
         * The audio channels set for the RTMP configuration
         * </p>
         * 
         * @param audioChannels
         *        The audio channels set for the RTMP configuration
         * @see AudioChannelsOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioChannelsOption
         */
        Builder audioChannels(AudioChannelsOption audioChannels);

        /**
         * <p>
         * The audio sample rate set for the RTMP configuration. Default: 48000.
         * </p>
         * 
         * @param audioSampleRate
         *        The audio sample rate set for the RTMP configuration. Default: 48000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSampleRate(String audioSampleRate);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String audioChannels;

        private String audioSampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveConnectorRTMPConfiguration model) {
            url(model.url);
            audioChannels(model.audioChannels);
            audioSampleRate(model.audioSampleRate);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getAudioChannels() {
            return audioChannels;
        }

        public final void setAudioChannels(String audioChannels) {
            this.audioChannels = audioChannels;
        }

        @Override
        public final Builder audioChannels(String audioChannels) {
            this.audioChannels = audioChannels;
            return this;
        }

        @Override
        public final Builder audioChannels(AudioChannelsOption audioChannels) {
            this.audioChannels(audioChannels == null ? null : audioChannels.toString());
            return this;
        }

        public final String getAudioSampleRate() {
            return audioSampleRate;
        }

        public final void setAudioSampleRate(String audioSampleRate) {
            this.audioSampleRate = audioSampleRate;
        }

        @Override
        public final Builder audioSampleRate(String audioSampleRate) {
            this.audioSampleRate = audioSampleRate;
            return this;
        }

        @Override
        public LiveConnectorRTMPConfiguration build() {
            return new LiveConnectorRTMPConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
