/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An element in a media insights pipeline configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaInsightsPipelineConfigurationElement implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaInsightsPipelineConfigurationElement.Builder, MediaInsightsPipelineConfigurationElement> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MediaInsightsPipelineConfigurationElement::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AmazonTranscribeCallAnalyticsProcessorConfiguration> AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD = SdkField
            .<AmazonTranscribeCallAnalyticsProcessorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonTranscribeCallAnalyticsProcessorConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::amazonTranscribeCallAnalyticsProcessorConfiguration))
            .setter(setter(Builder::amazonTranscribeCallAnalyticsProcessorConfiguration))
            .constructor(AmazonTranscribeCallAnalyticsProcessorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonTranscribeCallAnalyticsProcessorConfiguration").build()).build();

    private static final SdkField<AmazonTranscribeProcessorConfiguration> AMAZON_TRANSCRIBE_PROCESSOR_CONFIGURATION_FIELD = SdkField
            .<AmazonTranscribeProcessorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AmazonTranscribeProcessorConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::amazonTranscribeProcessorConfiguration))
            .setter(setter(Builder::amazonTranscribeProcessorConfiguration))
            .constructor(AmazonTranscribeProcessorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AmazonTranscribeProcessorConfiguration").build()).build();

    private static final SdkField<KinesisDataStreamSinkConfiguration> KINESIS_DATA_STREAM_SINK_CONFIGURATION_FIELD = SdkField
            .<KinesisDataStreamSinkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisDataStreamSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::kinesisDataStreamSinkConfiguration))
            .setter(setter(Builder::kinesisDataStreamSinkConfiguration))
            .constructor(KinesisDataStreamSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisDataStreamSinkConfiguration")
                    .build()).build();

    private static final SdkField<S3RecordingSinkConfiguration> S3_RECORDING_SINK_CONFIGURATION_FIELD = SdkField
            .<S3RecordingSinkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("S3RecordingSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::s3RecordingSinkConfiguration))
            .setter(setter(Builder::s3RecordingSinkConfiguration))
            .constructor(S3RecordingSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3RecordingSinkConfiguration")
                    .build()).build();

    private static final SdkField<VoiceAnalyticsProcessorConfiguration> VOICE_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD = SdkField
            .<VoiceAnalyticsProcessorConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceAnalyticsProcessorConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::voiceAnalyticsProcessorConfiguration))
            .setter(setter(Builder::voiceAnalyticsProcessorConfiguration))
            .constructor(VoiceAnalyticsProcessorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("VoiceAnalyticsProcessorConfiguration").build()).build();

    private static final SdkField<LambdaFunctionSinkConfiguration> LAMBDA_FUNCTION_SINK_CONFIGURATION_FIELD = SdkField
            .<LambdaFunctionSinkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaFunctionSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::lambdaFunctionSinkConfiguration))
            .setter(setter(Builder::lambdaFunctionSinkConfiguration))
            .constructor(LambdaFunctionSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionSinkConfiguration")
                    .build()).build();

    private static final SdkField<SqsQueueSinkConfiguration> SQS_QUEUE_SINK_CONFIGURATION_FIELD = SdkField
            .<SqsQueueSinkConfiguration> builder(MarshallingType.SDK_POJO).memberName("SqsQueueSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::sqsQueueSinkConfiguration))
            .setter(setter(Builder::sqsQueueSinkConfiguration)).constructor(SqsQueueSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueSinkConfiguration").build())
            .build();

    private static final SdkField<SnsTopicSinkConfiguration> SNS_TOPIC_SINK_CONFIGURATION_FIELD = SdkField
            .<SnsTopicSinkConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnsTopicSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::snsTopicSinkConfiguration))
            .setter(setter(Builder::snsTopicSinkConfiguration)).constructor(SnsTopicSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicSinkConfiguration").build())
            .build();

    private static final SdkField<VoiceEnhancementSinkConfiguration> VOICE_ENHANCEMENT_SINK_CONFIGURATION_FIELD = SdkField
            .<VoiceEnhancementSinkConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceEnhancementSinkConfiguration")
            .getter(getter(MediaInsightsPipelineConfigurationElement::voiceEnhancementSinkConfiguration))
            .setter(setter(Builder::voiceEnhancementSinkConfiguration))
            .constructor(VoiceEnhancementSinkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceEnhancementSinkConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD, AMAZON_TRANSCRIBE_PROCESSOR_CONFIGURATION_FIELD,
            KINESIS_DATA_STREAM_SINK_CONFIGURATION_FIELD, S3_RECORDING_SINK_CONFIGURATION_FIELD,
            VOICE_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD, LAMBDA_FUNCTION_SINK_CONFIGURATION_FIELD,
            SQS_QUEUE_SINK_CONFIGURATION_FIELD, SNS_TOPIC_SINK_CONFIGURATION_FIELD, VOICE_ENHANCEMENT_SINK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration;

    private final AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration;

    private final KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration;

    private final S3RecordingSinkConfiguration s3RecordingSinkConfiguration;

    private final VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration;

    private final LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration;

    private final SqsQueueSinkConfiguration sqsQueueSinkConfiguration;

    private final SnsTopicSinkConfiguration snsTopicSinkConfiguration;

    private final VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration;

    private MediaInsightsPipelineConfigurationElement(BuilderImpl builder) {
        this.type = builder.type;
        this.amazonTranscribeCallAnalyticsProcessorConfiguration = builder.amazonTranscribeCallAnalyticsProcessorConfiguration;
        this.amazonTranscribeProcessorConfiguration = builder.amazonTranscribeProcessorConfiguration;
        this.kinesisDataStreamSinkConfiguration = builder.kinesisDataStreamSinkConfiguration;
        this.s3RecordingSinkConfiguration = builder.s3RecordingSinkConfiguration;
        this.voiceAnalyticsProcessorConfiguration = builder.voiceAnalyticsProcessorConfiguration;
        this.lambdaFunctionSinkConfiguration = builder.lambdaFunctionSinkConfiguration;
        this.sqsQueueSinkConfiguration = builder.sqsQueueSinkConfiguration;
        this.snsTopicSinkConfiguration = builder.snsTopicSinkConfiguration;
        this.voiceEnhancementSinkConfiguration = builder.voiceEnhancementSinkConfiguration;
    }

    /**
     * <p>
     * The element type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaInsightsPipelineConfigurationElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The element type.
     * @see MediaInsightsPipelineConfigurationElementType
     */
    public final MediaInsightsPipelineConfigurationElementType type() {
        return MediaInsightsPipelineConfigurationElementType.fromValue(type);
    }

    /**
     * <p>
     * The element type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MediaInsightsPipelineConfigurationElementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The element type.
     * @see MediaInsightsPipelineConfigurationElementType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The analytics configuration settings for transcribing audio in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The analytics configuration settings for transcribing audio in a media insights pipeline configuration
     *         element.
     */
    public final AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration() {
        return amazonTranscribeCallAnalyticsProcessorConfiguration;
    }

    /**
     * <p>
     * The transcription processor configuration settings in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The transcription processor configuration settings in a media insights pipeline configuration element.
     */
    public final AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration() {
        return amazonTranscribeProcessorConfiguration;
    }

    /**
     * <p>
     * The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration
     *         element.
     */
    public final KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration() {
        return kinesisDataStreamSinkConfiguration;
    }

    /**
     * <p>
     * The configuration settings for the Amazon S3 recording bucket in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The configuration settings for the Amazon S3 recording bucket in a media insights pipeline configuration
     *         element.
     */
    public final S3RecordingSinkConfiguration s3RecordingSinkConfiguration() {
        return s3RecordingSinkConfiguration;
    }

    /**
     * <p>
     * The voice analytics configuration settings in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The voice analytics configuration settings in a media insights pipeline configuration element.
     */
    public final VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration() {
        return voiceAnalyticsProcessorConfiguration;
    }

    /**
     * <p>
     * The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline configuration
     * element.
     * </p>
     * 
     * @return The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline
     *         configuration element.
     */
    public final LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration() {
        return lambdaFunctionSinkConfiguration;
    }

    /**
     * <p>
     * The configuration settings for an SQS queue sink in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The configuration settings for an SQS queue sink in a media insights pipeline configuration element.
     */
    public final SqsQueueSinkConfiguration sqsQueueSinkConfiguration() {
        return sqsQueueSinkConfiguration;
    }

    /**
     * <p>
     * The configuration settings for an SNS topic sink in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The configuration settings for an SNS topic sink in a media insights pipeline configuration element.
     */
    public final SnsTopicSinkConfiguration snsTopicSinkConfiguration() {
        return snsTopicSinkConfiguration;
    }

    /**
     * <p>
     * The configuration settings for voice enhancement sink in a media insights pipeline configuration element.
     * </p>
     * 
     * @return The configuration settings for voice enhancement sink in a media insights pipeline configuration element.
     */
    public final VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration() {
        return voiceEnhancementSinkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonTranscribeCallAnalyticsProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(amazonTranscribeProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisDataStreamSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3RecordingSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(voiceAnalyticsProcessorConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicSinkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(voiceEnhancementSinkConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineConfigurationElement)) {
            return false;
        }
        MediaInsightsPipelineConfigurationElement other = (MediaInsightsPipelineConfigurationElement) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(amazonTranscribeCallAnalyticsProcessorConfiguration(),
                        other.amazonTranscribeCallAnalyticsProcessorConfiguration())
                && Objects.equals(amazonTranscribeProcessorConfiguration(), other.amazonTranscribeProcessorConfiguration())
                && Objects.equals(kinesisDataStreamSinkConfiguration(), other.kinesisDataStreamSinkConfiguration())
                && Objects.equals(s3RecordingSinkConfiguration(), other.s3RecordingSinkConfiguration())
                && Objects.equals(voiceAnalyticsProcessorConfiguration(), other.voiceAnalyticsProcessorConfiguration())
                && Objects.equals(lambdaFunctionSinkConfiguration(), other.lambdaFunctionSinkConfiguration())
                && Objects.equals(sqsQueueSinkConfiguration(), other.sqsQueueSinkConfiguration())
                && Objects.equals(snsTopicSinkConfiguration(), other.snsTopicSinkConfiguration())
                && Objects.equals(voiceEnhancementSinkConfiguration(), other.voiceEnhancementSinkConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MediaInsightsPipelineConfigurationElement")
                .add("Type", typeAsString())
                .add("AmazonTranscribeCallAnalyticsProcessorConfiguration", amazonTranscribeCallAnalyticsProcessorConfiguration())
                .add("AmazonTranscribeProcessorConfiguration", amazonTranscribeProcessorConfiguration())
                .add("KinesisDataStreamSinkConfiguration", kinesisDataStreamSinkConfiguration())
                .add("S3RecordingSinkConfiguration", s3RecordingSinkConfiguration())
                .add("VoiceAnalyticsProcessorConfiguration", voiceAnalyticsProcessorConfiguration())
                .add("LambdaFunctionSinkConfiguration", lambdaFunctionSinkConfiguration())
                .add("SqsQueueSinkConfiguration", sqsQueueSinkConfiguration())
                .add("SnsTopicSinkConfiguration", snsTopicSinkConfiguration())
                .add("VoiceEnhancementSinkConfiguration", voiceEnhancementSinkConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AmazonTranscribeCallAnalyticsProcessorConfiguration":
            return Optional.ofNullable(clazz.cast(amazonTranscribeCallAnalyticsProcessorConfiguration()));
        case "AmazonTranscribeProcessorConfiguration":
            return Optional.ofNullable(clazz.cast(amazonTranscribeProcessorConfiguration()));
        case "KinesisDataStreamSinkConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisDataStreamSinkConfiguration()));
        case "S3RecordingSinkConfiguration":
            return Optional.ofNullable(clazz.cast(s3RecordingSinkConfiguration()));
        case "VoiceAnalyticsProcessorConfiguration":
            return Optional.ofNullable(clazz.cast(voiceAnalyticsProcessorConfiguration()));
        case "LambdaFunctionSinkConfiguration":
            return Optional.ofNullable(clazz.cast(lambdaFunctionSinkConfiguration()));
        case "SqsQueueSinkConfiguration":
            return Optional.ofNullable(clazz.cast(sqsQueueSinkConfiguration()));
        case "SnsTopicSinkConfiguration":
            return Optional.ofNullable(clazz.cast(snsTopicSinkConfiguration()));
        case "VoiceEnhancementSinkConfiguration":
            return Optional.ofNullable(clazz.cast(voiceEnhancementSinkConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("AmazonTranscribeCallAnalyticsProcessorConfiguration",
                AMAZON_TRANSCRIBE_CALL_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD);
        map.put("AmazonTranscribeProcessorConfiguration", AMAZON_TRANSCRIBE_PROCESSOR_CONFIGURATION_FIELD);
        map.put("KinesisDataStreamSinkConfiguration", KINESIS_DATA_STREAM_SINK_CONFIGURATION_FIELD);
        map.put("S3RecordingSinkConfiguration", S3_RECORDING_SINK_CONFIGURATION_FIELD);
        map.put("VoiceAnalyticsProcessorConfiguration", VOICE_ANALYTICS_PROCESSOR_CONFIGURATION_FIELD);
        map.put("LambdaFunctionSinkConfiguration", LAMBDA_FUNCTION_SINK_CONFIGURATION_FIELD);
        map.put("SqsQueueSinkConfiguration", SQS_QUEUE_SINK_CONFIGURATION_FIELD);
        map.put("SnsTopicSinkConfiguration", SNS_TOPIC_SINK_CONFIGURATION_FIELD);
        map.put("VoiceEnhancementSinkConfiguration", VOICE_ENHANCEMENT_SINK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineConfigurationElement, T> g) {
        return obj -> g.apply((MediaInsightsPipelineConfigurationElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaInsightsPipelineConfigurationElement> {
        /**
         * <p>
         * The element type.
         * </p>
         * 
         * @param type
         *        The element type.
         * @see MediaInsightsPipelineConfigurationElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaInsightsPipelineConfigurationElementType
         */
        Builder type(String type);

        /**
         * <p>
         * The element type.
         * </p>
         * 
         * @param type
         *        The element type.
         * @see MediaInsightsPipelineConfigurationElementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaInsightsPipelineConfigurationElementType
         */
        Builder type(MediaInsightsPipelineConfigurationElementType type);

        /**
         * <p>
         * The analytics configuration settings for transcribing audio in a media insights pipeline configuration
         * element.
         * </p>
         * 
         * @param amazonTranscribeCallAnalyticsProcessorConfiguration
         *        The analytics configuration settings for transcribing audio in a media insights pipeline configuration
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonTranscribeCallAnalyticsProcessorConfiguration(
                AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration);

        /**
         * <p>
         * The analytics configuration settings for transcribing audio in a media insights pipeline configuration
         * element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder} avoiding the need to create one manually
         * via {@link AmazonTranscribeCallAnalyticsProcessorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #amazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration)}.
         * 
         * @param amazonTranscribeCallAnalyticsProcessorConfiguration
         *        a consumer that will call methods on
         *        {@link AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration)
         */
        default Builder amazonTranscribeCallAnalyticsProcessorConfiguration(
                Consumer<AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder> amazonTranscribeCallAnalyticsProcessorConfiguration) {
            return amazonTranscribeCallAnalyticsProcessorConfiguration(AmazonTranscribeCallAnalyticsProcessorConfiguration
                    .builder().applyMutation(amazonTranscribeCallAnalyticsProcessorConfiguration).build());
        }

        /**
         * <p>
         * The transcription processor configuration settings in a media insights pipeline configuration element.
         * </p>
         * 
         * @param amazonTranscribeProcessorConfiguration
         *        The transcription processor configuration settings in a media insights pipeline configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonTranscribeProcessorConfiguration(
                AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration);

        /**
         * <p>
         * The transcription processor configuration settings in a media insights pipeline configuration element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AmazonTranscribeProcessorConfiguration.Builder} avoiding the need to create one manually via
         * {@link AmazonTranscribeProcessorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonTranscribeProcessorConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #amazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration)}.
         * 
         * @param amazonTranscribeProcessorConfiguration
         *        a consumer that will call methods on {@link AmazonTranscribeProcessorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration)
         */
        default Builder amazonTranscribeProcessorConfiguration(
                Consumer<AmazonTranscribeProcessorConfiguration.Builder> amazonTranscribeProcessorConfiguration) {
            return amazonTranscribeProcessorConfiguration(AmazonTranscribeProcessorConfiguration.builder()
                    .applyMutation(amazonTranscribeProcessorConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration
         * element.
         * </p>
         * 
         * @param kinesisDataStreamSinkConfiguration
         *        The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration);

        /**
         * <p>
         * The configuration settings for the Kinesis Data Stream Sink in a media insights pipeline configuration
         * element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisDataStreamSinkConfiguration.Builder} avoiding the need to create one manually via
         * {@link KinesisDataStreamSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisDataStreamSinkConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration)}.
         * 
         * @param kinesisDataStreamSinkConfiguration
         *        a consumer that will call methods on {@link KinesisDataStreamSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration)
         */
        default Builder kinesisDataStreamSinkConfiguration(
                Consumer<KinesisDataStreamSinkConfiguration.Builder> kinesisDataStreamSinkConfiguration) {
            return kinesisDataStreamSinkConfiguration(KinesisDataStreamSinkConfiguration.builder()
                    .applyMutation(kinesisDataStreamSinkConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for the Amazon S3 recording bucket in a media insights pipeline configuration
         * element.
         * </p>
         * 
         * @param s3RecordingSinkConfiguration
         *        The configuration settings for the Amazon S3 recording bucket in a media insights pipeline
         *        configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3RecordingSinkConfiguration(S3RecordingSinkConfiguration s3RecordingSinkConfiguration);

        /**
         * <p>
         * The configuration settings for the Amazon S3 recording bucket in a media insights pipeline configuration
         * element.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3RecordingSinkConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3RecordingSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3RecordingSinkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3RecordingSinkConfiguration(S3RecordingSinkConfiguration)}.
         * 
         * @param s3RecordingSinkConfiguration
         *        a consumer that will call methods on {@link S3RecordingSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3RecordingSinkConfiguration(S3RecordingSinkConfiguration)
         */
        default Builder s3RecordingSinkConfiguration(Consumer<S3RecordingSinkConfiguration.Builder> s3RecordingSinkConfiguration) {
            return s3RecordingSinkConfiguration(S3RecordingSinkConfiguration.builder()
                    .applyMutation(s3RecordingSinkConfiguration).build());
        }

        /**
         * <p>
         * The voice analytics configuration settings in a media insights pipeline configuration element.
         * </p>
         * 
         * @param voiceAnalyticsProcessorConfiguration
         *        The voice analytics configuration settings in a media insights pipeline configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration);

        /**
         * <p>
         * The voice analytics configuration settings in a media insights pipeline configuration element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VoiceAnalyticsProcessorConfiguration.Builder} avoiding the need to create one manually via
         * {@link VoiceAnalyticsProcessorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceAnalyticsProcessorConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration)}.
         * 
         * @param voiceAnalyticsProcessorConfiguration
         *        a consumer that will call methods on {@link VoiceAnalyticsProcessorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration)
         */
        default Builder voiceAnalyticsProcessorConfiguration(
                Consumer<VoiceAnalyticsProcessorConfiguration.Builder> voiceAnalyticsProcessorConfiguration) {
            return voiceAnalyticsProcessorConfiguration(VoiceAnalyticsProcessorConfiguration.builder()
                    .applyMutation(voiceAnalyticsProcessorConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline configuration
         * element.
         * </p>
         * 
         * @param lambdaFunctionSinkConfiguration
         *        The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline
         *        configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration);

        /**
         * <p>
         * The configuration settings for the Amazon Web Services Lambda sink in a media insights pipeline configuration
         * element.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaFunctionSinkConfiguration.Builder}
         * avoiding the need to create one manually via {@link LambdaFunctionSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionSinkConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration)}.
         * 
         * @param lambdaFunctionSinkConfiguration
         *        a consumer that will call methods on {@link LambdaFunctionSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration)
         */
        default Builder lambdaFunctionSinkConfiguration(
                Consumer<LambdaFunctionSinkConfiguration.Builder> lambdaFunctionSinkConfiguration) {
            return lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration.builder()
                    .applyMutation(lambdaFunctionSinkConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for an SQS queue sink in a media insights pipeline configuration element.
         * </p>
         * 
         * @param sqsQueueSinkConfiguration
         *        The configuration settings for an SQS queue sink in a media insights pipeline configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueSinkConfiguration(SqsQueueSinkConfiguration sqsQueueSinkConfiguration);

        /**
         * <p>
         * The configuration settings for an SQS queue sink in a media insights pipeline configuration element.
         * </p>
         * This is a convenience method that creates an instance of the {@link SqsQueueSinkConfiguration.Builder}
         * avoiding the need to create one manually via {@link SqsQueueSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqsQueueSinkConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sqsQueueSinkConfiguration(SqsQueueSinkConfiguration)}.
         * 
         * @param sqsQueueSinkConfiguration
         *        a consumer that will call methods on {@link SqsQueueSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqsQueueSinkConfiguration(SqsQueueSinkConfiguration)
         */
        default Builder sqsQueueSinkConfiguration(Consumer<SqsQueueSinkConfiguration.Builder> sqsQueueSinkConfiguration) {
            return sqsQueueSinkConfiguration(SqsQueueSinkConfiguration.builder().applyMutation(sqsQueueSinkConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for an SNS topic sink in a media insights pipeline configuration element.
         * </p>
         * 
         * @param snsTopicSinkConfiguration
         *        The configuration settings for an SNS topic sink in a media insights pipeline configuration element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicSinkConfiguration(SnsTopicSinkConfiguration snsTopicSinkConfiguration);

        /**
         * <p>
         * The configuration settings for an SNS topic sink in a media insights pipeline configuration element.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnsTopicSinkConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnsTopicSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnsTopicSinkConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #snsTopicSinkConfiguration(SnsTopicSinkConfiguration)}.
         * 
         * @param snsTopicSinkConfiguration
         *        a consumer that will call methods on {@link SnsTopicSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsTopicSinkConfiguration(SnsTopicSinkConfiguration)
         */
        default Builder snsTopicSinkConfiguration(Consumer<SnsTopicSinkConfiguration.Builder> snsTopicSinkConfiguration) {
            return snsTopicSinkConfiguration(SnsTopicSinkConfiguration.builder().applyMutation(snsTopicSinkConfiguration).build());
        }

        /**
         * <p>
         * The configuration settings for voice enhancement sink in a media insights pipeline configuration element.
         * </p>
         * 
         * @param voiceEnhancementSinkConfiguration
         *        The configuration settings for voice enhancement sink in a media insights pipeline configuration
         *        element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration);

        /**
         * <p>
         * The configuration settings for voice enhancement sink in a media insights pipeline configuration element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VoiceEnhancementSinkConfiguration.Builder} avoiding the need to create one manually via
         * {@link VoiceEnhancementSinkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceEnhancementSinkConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration)}.
         * 
         * @param voiceEnhancementSinkConfiguration
         *        a consumer that will call methods on {@link VoiceEnhancementSinkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration)
         */
        default Builder voiceEnhancementSinkConfiguration(
                Consumer<VoiceEnhancementSinkConfiguration.Builder> voiceEnhancementSinkConfiguration) {
            return voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration.builder()
                    .applyMutation(voiceEnhancementSinkConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration;

        private AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration;

        private KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration;

        private S3RecordingSinkConfiguration s3RecordingSinkConfiguration;

        private VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration;

        private LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration;

        private SqsQueueSinkConfiguration sqsQueueSinkConfiguration;

        private SnsTopicSinkConfiguration snsTopicSinkConfiguration;

        private VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineConfigurationElement model) {
            type(model.type);
            amazonTranscribeCallAnalyticsProcessorConfiguration(model.amazonTranscribeCallAnalyticsProcessorConfiguration);
            amazonTranscribeProcessorConfiguration(model.amazonTranscribeProcessorConfiguration);
            kinesisDataStreamSinkConfiguration(model.kinesisDataStreamSinkConfiguration);
            s3RecordingSinkConfiguration(model.s3RecordingSinkConfiguration);
            voiceAnalyticsProcessorConfiguration(model.voiceAnalyticsProcessorConfiguration);
            lambdaFunctionSinkConfiguration(model.lambdaFunctionSinkConfiguration);
            sqsQueueSinkConfiguration(model.sqsQueueSinkConfiguration);
            snsTopicSinkConfiguration(model.snsTopicSinkConfiguration);
            voiceEnhancementSinkConfiguration(model.voiceEnhancementSinkConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MediaInsightsPipelineConfigurationElementType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AmazonTranscribeCallAnalyticsProcessorConfiguration.Builder getAmazonTranscribeCallAnalyticsProcessorConfiguration() {
            return amazonTranscribeCallAnalyticsProcessorConfiguration != null ? amazonTranscribeCallAnalyticsProcessorConfiguration
                    .toBuilder() : null;
        }

        public final void setAmazonTranscribeCallAnalyticsProcessorConfiguration(
                AmazonTranscribeCallAnalyticsProcessorConfiguration.BuilderImpl amazonTranscribeCallAnalyticsProcessorConfiguration) {
            this.amazonTranscribeCallAnalyticsProcessorConfiguration = amazonTranscribeCallAnalyticsProcessorConfiguration != null ? amazonTranscribeCallAnalyticsProcessorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder amazonTranscribeCallAnalyticsProcessorConfiguration(
                AmazonTranscribeCallAnalyticsProcessorConfiguration amazonTranscribeCallAnalyticsProcessorConfiguration) {
            this.amazonTranscribeCallAnalyticsProcessorConfiguration = amazonTranscribeCallAnalyticsProcessorConfiguration;
            return this;
        }

        public final AmazonTranscribeProcessorConfiguration.Builder getAmazonTranscribeProcessorConfiguration() {
            return amazonTranscribeProcessorConfiguration != null ? amazonTranscribeProcessorConfiguration.toBuilder() : null;
        }

        public final void setAmazonTranscribeProcessorConfiguration(
                AmazonTranscribeProcessorConfiguration.BuilderImpl amazonTranscribeProcessorConfiguration) {
            this.amazonTranscribeProcessorConfiguration = amazonTranscribeProcessorConfiguration != null ? amazonTranscribeProcessorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder amazonTranscribeProcessorConfiguration(
                AmazonTranscribeProcessorConfiguration amazonTranscribeProcessorConfiguration) {
            this.amazonTranscribeProcessorConfiguration = amazonTranscribeProcessorConfiguration;
            return this;
        }

        public final KinesisDataStreamSinkConfiguration.Builder getKinesisDataStreamSinkConfiguration() {
            return kinesisDataStreamSinkConfiguration != null ? kinesisDataStreamSinkConfiguration.toBuilder() : null;
        }

        public final void setKinesisDataStreamSinkConfiguration(
                KinesisDataStreamSinkConfiguration.BuilderImpl kinesisDataStreamSinkConfiguration) {
            this.kinesisDataStreamSinkConfiguration = kinesisDataStreamSinkConfiguration != null ? kinesisDataStreamSinkConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisDataStreamSinkConfiguration(
                KinesisDataStreamSinkConfiguration kinesisDataStreamSinkConfiguration) {
            this.kinesisDataStreamSinkConfiguration = kinesisDataStreamSinkConfiguration;
            return this;
        }

        public final S3RecordingSinkConfiguration.Builder getS3RecordingSinkConfiguration() {
            return s3RecordingSinkConfiguration != null ? s3RecordingSinkConfiguration.toBuilder() : null;
        }

        public final void setS3RecordingSinkConfiguration(S3RecordingSinkConfiguration.BuilderImpl s3RecordingSinkConfiguration) {
            this.s3RecordingSinkConfiguration = s3RecordingSinkConfiguration != null ? s3RecordingSinkConfiguration.build()
                    : null;
        }

        @Override
        public final Builder s3RecordingSinkConfiguration(S3RecordingSinkConfiguration s3RecordingSinkConfiguration) {
            this.s3RecordingSinkConfiguration = s3RecordingSinkConfiguration;
            return this;
        }

        public final VoiceAnalyticsProcessorConfiguration.Builder getVoiceAnalyticsProcessorConfiguration() {
            return voiceAnalyticsProcessorConfiguration != null ? voiceAnalyticsProcessorConfiguration.toBuilder() : null;
        }

        public final void setVoiceAnalyticsProcessorConfiguration(
                VoiceAnalyticsProcessorConfiguration.BuilderImpl voiceAnalyticsProcessorConfiguration) {
            this.voiceAnalyticsProcessorConfiguration = voiceAnalyticsProcessorConfiguration != null ? voiceAnalyticsProcessorConfiguration
                    .build() : null;
        }

        @Override
        public final Builder voiceAnalyticsProcessorConfiguration(
                VoiceAnalyticsProcessorConfiguration voiceAnalyticsProcessorConfiguration) {
            this.voiceAnalyticsProcessorConfiguration = voiceAnalyticsProcessorConfiguration;
            return this;
        }

        public final LambdaFunctionSinkConfiguration.Builder getLambdaFunctionSinkConfiguration() {
            return lambdaFunctionSinkConfiguration != null ? lambdaFunctionSinkConfiguration.toBuilder() : null;
        }

        public final void setLambdaFunctionSinkConfiguration(
                LambdaFunctionSinkConfiguration.BuilderImpl lambdaFunctionSinkConfiguration) {
            this.lambdaFunctionSinkConfiguration = lambdaFunctionSinkConfiguration != null ? lambdaFunctionSinkConfiguration
                    .build() : null;
        }

        @Override
        public final Builder lambdaFunctionSinkConfiguration(LambdaFunctionSinkConfiguration lambdaFunctionSinkConfiguration) {
            this.lambdaFunctionSinkConfiguration = lambdaFunctionSinkConfiguration;
            return this;
        }

        public final SqsQueueSinkConfiguration.Builder getSqsQueueSinkConfiguration() {
            return sqsQueueSinkConfiguration != null ? sqsQueueSinkConfiguration.toBuilder() : null;
        }

        public final void setSqsQueueSinkConfiguration(SqsQueueSinkConfiguration.BuilderImpl sqsQueueSinkConfiguration) {
            this.sqsQueueSinkConfiguration = sqsQueueSinkConfiguration != null ? sqsQueueSinkConfiguration.build() : null;
        }

        @Override
        public final Builder sqsQueueSinkConfiguration(SqsQueueSinkConfiguration sqsQueueSinkConfiguration) {
            this.sqsQueueSinkConfiguration = sqsQueueSinkConfiguration;
            return this;
        }

        public final SnsTopicSinkConfiguration.Builder getSnsTopicSinkConfiguration() {
            return snsTopicSinkConfiguration != null ? snsTopicSinkConfiguration.toBuilder() : null;
        }

        public final void setSnsTopicSinkConfiguration(SnsTopicSinkConfiguration.BuilderImpl snsTopicSinkConfiguration) {
            this.snsTopicSinkConfiguration = snsTopicSinkConfiguration != null ? snsTopicSinkConfiguration.build() : null;
        }

        @Override
        public final Builder snsTopicSinkConfiguration(SnsTopicSinkConfiguration snsTopicSinkConfiguration) {
            this.snsTopicSinkConfiguration = snsTopicSinkConfiguration;
            return this;
        }

        public final VoiceEnhancementSinkConfiguration.Builder getVoiceEnhancementSinkConfiguration() {
            return voiceEnhancementSinkConfiguration != null ? voiceEnhancementSinkConfiguration.toBuilder() : null;
        }

        public final void setVoiceEnhancementSinkConfiguration(
                VoiceEnhancementSinkConfiguration.BuilderImpl voiceEnhancementSinkConfiguration) {
            this.voiceEnhancementSinkConfiguration = voiceEnhancementSinkConfiguration != null ? voiceEnhancementSinkConfiguration
                    .build() : null;
        }

        @Override
        public final Builder voiceEnhancementSinkConfiguration(VoiceEnhancementSinkConfiguration voiceEnhancementSinkConfiguration) {
            this.voiceEnhancementSinkConfiguration = voiceEnhancementSinkConfiguration;
            return this;
        }

        @Override
        public MediaInsightsPipelineConfigurationElement build() {
            return new MediaInsightsPipelineConfigurationElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
