/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of an asynchronous request to perform voice tone analysis on a media insights pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceToneAnalysisTask implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceToneAnalysisTask.Builder, VoiceToneAnalysisTask> {
    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskId").getter(getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskId))
            .setter(setter(Builder::voiceToneAnalysisTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskId").build())
            .build();

    private static final SdkField<String> VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VoiceToneAnalysisTaskStatus")
            .getter(getter(VoiceToneAnalysisTask::voiceToneAnalysisTaskStatusAsString))
            .setter(setter(Builder::voiceToneAnalysisTaskStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceToneAnalysisTaskStatus")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp")
            .getter(getter(VoiceToneAnalysisTask::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(VoiceToneAnalysisTask::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VOICE_TONE_ANALYSIS_TASK_ID_FIELD, VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String voiceToneAnalysisTaskId;

    private final String voiceToneAnalysisTaskStatus;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private VoiceToneAnalysisTask(BuilderImpl builder) {
        this.voiceToneAnalysisTaskId = builder.voiceToneAnalysisTaskId;
        this.voiceToneAnalysisTaskStatus = builder.voiceToneAnalysisTaskStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ID of the voice tone analysis task.
     * </p>
     * 
     * @return The ID of the voice tone analysis task.
     */
    public final String voiceToneAnalysisTaskId() {
        return voiceToneAnalysisTaskId;
    }

    /**
     * <p>
     * The status of a voice tone analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceToneAnalysisTaskStatus} will return {@link MediaPipelineTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #voiceToneAnalysisTaskStatusAsString}.
     * </p>
     * 
     * @return The status of a voice tone analysis task.
     * @see MediaPipelineTaskStatus
     */
    public final MediaPipelineTaskStatus voiceToneAnalysisTaskStatus() {
        return MediaPipelineTaskStatus.fromValue(voiceToneAnalysisTaskStatus);
    }

    /**
     * <p>
     * The status of a voice tone analysis task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceToneAnalysisTaskStatus} will return {@link MediaPipelineTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #voiceToneAnalysisTaskStatusAsString}.
     * </p>
     * 
     * @return The status of a voice tone analysis task.
     * @see MediaPipelineTaskStatus
     */
    public final String voiceToneAnalysisTaskStatusAsString() {
        return voiceToneAnalysisTaskStatus;
    }

    /**
     * <p>
     * The time at which a voice tone analysis task was created.
     * </p>
     * 
     * @return The time at which a voice tone analysis task was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time at which a voice tone analysis task was updated.
     * </p>
     * 
     * @return The time at which a voice tone analysis task was updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(voiceToneAnalysisTaskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceToneAnalysisTask)) {
            return false;
        }
        VoiceToneAnalysisTask other = (VoiceToneAnalysisTask) obj;
        return Objects.equals(voiceToneAnalysisTaskId(), other.voiceToneAnalysisTaskId())
                && Objects.equals(voiceToneAnalysisTaskStatusAsString(), other.voiceToneAnalysisTaskStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceToneAnalysisTask").add("VoiceToneAnalysisTaskId", voiceToneAnalysisTaskId())
                .add("VoiceToneAnalysisTaskStatus", voiceToneAnalysisTaskStatusAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceToneAnalysisTaskId":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskId()));
        case "VoiceToneAnalysisTaskStatus":
            return Optional.ofNullable(clazz.cast(voiceToneAnalysisTaskStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceToneAnalysisTaskId", VOICE_TONE_ANALYSIS_TASK_ID_FIELD);
        map.put("VoiceToneAnalysisTaskStatus", VOICE_TONE_ANALYSIS_TASK_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceToneAnalysisTask, T> g) {
        return obj -> g.apply((VoiceToneAnalysisTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceToneAnalysisTask> {
        /**
         * <p>
         * The ID of the voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTaskId
         *        The ID of the voice tone analysis task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId);

        /**
         * <p>
         * The status of a voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTaskStatus
         *        The status of a voice tone analysis task.
         * @see MediaPipelineTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineTaskStatus
         */
        Builder voiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus);

        /**
         * <p>
         * The status of a voice tone analysis task.
         * </p>
         * 
         * @param voiceToneAnalysisTaskStatus
         *        The status of a voice tone analysis task.
         * @see MediaPipelineTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaPipelineTaskStatus
         */
        Builder voiceToneAnalysisTaskStatus(MediaPipelineTaskStatus voiceToneAnalysisTaskStatus);

        /**
         * <p>
         * The time at which a voice tone analysis task was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time at which a voice tone analysis task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time at which a voice tone analysis task was updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The time at which a voice tone analysis task was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceToneAnalysisTaskId;

        private String voiceToneAnalysisTaskStatus;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceToneAnalysisTask model) {
            voiceToneAnalysisTaskId(model.voiceToneAnalysisTaskId);
            voiceToneAnalysisTaskStatus(model.voiceToneAnalysisTaskStatus);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceToneAnalysisTaskId() {
            return voiceToneAnalysisTaskId;
        }

        public final void setVoiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
        }

        @Override
        public final Builder voiceToneAnalysisTaskId(String voiceToneAnalysisTaskId) {
            this.voiceToneAnalysisTaskId = voiceToneAnalysisTaskId;
            return this;
        }

        public final String getVoiceToneAnalysisTaskStatus() {
            return voiceToneAnalysisTaskStatus;
        }

        public final void setVoiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
        }

        @Override
        public final Builder voiceToneAnalysisTaskStatus(String voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus = voiceToneAnalysisTaskStatus;
            return this;
        }

        @Override
        public final Builder voiceToneAnalysisTaskStatus(MediaPipelineTaskStatus voiceToneAnalysisTaskStatus) {
            this.voiceToneAnalysisTaskStatus(voiceToneAnalysisTaskStatus == null ? null : voiceToneAnalysisTaskStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public VoiceToneAnalysisTask build() {
            return new VoiceToneAnalysisTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
