/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the settings for a keyword match task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeywordMatchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KeywordMatchConfiguration.Builder, KeywordMatchConfiguration> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(KeywordMatchConfiguration::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<List<String>> KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keywords")
            .getter(getter(KeywordMatchConfiguration::keywords))
            .setter(setter(Builder::keywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> NEGATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negate").getter(getter(KeywordMatchConfiguration::negate)).setter(setter(Builder::negate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            KEYWORDS_FIELD, NEGATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final List<String> keywords;

    private final Boolean negate;

    private KeywordMatchConfiguration(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.keywords = builder.keywords;
        this.negate = builder.negate;
    }

    /**
     * <p>
     * The name of the keyword match rule.
     * </p>
     * 
     * @return The name of the keyword match rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keywords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeywords() {
        return keywords != null && !(keywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The keywords or phrases that you want to match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeywords} method.
     * </p>
     * 
     * @return The keywords or phrases that you want to match.
     */
    public final List<String> keywords() {
        return keywords;
    }

    /**
     * <p>
     * Matches keywords or phrases on their presence or absence. If set to <code>TRUE</code>, the rule matches when all
     * the specified keywords or phrases are absent. Default: <code>FALSE</code>.
     * </p>
     * 
     * @return Matches keywords or phrases on their presence or absence. If set to <code>TRUE</code>, the rule matches
     *         when all the specified keywords or phrases are absent. Default: <code>FALSE</code>.
     */
    public final Boolean negate() {
        return negate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeywords() ? keywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(negate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeywordMatchConfiguration)) {
            return false;
        }
        KeywordMatchConfiguration other = (KeywordMatchConfiguration) obj;
        return Objects.equals(ruleName(), other.ruleName()) && hasKeywords() == other.hasKeywords()
                && Objects.equals(keywords(), other.keywords()) && Objects.equals(negate(), other.negate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeywordMatchConfiguration").add("RuleName", ruleName())
                .add("Keywords", hasKeywords() ? keywords() : null).add("Negate", negate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "Keywords":
            return Optional.ofNullable(clazz.cast(keywords()));
        case "Negate":
            return Optional.ofNullable(clazz.cast(negate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Keywords", KEYWORDS_FIELD);
        map.put("Negate", NEGATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeywordMatchConfiguration, T> g) {
        return obj -> g.apply((KeywordMatchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeywordMatchConfiguration> {
        /**
         * <p>
         * The name of the keyword match rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the keyword match rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The keywords or phrases that you want to match.
         * </p>
         * 
         * @param keywords
         *        The keywords or phrases that you want to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(Collection<String> keywords);

        /**
         * <p>
         * The keywords or phrases that you want to match.
         * </p>
         * 
         * @param keywords
         *        The keywords or phrases that you want to match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywords(String... keywords);

        /**
         * <p>
         * Matches keywords or phrases on their presence or absence. If set to <code>TRUE</code>, the rule matches when
         * all the specified keywords or phrases are absent. Default: <code>FALSE</code>.
         * </p>
         * 
         * @param negate
         *        Matches keywords or phrases on their presence or absence. If set to <code>TRUE</code>, the rule
         *        matches when all the specified keywords or phrases are absent. Default: <code>FALSE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negate(Boolean negate);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private List<String> keywords = DefaultSdkAutoConstructList.getInstance();

        private Boolean negate;

        private BuilderImpl() {
        }

        private BuilderImpl(KeywordMatchConfiguration model) {
            ruleName(model.ruleName);
            keywords(model.keywords);
            negate(model.negate);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final Collection<String> getKeywords() {
            if (keywords instanceof SdkAutoConstructList) {
                return null;
            }
            return keywords;
        }

        public final void setKeywords(Collection<String> keywords) {
            this.keywords = KeywordMatchWordListCopier.copy(keywords);
        }

        @Override
        public final Builder keywords(Collection<String> keywords) {
            this.keywords = KeywordMatchWordListCopier.copy(keywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keywords(String... keywords) {
            keywords(Arrays.asList(keywords));
            return this;
        }

        public final Boolean getNegate() {
            return negate;
        }

        public final void setNegate(Boolean negate) {
            this.negate = negate;
        }

        @Override
        public final Builder negate(Boolean negate) {
            this.negate = negate;
            return this;
        }

        @Override
        public KeywordMatchConfiguration build() {
            return new KeywordMatchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
