/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media pipeline's sink configuration settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LiveConnectorSinkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LiveConnectorSinkConfiguration.Builder, LiveConnectorSinkConfiguration> {
    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkType").getter(getter(LiveConnectorSinkConfiguration::sinkTypeAsString))
            .setter(setter(Builder::sinkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()).build();

    private static final SdkField<LiveConnectorRTMPConfiguration> RTMP_CONFIGURATION_FIELD = SdkField
            .<LiveConnectorRTMPConfiguration> builder(MarshallingType.SDK_POJO).memberName("RTMPConfiguration")
            .getter(getter(LiveConnectorSinkConfiguration::rtmpConfiguration)).setter(setter(Builder::rtmpConfiguration))
            .constructor(LiveConnectorRTMPConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RTMPConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINK_TYPE_FIELD,
            RTMP_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sinkType;

    private final LiveConnectorRTMPConfiguration rtmpConfiguration;

    private LiveConnectorSinkConfiguration(BuilderImpl builder) {
        this.sinkType = builder.sinkType;
        this.rtmpConfiguration = builder.rtmpConfiguration;
    }

    /**
     * <p>
     * The sink configuration's sink type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link LiveConnectorSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return The sink configuration's sink type.
     * @see LiveConnectorSinkType
     */
    public final LiveConnectorSinkType sinkType() {
        return LiveConnectorSinkType.fromValue(sinkType);
    }

    /**
     * <p>
     * The sink configuration's sink type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link LiveConnectorSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return The sink configuration's sink type.
     * @see LiveConnectorSinkType
     */
    public final String sinkTypeAsString() {
        return sinkType;
    }

    /**
     * <p>
     * The sink configuration's RTMP configuration settings.
     * </p>
     * 
     * @return The sink configuration's RTMP configuration settings.
     */
    public final LiveConnectorRTMPConfiguration rtmpConfiguration() {
        return rtmpConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rtmpConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveConnectorSinkConfiguration)) {
            return false;
        }
        LiveConnectorSinkConfiguration other = (LiveConnectorSinkConfiguration) obj;
        return Objects.equals(sinkTypeAsString(), other.sinkTypeAsString())
                && Objects.equals(rtmpConfiguration(), other.rtmpConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LiveConnectorSinkConfiguration").add("SinkType", sinkTypeAsString())
                .add("RTMPConfiguration", rtmpConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SinkType":
            return Optional.ofNullable(clazz.cast(sinkTypeAsString()));
        case "RTMPConfiguration":
            return Optional.ofNullable(clazz.cast(rtmpConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SinkType", SINK_TYPE_FIELD);
        map.put("RTMPConfiguration", RTMP_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveConnectorSinkConfiguration, T> g) {
        return obj -> g.apply((LiveConnectorSinkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LiveConnectorSinkConfiguration> {
        /**
         * <p>
         * The sink configuration's sink type.
         * </p>
         * 
         * @param sinkType
         *        The sink configuration's sink type.
         * @see LiveConnectorSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorSinkType
         */
        Builder sinkType(String sinkType);

        /**
         * <p>
         * The sink configuration's sink type.
         * </p>
         * 
         * @param sinkType
         *        The sink configuration's sink type.
         * @see LiveConnectorSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LiveConnectorSinkType
         */
        Builder sinkType(LiveConnectorSinkType sinkType);

        /**
         * <p>
         * The sink configuration's RTMP configuration settings.
         * </p>
         * 
         * @param rtmpConfiguration
         *        The sink configuration's RTMP configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtmpConfiguration(LiveConnectorRTMPConfiguration rtmpConfiguration);

        /**
         * <p>
         * The sink configuration's RTMP configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link LiveConnectorRTMPConfiguration.Builder}
         * avoiding the need to create one manually via {@link LiveConnectorRTMPConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LiveConnectorRTMPConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #rtmpConfiguration(LiveConnectorRTMPConfiguration)}.
         * 
         * @param rtmpConfiguration
         *        a consumer that will call methods on {@link LiveConnectorRTMPConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtmpConfiguration(LiveConnectorRTMPConfiguration)
         */
        default Builder rtmpConfiguration(Consumer<LiveConnectorRTMPConfiguration.Builder> rtmpConfiguration) {
            return rtmpConfiguration(LiveConnectorRTMPConfiguration.builder().applyMutation(rtmpConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sinkType;

        private LiveConnectorRTMPConfiguration rtmpConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveConnectorSinkConfiguration model) {
            sinkType(model.sinkType);
            rtmpConfiguration(model.rtmpConfiguration);
        }

        public final String getSinkType() {
            return sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(LiveConnectorSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final LiveConnectorRTMPConfiguration.Builder getRtmpConfiguration() {
            return rtmpConfiguration != null ? rtmpConfiguration.toBuilder() : null;
        }

        public final void setRtmpConfiguration(LiveConnectorRTMPConfiguration.BuilderImpl rtmpConfiguration) {
            this.rtmpConfiguration = rtmpConfiguration != null ? rtmpConfiguration.build() : null;
        }

        @Override
        public final Builder rtmpConfiguration(LiveConnectorRTMPConfiguration rtmpConfiguration) {
            this.rtmpConfiguration = rtmpConfiguration;
            return this;
        }

        @Override
        public LiveConnectorSinkConfiguration build() {
            return new LiveConnectorSinkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
