/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pipeline consisting of a media capture, media concatenation, or live-streaming pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaPipeline implements SdkPojo, Serializable, ToCopyableBuilder<MediaPipeline.Builder, MediaPipeline> {
    private static final SdkField<MediaCapturePipeline> MEDIA_CAPTURE_PIPELINE_FIELD = SdkField
            .<MediaCapturePipeline> builder(MarshallingType.SDK_POJO).memberName("MediaCapturePipeline")
            .getter(getter(MediaPipeline::mediaCapturePipeline)).setter(setter(Builder::mediaCapturePipeline))
            .constructor(MediaCapturePipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaCapturePipeline").build())
            .build();

    private static final SdkField<MediaLiveConnectorPipeline> MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD = SdkField
            .<MediaLiveConnectorPipeline> builder(MarshallingType.SDK_POJO)
            .memberName("MediaLiveConnectorPipeline")
            .getter(getter(MediaPipeline::mediaLiveConnectorPipeline))
            .setter(setter(Builder::mediaLiveConnectorPipeline))
            .constructor(MediaLiveConnectorPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaLiveConnectorPipeline").build())
            .build();

    private static final SdkField<MediaConcatenationPipeline> MEDIA_CONCATENATION_PIPELINE_FIELD = SdkField
            .<MediaConcatenationPipeline> builder(MarshallingType.SDK_POJO)
            .memberName("MediaConcatenationPipeline")
            .getter(getter(MediaPipeline::mediaConcatenationPipeline))
            .setter(setter(Builder::mediaConcatenationPipeline))
            .constructor(MediaConcatenationPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcatenationPipeline").build())
            .build();

    private static final SdkField<MediaInsightsPipeline> MEDIA_INSIGHTS_PIPELINE_FIELD = SdkField
            .<MediaInsightsPipeline> builder(MarshallingType.SDK_POJO).memberName("MediaInsightsPipeline")
            .getter(getter(MediaPipeline::mediaInsightsPipeline)).setter(setter(Builder::mediaInsightsPipeline))
            .constructor(MediaInsightsPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipeline").build())
            .build();

    private static final SdkField<MediaStreamPipeline> MEDIA_STREAM_PIPELINE_FIELD = SdkField
            .<MediaStreamPipeline> builder(MarshallingType.SDK_POJO).memberName("MediaStreamPipeline")
            .getter(getter(MediaPipeline::mediaStreamPipeline)).setter(setter(Builder::mediaStreamPipeline))
            .constructor(MediaStreamPipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamPipeline").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_CAPTURE_PIPELINE_FIELD,
            MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD, MEDIA_CONCATENATION_PIPELINE_FIELD, MEDIA_INSIGHTS_PIPELINE_FIELD,
            MEDIA_STREAM_PIPELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MediaCapturePipeline mediaCapturePipeline;

    private final MediaLiveConnectorPipeline mediaLiveConnectorPipeline;

    private final MediaConcatenationPipeline mediaConcatenationPipeline;

    private final MediaInsightsPipeline mediaInsightsPipeline;

    private final MediaStreamPipeline mediaStreamPipeline;

    private MediaPipeline(BuilderImpl builder) {
        this.mediaCapturePipeline = builder.mediaCapturePipeline;
        this.mediaLiveConnectorPipeline = builder.mediaLiveConnectorPipeline;
        this.mediaConcatenationPipeline = builder.mediaConcatenationPipeline;
        this.mediaInsightsPipeline = builder.mediaInsightsPipeline;
        this.mediaStreamPipeline = builder.mediaStreamPipeline;
    }

    /**
     * <p>
     * A pipeline that enables users to capture audio and video.
     * </p>
     * 
     * @return A pipeline that enables users to capture audio and video.
     */
    public final MediaCapturePipeline mediaCapturePipeline() {
        return mediaCapturePipeline;
    }

    /**
     * <p>
     * The connector pipeline of the media pipeline.
     * </p>
     * 
     * @return The connector pipeline of the media pipeline.
     */
    public final MediaLiveConnectorPipeline mediaLiveConnectorPipeline() {
        return mediaLiveConnectorPipeline;
    }

    /**
     * <p>
     * The media concatenation pipeline in a media pipeline.
     * </p>
     * 
     * @return The media concatenation pipeline in a media pipeline.
     */
    public final MediaConcatenationPipeline mediaConcatenationPipeline() {
        return mediaConcatenationPipeline;
    }

    /**
     * <p>
     * The media insights pipeline of a media pipeline.
     * </p>
     * 
     * @return The media insights pipeline of a media pipeline.
     */
    public final MediaInsightsPipeline mediaInsightsPipeline() {
        return mediaInsightsPipeline;
    }

    /**
     * <p>
     * Designates a media pipeline as a media stream pipeline.
     * </p>
     * 
     * @return Designates a media pipeline as a media stream pipeline.
     */
    public final MediaStreamPipeline mediaStreamPipeline() {
        return mediaStreamPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaCapturePipeline());
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveConnectorPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(mediaConcatenationPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(mediaInsightsPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamPipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPipeline)) {
            return false;
        }
        MediaPipeline other = (MediaPipeline) obj;
        return Objects.equals(mediaCapturePipeline(), other.mediaCapturePipeline())
                && Objects.equals(mediaLiveConnectorPipeline(), other.mediaLiveConnectorPipeline())
                && Objects.equals(mediaConcatenationPipeline(), other.mediaConcatenationPipeline())
                && Objects.equals(mediaInsightsPipeline(), other.mediaInsightsPipeline())
                && Objects.equals(mediaStreamPipeline(), other.mediaStreamPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaPipeline").add("MediaCapturePipeline", mediaCapturePipeline())
                .add("MediaLiveConnectorPipeline", mediaLiveConnectorPipeline())
                .add("MediaConcatenationPipeline", mediaConcatenationPipeline())
                .add("MediaInsightsPipeline", mediaInsightsPipeline()).add("MediaStreamPipeline", mediaStreamPipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaCapturePipeline":
            return Optional.ofNullable(clazz.cast(mediaCapturePipeline()));
        case "MediaLiveConnectorPipeline":
            return Optional.ofNullable(clazz.cast(mediaLiveConnectorPipeline()));
        case "MediaConcatenationPipeline":
            return Optional.ofNullable(clazz.cast(mediaConcatenationPipeline()));
        case "MediaInsightsPipeline":
            return Optional.ofNullable(clazz.cast(mediaInsightsPipeline()));
        case "MediaStreamPipeline":
            return Optional.ofNullable(clazz.cast(mediaStreamPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaCapturePipeline", MEDIA_CAPTURE_PIPELINE_FIELD);
        map.put("MediaLiveConnectorPipeline", MEDIA_LIVE_CONNECTOR_PIPELINE_FIELD);
        map.put("MediaConcatenationPipeline", MEDIA_CONCATENATION_PIPELINE_FIELD);
        map.put("MediaInsightsPipeline", MEDIA_INSIGHTS_PIPELINE_FIELD);
        map.put("MediaStreamPipeline", MEDIA_STREAM_PIPELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPipeline, T> g) {
        return obj -> g.apply((MediaPipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaPipeline> {
        /**
         * <p>
         * A pipeline that enables users to capture audio and video.
         * </p>
         * 
         * @param mediaCapturePipeline
         *        A pipeline that enables users to capture audio and video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaCapturePipeline(MediaCapturePipeline mediaCapturePipeline);

        /**
         * <p>
         * A pipeline that enables users to capture audio and video.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaCapturePipeline.Builder} avoiding
         * the need to create one manually via {@link MediaCapturePipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaCapturePipeline.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaCapturePipeline(MediaCapturePipeline)}.
         * 
         * @param mediaCapturePipeline
         *        a consumer that will call methods on {@link MediaCapturePipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaCapturePipeline(MediaCapturePipeline)
         */
        default Builder mediaCapturePipeline(Consumer<MediaCapturePipeline.Builder> mediaCapturePipeline) {
            return mediaCapturePipeline(MediaCapturePipeline.builder().applyMutation(mediaCapturePipeline).build());
        }

        /**
         * <p>
         * The connector pipeline of the media pipeline.
         * </p>
         * 
         * @param mediaLiveConnectorPipeline
         *        The connector pipeline of the media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline mediaLiveConnectorPipeline);

        /**
         * <p>
         * The connector pipeline of the media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaLiveConnectorPipeline.Builder}
         * avoiding the need to create one manually via {@link MediaLiveConnectorPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaLiveConnectorPipeline.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaLiveConnectorPipeline(MediaLiveConnectorPipeline)}.
         * 
         * @param mediaLiveConnectorPipeline
         *        a consumer that will call methods on {@link MediaLiveConnectorPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaLiveConnectorPipeline(MediaLiveConnectorPipeline)
         */
        default Builder mediaLiveConnectorPipeline(Consumer<MediaLiveConnectorPipeline.Builder> mediaLiveConnectorPipeline) {
            return mediaLiveConnectorPipeline(MediaLiveConnectorPipeline.builder().applyMutation(mediaLiveConnectorPipeline)
                    .build());
        }

        /**
         * <p>
         * The media concatenation pipeline in a media pipeline.
         * </p>
         * 
         * @param mediaConcatenationPipeline
         *        The media concatenation pipeline in a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcatenationPipeline(MediaConcatenationPipeline mediaConcatenationPipeline);

        /**
         * <p>
         * The media concatenation pipeline in a media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaConcatenationPipeline.Builder}
         * avoiding the need to create one manually via {@link MediaConcatenationPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaConcatenationPipeline.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaConcatenationPipeline(MediaConcatenationPipeline)}.
         * 
         * @param mediaConcatenationPipeline
         *        a consumer that will call methods on {@link MediaConcatenationPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConcatenationPipeline(MediaConcatenationPipeline)
         */
        default Builder mediaConcatenationPipeline(Consumer<MediaConcatenationPipeline.Builder> mediaConcatenationPipeline) {
            return mediaConcatenationPipeline(MediaConcatenationPipeline.builder().applyMutation(mediaConcatenationPipeline)
                    .build());
        }

        /**
         * <p>
         * The media insights pipeline of a media pipeline.
         * </p>
         * 
         * @param mediaInsightsPipeline
         *        The media insights pipeline of a media pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaInsightsPipeline(MediaInsightsPipeline mediaInsightsPipeline);

        /**
         * <p>
         * The media insights pipeline of a media pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaInsightsPipeline.Builder} avoiding
         * the need to create one manually via {@link MediaInsightsPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaInsightsPipeline.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaInsightsPipeline(MediaInsightsPipeline)}.
         * 
         * @param mediaInsightsPipeline
         *        a consumer that will call methods on {@link MediaInsightsPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaInsightsPipeline(MediaInsightsPipeline)
         */
        default Builder mediaInsightsPipeline(Consumer<MediaInsightsPipeline.Builder> mediaInsightsPipeline) {
            return mediaInsightsPipeline(MediaInsightsPipeline.builder().applyMutation(mediaInsightsPipeline).build());
        }

        /**
         * <p>
         * Designates a media pipeline as a media stream pipeline.
         * </p>
         * 
         * @param mediaStreamPipeline
         *        Designates a media pipeline as a media stream pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStreamPipeline(MediaStreamPipeline mediaStreamPipeline);

        /**
         * <p>
         * Designates a media pipeline as a media stream pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaStreamPipeline.Builder} avoiding the
         * need to create one manually via {@link MediaStreamPipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaStreamPipeline.Builder#build()} is called immediately and
         * its result is passed to {@link #mediaStreamPipeline(MediaStreamPipeline)}.
         * 
         * @param mediaStreamPipeline
         *        a consumer that will call methods on {@link MediaStreamPipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStreamPipeline(MediaStreamPipeline)
         */
        default Builder mediaStreamPipeline(Consumer<MediaStreamPipeline.Builder> mediaStreamPipeline) {
            return mediaStreamPipeline(MediaStreamPipeline.builder().applyMutation(mediaStreamPipeline).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MediaCapturePipeline mediaCapturePipeline;

        private MediaLiveConnectorPipeline mediaLiveConnectorPipeline;

        private MediaConcatenationPipeline mediaConcatenationPipeline;

        private MediaInsightsPipeline mediaInsightsPipeline;

        private MediaStreamPipeline mediaStreamPipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPipeline model) {
            mediaCapturePipeline(model.mediaCapturePipeline);
            mediaLiveConnectorPipeline(model.mediaLiveConnectorPipeline);
            mediaConcatenationPipeline(model.mediaConcatenationPipeline);
            mediaInsightsPipeline(model.mediaInsightsPipeline);
            mediaStreamPipeline(model.mediaStreamPipeline);
        }

        public final MediaCapturePipeline.Builder getMediaCapturePipeline() {
            return mediaCapturePipeline != null ? mediaCapturePipeline.toBuilder() : null;
        }

        public final void setMediaCapturePipeline(MediaCapturePipeline.BuilderImpl mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline != null ? mediaCapturePipeline.build() : null;
        }

        @Override
        public final Builder mediaCapturePipeline(MediaCapturePipeline mediaCapturePipeline) {
            this.mediaCapturePipeline = mediaCapturePipeline;
            return this;
        }

        public final MediaLiveConnectorPipeline.Builder getMediaLiveConnectorPipeline() {
            return mediaLiveConnectorPipeline != null ? mediaLiveConnectorPipeline.toBuilder() : null;
        }

        public final void setMediaLiveConnectorPipeline(MediaLiveConnectorPipeline.BuilderImpl mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline != null ? mediaLiveConnectorPipeline.build() : null;
        }

        @Override
        public final Builder mediaLiveConnectorPipeline(MediaLiveConnectorPipeline mediaLiveConnectorPipeline) {
            this.mediaLiveConnectorPipeline = mediaLiveConnectorPipeline;
            return this;
        }

        public final MediaConcatenationPipeline.Builder getMediaConcatenationPipeline() {
            return mediaConcatenationPipeline != null ? mediaConcatenationPipeline.toBuilder() : null;
        }

        public final void setMediaConcatenationPipeline(MediaConcatenationPipeline.BuilderImpl mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline != null ? mediaConcatenationPipeline.build() : null;
        }

        @Override
        public final Builder mediaConcatenationPipeline(MediaConcatenationPipeline mediaConcatenationPipeline) {
            this.mediaConcatenationPipeline = mediaConcatenationPipeline;
            return this;
        }

        public final MediaInsightsPipeline.Builder getMediaInsightsPipeline() {
            return mediaInsightsPipeline != null ? mediaInsightsPipeline.toBuilder() : null;
        }

        public final void setMediaInsightsPipeline(MediaInsightsPipeline.BuilderImpl mediaInsightsPipeline) {
            this.mediaInsightsPipeline = mediaInsightsPipeline != null ? mediaInsightsPipeline.build() : null;
        }

        @Override
        public final Builder mediaInsightsPipeline(MediaInsightsPipeline mediaInsightsPipeline) {
            this.mediaInsightsPipeline = mediaInsightsPipeline;
            return this;
        }

        public final MediaStreamPipeline.Builder getMediaStreamPipeline() {
            return mediaStreamPipeline != null ? mediaStreamPipeline.toBuilder() : null;
        }

        public final void setMediaStreamPipeline(MediaStreamPipeline.BuilderImpl mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline != null ? mediaStreamPipeline.build() : null;
        }

        @Override
        public final Builder mediaStreamPipeline(MediaStreamPipeline mediaStreamPipeline) {
            this.mediaStreamPipeline = mediaStreamPipeline;
            return this;
        }

        @Override
        public MediaPipeline build() {
            return new MediaPipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
