/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure that contains the settings for a media stream sink.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaStreamSink implements SdkPojo, Serializable, ToCopyableBuilder<MediaStreamSink.Builder, MediaStreamSink> {
    private static final SdkField<String> SINK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkArn").getter(getter(MediaStreamSink::sinkArn)).setter(setter(Builder::sinkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkArn").build()).build();

    private static final SdkField<String> SINK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SinkType").getter(getter(MediaStreamSink::sinkTypeAsString)).setter(setter(Builder::sinkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SinkType").build()).build();

    private static final SdkField<Integer> RESERVED_STREAM_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReservedStreamCapacity").getter(getter(MediaStreamSink::reservedStreamCapacity))
            .setter(setter(Builder::reservedStreamCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedStreamCapacity").build())
            .build();

    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamType").getter(getter(MediaStreamSink::mediaStreamTypeAsString))
            .setter(setter(Builder::mediaStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINK_ARN_FIELD,
            SINK_TYPE_FIELD, RESERVED_STREAM_CAPACITY_FIELD, MEDIA_STREAM_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sinkArn;

    private final String sinkType;

    private final Integer reservedStreamCapacity;

    private final String mediaStreamType;

    private MediaStreamSink(BuilderImpl builder) {
        this.sinkArn = builder.sinkArn;
        this.sinkType = builder.sinkType;
        this.reservedStreamCapacity = builder.reservedStreamCapacity;
        this.mediaStreamType = builder.mediaStreamType;
    }

    /**
     * <p>
     * The ARN of the Kinesis Video Stream pool returned by the <a>CreateMediaPipelineKinesisVideoStreamPool</a> API.
     * </p>
     * 
     * @return The ARN of the Kinesis Video Stream pool returned by the <a>CreateMediaPipelineKinesisVideoStreamPool</a>
     *         API.
     */
    public final String sinkArn() {
        return sinkArn;
    }

    /**
     * <p>
     * The media stream sink's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaStreamPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return The media stream sink's type.
     * @see MediaStreamPipelineSinkType
     */
    public final MediaStreamPipelineSinkType sinkType() {
        return MediaStreamPipelineSinkType.fromValue(sinkType);
    }

    /**
     * <p>
     * The media stream sink's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sinkType} will
     * return {@link MediaStreamPipelineSinkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sinkTypeAsString}.
     * </p>
     * 
     * @return The media stream sink's type.
     * @see MediaStreamPipelineSinkType
     */
    public final String sinkTypeAsString() {
        return sinkType;
    }

    /**
     * <p>
     * Specifies the number of streams that the sink can accept.
     * </p>
     * 
     * @return Specifies the number of streams that the sink can accept.
     */
    public final Integer reservedStreamCapacity() {
        return reservedStreamCapacity;
    }

    /**
     * <p>
     * The media stream sink's media stream type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The media stream sink's media stream type.
     * @see MediaStreamType
     */
    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(mediaStreamType);
    }

    /**
     * <p>
     * The media stream sink's media stream type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return The media stream sink's media stream type.
     * @see MediaStreamType
     */
    public final String mediaStreamTypeAsString() {
        return mediaStreamType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(sinkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reservedStreamCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaStreamSink)) {
            return false;
        }
        MediaStreamSink other = (MediaStreamSink) obj;
        return Objects.equals(sinkArn(), other.sinkArn()) && Objects.equals(sinkTypeAsString(), other.sinkTypeAsString())
                && Objects.equals(reservedStreamCapacity(), other.reservedStreamCapacity())
                && Objects.equals(mediaStreamTypeAsString(), other.mediaStreamTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaStreamSink").add("SinkArn", sinkArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SinkType", sinkTypeAsString()).add("ReservedStreamCapacity", reservedStreamCapacity())
                .add("MediaStreamType", mediaStreamTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SinkArn":
            return Optional.ofNullable(clazz.cast(sinkArn()));
        case "SinkType":
            return Optional.ofNullable(clazz.cast(sinkTypeAsString()));
        case "ReservedStreamCapacity":
            return Optional.ofNullable(clazz.cast(reservedStreamCapacity()));
        case "MediaStreamType":
            return Optional.ofNullable(clazz.cast(mediaStreamTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SinkArn", SINK_ARN_FIELD);
        map.put("SinkType", SINK_TYPE_FIELD);
        map.put("ReservedStreamCapacity", RESERVED_STREAM_CAPACITY_FIELD);
        map.put("MediaStreamType", MEDIA_STREAM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaStreamSink, T> g) {
        return obj -> g.apply((MediaStreamSink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaStreamSink> {
        /**
         * <p>
         * The ARN of the Kinesis Video Stream pool returned by the <a>CreateMediaPipelineKinesisVideoStreamPool</a>
         * API.
         * </p>
         * 
         * @param sinkArn
         *        The ARN of the Kinesis Video Stream pool returned by the
         *        <a>CreateMediaPipelineKinesisVideoStreamPool</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinkArn(String sinkArn);

        /**
         * <p>
         * The media stream sink's type.
         * </p>
         * 
         * @param sinkType
         *        The media stream sink's type.
         * @see MediaStreamPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamPipelineSinkType
         */
        Builder sinkType(String sinkType);

        /**
         * <p>
         * The media stream sink's type.
         * </p>
         * 
         * @param sinkType
         *        The media stream sink's type.
         * @see MediaStreamPipelineSinkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamPipelineSinkType
         */
        Builder sinkType(MediaStreamPipelineSinkType sinkType);

        /**
         * <p>
         * Specifies the number of streams that the sink can accept.
         * </p>
         * 
         * @param reservedStreamCapacity
         *        Specifies the number of streams that the sink can accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedStreamCapacity(Integer reservedStreamCapacity);

        /**
         * <p>
         * The media stream sink's media stream type.
         * </p>
         * 
         * @param mediaStreamType
         *        The media stream sink's media stream type.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(String mediaStreamType);

        /**
         * <p>
         * The media stream sink's media stream type.
         * </p>
         * 
         * @param mediaStreamType
         *        The media stream sink's media stream type.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(MediaStreamType mediaStreamType);
    }

    static final class BuilderImpl implements Builder {
        private String sinkArn;

        private String sinkType;

        private Integer reservedStreamCapacity;

        private String mediaStreamType;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaStreamSink model) {
            sinkArn(model.sinkArn);
            sinkType(model.sinkType);
            reservedStreamCapacity(model.reservedStreamCapacity);
            mediaStreamType(model.mediaStreamType);
        }

        public final String getSinkArn() {
            return sinkArn;
        }

        public final void setSinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
        }

        @Override
        public final Builder sinkArn(String sinkArn) {
            this.sinkArn = sinkArn;
            return this;
        }

        public final String getSinkType() {
            return sinkType;
        }

        public final void setSinkType(String sinkType) {
            this.sinkType = sinkType;
        }

        @Override
        public final Builder sinkType(String sinkType) {
            this.sinkType = sinkType;
            return this;
        }

        @Override
        public final Builder sinkType(MediaStreamPipelineSinkType sinkType) {
            this.sinkType(sinkType == null ? null : sinkType.toString());
            return this;
        }

        public final Integer getReservedStreamCapacity() {
            return reservedStreamCapacity;
        }

        public final void setReservedStreamCapacity(Integer reservedStreamCapacity) {
            this.reservedStreamCapacity = reservedStreamCapacity;
        }

        @Override
        public final Builder reservedStreamCapacity(Integer reservedStreamCapacity) {
            this.reservedStreamCapacity = reservedStreamCapacity;
            return this;
        }

        public final String getMediaStreamType() {
            return mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        @Override
        public MediaStreamSink build() {
            return new MediaStreamSink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
