/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the words or phrases that trigger an alert.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeAlertRule implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeAlertRule.Builder, RealTimeAlertRule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(RealTimeAlertRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<KeywordMatchConfiguration> KEYWORD_MATCH_CONFIGURATION_FIELD = SdkField
            .<KeywordMatchConfiguration> builder(MarshallingType.SDK_POJO).memberName("KeywordMatchConfiguration")
            .getter(getter(RealTimeAlertRule::keywordMatchConfiguration)).setter(setter(Builder::keywordMatchConfiguration))
            .constructor(KeywordMatchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeywordMatchConfiguration").build())
            .build();

    private static final SdkField<SentimentConfiguration> SENTIMENT_CONFIGURATION_FIELD = SdkField
            .<SentimentConfiguration> builder(MarshallingType.SDK_POJO).memberName("SentimentConfiguration")
            .getter(getter(RealTimeAlertRule::sentimentConfiguration)).setter(setter(Builder::sentimentConfiguration))
            .constructor(SentimentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentConfiguration").build())
            .build();

    private static final SdkField<IssueDetectionConfiguration> ISSUE_DETECTION_CONFIGURATION_FIELD = SdkField
            .<IssueDetectionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IssueDetectionConfiguration")
            .getter(getter(RealTimeAlertRule::issueDetectionConfiguration))
            .setter(setter(Builder::issueDetectionConfiguration))
            .constructor(IssueDetectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetectionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            KEYWORD_MATCH_CONFIGURATION_FIELD, SENTIMENT_CONFIGURATION_FIELD, ISSUE_DETECTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final KeywordMatchConfiguration keywordMatchConfiguration;

    private final SentimentConfiguration sentimentConfiguration;

    private final IssueDetectionConfiguration issueDetectionConfiguration;

    private RealTimeAlertRule(BuilderImpl builder) {
        this.type = builder.type;
        this.keywordMatchConfiguration = builder.keywordMatchConfiguration;
        this.sentimentConfiguration = builder.sentimentConfiguration;
        this.issueDetectionConfiguration = builder.issueDetectionConfiguration;
    }

    /**
     * <p>
     * The type of alert rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RealTimeAlertRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of alert rule.
     * @see RealTimeAlertRuleType
     */
    public final RealTimeAlertRuleType type() {
        return RealTimeAlertRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of alert rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RealTimeAlertRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of alert rule.
     * @see RealTimeAlertRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the settings for matching the keywords in a real-time alert rule.
     * </p>
     * 
     * @return Specifies the settings for matching the keywords in a real-time alert rule.
     */
    public final KeywordMatchConfiguration keywordMatchConfiguration() {
        return keywordMatchConfiguration;
    }

    /**
     * <p>
     * Specifies the settings for predicting sentiment in a real-time alert rule.
     * </p>
     * 
     * @return Specifies the settings for predicting sentiment in a real-time alert rule.
     */
    public final SentimentConfiguration sentimentConfiguration() {
        return sentimentConfiguration;
    }

    /**
     * <p>
     * Specifies the issue detection settings for a real-time alert rule.
     * </p>
     * 
     * @return Specifies the issue detection settings for a real-time alert rule.
     */
    public final IssueDetectionConfiguration issueDetectionConfiguration() {
        return issueDetectionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keywordMatchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(issueDetectionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeAlertRule)) {
            return false;
        }
        RealTimeAlertRule other = (RealTimeAlertRule) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(keywordMatchConfiguration(), other.keywordMatchConfiguration())
                && Objects.equals(sentimentConfiguration(), other.sentimentConfiguration())
                && Objects.equals(issueDetectionConfiguration(), other.issueDetectionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeAlertRule").add("Type", typeAsString())
                .add("KeywordMatchConfiguration", keywordMatchConfiguration())
                .add("SentimentConfiguration", sentimentConfiguration())
                .add("IssueDetectionConfiguration", issueDetectionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "KeywordMatchConfiguration":
            return Optional.ofNullable(clazz.cast(keywordMatchConfiguration()));
        case "SentimentConfiguration":
            return Optional.ofNullable(clazz.cast(sentimentConfiguration()));
        case "IssueDetectionConfiguration":
            return Optional.ofNullable(clazz.cast(issueDetectionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("KeywordMatchConfiguration", KEYWORD_MATCH_CONFIGURATION_FIELD);
        map.put("SentimentConfiguration", SENTIMENT_CONFIGURATION_FIELD);
        map.put("IssueDetectionConfiguration", ISSUE_DETECTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeAlertRule, T> g) {
        return obj -> g.apply((RealTimeAlertRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeAlertRule> {
        /**
         * <p>
         * The type of alert rule.
         * </p>
         * 
         * @param type
         *        The type of alert rule.
         * @see RealTimeAlertRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeAlertRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of alert rule.
         * </p>
         * 
         * @param type
         *        The type of alert rule.
         * @see RealTimeAlertRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealTimeAlertRuleType
         */
        Builder type(RealTimeAlertRuleType type);

        /**
         * <p>
         * Specifies the settings for matching the keywords in a real-time alert rule.
         * </p>
         * 
         * @param keywordMatchConfiguration
         *        Specifies the settings for matching the keywords in a real-time alert rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keywordMatchConfiguration(KeywordMatchConfiguration keywordMatchConfiguration);

        /**
         * <p>
         * Specifies the settings for matching the keywords in a real-time alert rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeywordMatchConfiguration.Builder}
         * avoiding the need to create one manually via {@link KeywordMatchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeywordMatchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #keywordMatchConfiguration(KeywordMatchConfiguration)}.
         * 
         * @param keywordMatchConfiguration
         *        a consumer that will call methods on {@link KeywordMatchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keywordMatchConfiguration(KeywordMatchConfiguration)
         */
        default Builder keywordMatchConfiguration(Consumer<KeywordMatchConfiguration.Builder> keywordMatchConfiguration) {
            return keywordMatchConfiguration(KeywordMatchConfiguration.builder().applyMutation(keywordMatchConfiguration).build());
        }

        /**
         * <p>
         * Specifies the settings for predicting sentiment in a real-time alert rule.
         * </p>
         * 
         * @param sentimentConfiguration
         *        Specifies the settings for predicting sentiment in a real-time alert rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentConfiguration(SentimentConfiguration sentimentConfiguration);

        /**
         * <p>
         * Specifies the settings for predicting sentiment in a real-time alert rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link SentimentConfiguration.Builder} avoiding
         * the need to create one manually via {@link SentimentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SentimentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sentimentConfiguration(SentimentConfiguration)}.
         * 
         * @param sentimentConfiguration
         *        a consumer that will call methods on {@link SentimentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentConfiguration(SentimentConfiguration)
         */
        default Builder sentimentConfiguration(Consumer<SentimentConfiguration.Builder> sentimentConfiguration) {
            return sentimentConfiguration(SentimentConfiguration.builder().applyMutation(sentimentConfiguration).build());
        }

        /**
         * <p>
         * Specifies the issue detection settings for a real-time alert rule.
         * </p>
         * 
         * @param issueDetectionConfiguration
         *        Specifies the issue detection settings for a real-time alert rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issueDetectionConfiguration(IssueDetectionConfiguration issueDetectionConfiguration);

        /**
         * <p>
         * Specifies the issue detection settings for a real-time alert rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssueDetectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link IssueDetectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssueDetectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #issueDetectionConfiguration(IssueDetectionConfiguration)}.
         * 
         * @param issueDetectionConfiguration
         *        a consumer that will call methods on {@link IssueDetectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issueDetectionConfiguration(IssueDetectionConfiguration)
         */
        default Builder issueDetectionConfiguration(Consumer<IssueDetectionConfiguration.Builder> issueDetectionConfiguration) {
            return issueDetectionConfiguration(IssueDetectionConfiguration.builder().applyMutation(issueDetectionConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private KeywordMatchConfiguration keywordMatchConfiguration;

        private SentimentConfiguration sentimentConfiguration;

        private IssueDetectionConfiguration issueDetectionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeAlertRule model) {
            type(model.type);
            keywordMatchConfiguration(model.keywordMatchConfiguration);
            sentimentConfiguration(model.sentimentConfiguration);
            issueDetectionConfiguration(model.issueDetectionConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RealTimeAlertRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final KeywordMatchConfiguration.Builder getKeywordMatchConfiguration() {
            return keywordMatchConfiguration != null ? keywordMatchConfiguration.toBuilder() : null;
        }

        public final void setKeywordMatchConfiguration(KeywordMatchConfiguration.BuilderImpl keywordMatchConfiguration) {
            this.keywordMatchConfiguration = keywordMatchConfiguration != null ? keywordMatchConfiguration.build() : null;
        }

        @Override
        public final Builder keywordMatchConfiguration(KeywordMatchConfiguration keywordMatchConfiguration) {
            this.keywordMatchConfiguration = keywordMatchConfiguration;
            return this;
        }

        public final SentimentConfiguration.Builder getSentimentConfiguration() {
            return sentimentConfiguration != null ? sentimentConfiguration.toBuilder() : null;
        }

        public final void setSentimentConfiguration(SentimentConfiguration.BuilderImpl sentimentConfiguration) {
            this.sentimentConfiguration = sentimentConfiguration != null ? sentimentConfiguration.build() : null;
        }

        @Override
        public final Builder sentimentConfiguration(SentimentConfiguration sentimentConfiguration) {
            this.sentimentConfiguration = sentimentConfiguration;
            return this;
        }

        public final IssueDetectionConfiguration.Builder getIssueDetectionConfiguration() {
            return issueDetectionConfiguration != null ? issueDetectionConfiguration.toBuilder() : null;
        }

        public final void setIssueDetectionConfiguration(IssueDetectionConfiguration.BuilderImpl issueDetectionConfiguration) {
            this.issueDetectionConfiguration = issueDetectionConfiguration != null ? issueDetectionConfiguration.build() : null;
        }

        @Override
        public final Builder issueDetectionConfiguration(IssueDetectionConfiguration issueDetectionConfiguration) {
            this.issueDetectionConfiguration = issueDetectionConfiguration;
            return this;
        }

        @Override
        public RealTimeAlertRule build() {
            return new RealTimeAlertRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
