/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartVoiceToneAnalysisTaskRequest extends ChimeSdkMediaPipelinesRequest implements
        ToCopyableBuilder<StartVoiceToneAnalysisTaskRequest.Builder, StartVoiceToneAnalysisTaskRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(StartVoiceToneAnalysisTaskRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(StartVoiceToneAnalysisTaskRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<KinesisVideoStreamSourceTaskConfiguration> KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamSourceTaskConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisVideoStreamSourceTaskConfiguration")
            .getter(getter(StartVoiceToneAnalysisTaskRequest::kinesisVideoStreamSourceTaskConfiguration))
            .setter(setter(Builder::kinesisVideoStreamSourceTaskConfiguration))
            .constructor(KinesisVideoStreamSourceTaskConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KinesisVideoStreamSourceTaskConfiguration").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(StartVoiceToneAnalysisTaskRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            LANGUAGE_CODE_FIELD, KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String languageCode;

    private final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;

    private final String clientRequestToken;

    private StartVoiceToneAnalysisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.languageCode = builder.languageCode;
        this.kinesisVideoStreamSourceTaskConfiguration = builder.kinesisVideoStreamSourceTaskConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media insights
     * pipeline.
     * </p>
     * 
     * @return The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
     *         insights pipeline.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link VoiceAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code.
     * @see VoiceAnalyticsLanguageCode
     */
    public final VoiceAnalyticsLanguageCode languageCode() {
        return VoiceAnalyticsLanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link VoiceAnalyticsLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The language code.
     * @see VoiceAnalyticsLanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * The task configuration for the Kinesis video stream source of the media insights pipeline.
     * </p>
     * 
     * @return The task configuration for the Kinesis video stream source of the media insights pipeline.
     */
    public final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration() {
        return kinesisVideoStreamSourceTaskConfiguration;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different voice tone analysis tasks.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different voice tone analysis
     *         tasks.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamSourceTaskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVoiceToneAnalysisTaskRequest)) {
            return false;
        }
        StartVoiceToneAnalysisTaskRequest other = (StartVoiceToneAnalysisTaskRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(kinesisVideoStreamSourceTaskConfiguration(), other.kinesisVideoStreamSourceTaskConfiguration())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartVoiceToneAnalysisTaskRequest").add("Identifier", identifier())
                .add("LanguageCode", languageCodeAsString())
                .add("KinesisVideoStreamSourceTaskConfiguration", kinesisVideoStreamSourceTaskConfiguration())
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "KinesisVideoStreamSourceTaskConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamSourceTaskConfiguration()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("KinesisVideoStreamSourceTaskConfiguration", KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVoiceToneAnalysisTaskRequest, T> g) {
        return obj -> g.apply((StartVoiceToneAnalysisTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartVoiceToneAnalysisTaskRequest> {
        /**
         * <p>
         * The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         * insights pipeline.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the resource to be updated. Valid values include the ID and ARN of the media
         *        insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The language code.
         * </p>
         * 
         * @param languageCode
         *        The language code.
         * @see VoiceAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsLanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * The language code.
         * </p>
         * 
         * @param languageCode
         *        The language code.
         * @see VoiceAnalyticsLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceAnalyticsLanguageCode
         */
        Builder languageCode(VoiceAnalyticsLanguageCode languageCode);

        /**
         * <p>
         * The task configuration for the Kinesis video stream source of the media insights pipeline.
         * </p>
         * 
         * @param kinesisVideoStreamSourceTaskConfiguration
         *        The task configuration for the Kinesis video stream source of the media insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamSourceTaskConfiguration(
                KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration);

        /**
         * <p>
         * The task configuration for the Kinesis video stream source of the media insights pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisVideoStreamSourceTaskConfiguration.Builder} avoiding the need to create one manually via
         * {@link KinesisVideoStreamSourceTaskConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamSourceTaskConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration)}.
         * 
         * @param kinesisVideoStreamSourceTaskConfiguration
         *        a consumer that will call methods on {@link KinesisVideoStreamSourceTaskConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration)
         */
        default Builder kinesisVideoStreamSourceTaskConfiguration(
                Consumer<KinesisVideoStreamSourceTaskConfiguration.Builder> kinesisVideoStreamSourceTaskConfiguration) {
            return kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration.builder()
                    .applyMutation(kinesisVideoStreamSourceTaskConfiguration).build());
        }

        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different voice tone analysis tasks.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different voice tone analysis
         *        tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String identifier;

        private String languageCode;

        private KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVoiceToneAnalysisTaskRequest model) {
            super(model);
            identifier(model.identifier);
            languageCode(model.languageCode);
            kinesisVideoStreamSourceTaskConfiguration(model.kinesisVideoStreamSourceTaskConfiguration);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(VoiceAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final KinesisVideoStreamSourceTaskConfiguration.Builder getKinesisVideoStreamSourceTaskConfiguration() {
            return kinesisVideoStreamSourceTaskConfiguration != null ? kinesisVideoStreamSourceTaskConfiguration.toBuilder()
                    : null;
        }

        public final void setKinesisVideoStreamSourceTaskConfiguration(
                KinesisVideoStreamSourceTaskConfiguration.BuilderImpl kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration != null ? kinesisVideoStreamSourceTaskConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceTaskConfiguration(
                KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVoiceToneAnalysisTaskRequest build() {
            return new StartVoiceToneAnalysisTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
