/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMediaInsightsPipelineConfigurationRequest extends ChimeSdkMediaPipelinesRequest
        implements
        ToCopyableBuilder<UpdateMediaInsightsPipelineConfigurationRequest.Builder, UpdateMediaInsightsPipelineConfigurationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateMediaInsightsPipelineConfigurationRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceAccessRoleArn")
            .getter(getter(UpdateMediaInsightsPipelineConfigurationRequest::resourceAccessRoleArn))
            .setter(setter(Builder::resourceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build())
            .build();

    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField
            .<RealTimeAlertConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("RealTimeAlertConfiguration")
            .getter(getter(UpdateMediaInsightsPipelineConfigurationRequest::realTimeAlertConfiguration))
            .setter(setter(Builder::realTimeAlertConfiguration))
            .constructor(RealTimeAlertConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build())
            .build();

    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField
            .<List<MediaInsightsPipelineConfigurationElement>> builder(MarshallingType.LIST)
            .memberName("Elements")
            .getter(getter(UpdateMediaInsightsPipelineConfigurationRequest::elements))
            .setter(setter(Builder::elements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaInsightsPipelineConfigurationElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaInsightsPipelineConfigurationElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            RESOURCE_ACCESS_ROLE_ARN_FIELD, REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String resourceAccessRoleArn;

    private final RealTimeAlertConfiguration realTimeAlertConfiguration;

    private final List<MediaInsightsPipelineConfigurationElement> elements;

    private UpdateMediaInsightsPipelineConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
    }

    /**
     * <p>
     * The unique identifier for the resource to be updated. Valid values include the name and ARN of the media insights
     * pipeline configuration.
     * </p>
     * 
     * @return The unique identifier for the resource to be updated. Valid values include the name and ARN of the media
     *         insights pipeline configuration.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The ARN of the role used by the service to access Amazon Web Services resources.
     * </p>
     * 
     * @return The ARN of the role used by the service to access Amazon Web Services resources.
     */
    public final String resourceAccessRoleArn() {
        return resourceAccessRoleArn;
    }

    /**
     * <p>
     * The configuration settings for real-time alerts for the media insights pipeline.
     * </p>
     * 
     * @return The configuration settings for real-time alerts for the media insights pipeline.
     */
    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return realTimeAlertConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Elements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElements() {
        return elements != null && !(elements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElements} method.
     * </p>
     * 
     * @return The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
     *         Stream..
     */
    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return elements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasElements() ? elements() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaInsightsPipelineConfigurationRequest)) {
            return false;
        }
        UpdateMediaInsightsPipelineConfigurationRequest other = (UpdateMediaInsightsPipelineConfigurationRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(resourceAccessRoleArn(), other.resourceAccessRoleArn())
                && Objects.equals(realTimeAlertConfiguration(), other.realTimeAlertConfiguration())
                && hasElements() == other.hasElements() && Objects.equals(elements(), other.elements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMediaInsightsPipelineConfigurationRequest").add("Identifier", identifier())
                .add("ResourceAccessRoleArn", resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RealTimeAlertConfiguration", realTimeAlertConfiguration())
                .add("Elements", hasElements() ? elements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "ResourceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(resourceAccessRoleArn()));
        case "RealTimeAlertConfiguration":
            return Optional.ofNullable(clazz.cast(realTimeAlertConfiguration()));
        case "Elements":
            return Optional.ofNullable(clazz.cast(elements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("RealTimeAlertConfiguration", REAL_TIME_ALERT_CONFIGURATION_FIELD);
        map.put("Elements", ELEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaInsightsPipelineConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateMediaInsightsPipelineConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkMediaPipelinesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMediaInsightsPipelineConfigurationRequest> {
        /**
         * <p>
         * The unique identifier for the resource to be updated. Valid values include the name and ARN of the media
         * insights pipeline configuration.
         * </p>
         * 
         * @param identifier
         *        The unique identifier for the resource to be updated. Valid values include the name and ARN of the
         *        media insights pipeline configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The ARN of the role used by the service to access Amazon Web Services resources.
         * </p>
         * 
         * @param resourceAccessRoleArn
         *        The ARN of the role used by the service to access Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAccessRoleArn(String resourceAccessRoleArn);

        /**
         * <p>
         * The configuration settings for real-time alerts for the media insights pipeline.
         * </p>
         * 
         * @param realTimeAlertConfiguration
         *        The configuration settings for real-time alerts for the media insights pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration);

        /**
         * <p>
         * The configuration settings for real-time alerts for the media insights pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeAlertConfiguration.Builder}
         * avoiding the need to create one manually via {@link RealTimeAlertConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeAlertConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #realTimeAlertConfiguration(RealTimeAlertConfiguration)}.
         * 
         * @param realTimeAlertConfiguration
         *        a consumer that will call methods on {@link RealTimeAlertConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realTimeAlertConfiguration(RealTimeAlertConfiguration)
         */
        default Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return realTimeAlertConfiguration(RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)
                    .build());
        }

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream..
         * </p>
         * 
         * @param elements
         *        The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
         *        Stream..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements);

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream..
         * </p>
         * 
         * @param elements
         *        The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data
         *        Stream..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elements(MediaInsightsPipelineConfigurationElement... elements);

        /**
         * <p>
         * The elements in the request, such as a processor for Amazon Transcribe or a sink for a Kinesis Data Stream..
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elements(List<MediaInsightsPipelineConfigurationElement>)}.
         * 
         * @param elements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elements(java.util.Collection<MediaInsightsPipelineConfigurationElement>)
         */
        Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesRequest.BuilderImpl implements Builder {
        private String identifier;

        private String resourceAccessRoleArn;

        private RealTimeAlertConfiguration realTimeAlertConfiguration;

        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaInsightsPipelineConfigurationRequest model) {
            super(model);
            identifier(model.identifier);
            resourceAccessRoleArn(model.resourceAccessRoleArn);
            realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            elements(model.elements);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return realTimeAlertConfiguration != null ? realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier
                    .copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement... elements) {
            elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder>... elements) {
            elements(Stream.of(elements).map(c -> MediaInsightsPipelineConfigurationElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMediaInsightsPipelineConfigurationRequest build() {
            return new UpdateMediaInsightsPipelineConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
