/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMediaPipelineKinesisVideoStreamPoolResponse extends ChimeSdkMediaPipelinesResponse
        implements
        ToCopyableBuilder<UpdateMediaPipelineKinesisVideoStreamPoolResponse.Builder, UpdateMediaPipelineKinesisVideoStreamPoolResponse> {
    private static final SdkField<KinesisVideoStreamPoolConfiguration> KINESIS_VIDEO_STREAM_POOL_CONFIGURATION_FIELD = SdkField
            .<KinesisVideoStreamPoolConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisVideoStreamPoolConfiguration")
            .getter(getter(UpdateMediaPipelineKinesisVideoStreamPoolResponse::kinesisVideoStreamPoolConfiguration))
            .setter(setter(Builder::kinesisVideoStreamPoolConfiguration))
            .constructor(KinesisVideoStreamPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("KinesisVideoStreamPoolConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(KINESIS_VIDEO_STREAM_POOL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration;

    private UpdateMediaPipelineKinesisVideoStreamPoolResponse(BuilderImpl builder) {
        super(builder);
        this.kinesisVideoStreamPoolConfiguration = builder.kinesisVideoStreamPoolConfiguration;
    }

    /**
     * <p>
     * The video stream pool configuration object.
     * </p>
     * 
     * @return The video stream pool configuration object.
     */
    public final KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration() {
        return kinesisVideoStreamPoolConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamPoolConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMediaPipelineKinesisVideoStreamPoolResponse)) {
            return false;
        }
        UpdateMediaPipelineKinesisVideoStreamPoolResponse other = (UpdateMediaPipelineKinesisVideoStreamPoolResponse) obj;
        return Objects.equals(kinesisVideoStreamPoolConfiguration(), other.kinesisVideoStreamPoolConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMediaPipelineKinesisVideoStreamPoolResponse")
                .add("KinesisVideoStreamPoolConfiguration", kinesisVideoStreamPoolConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisVideoStreamPoolConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamPoolConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KinesisVideoStreamPoolConfiguration", KINESIS_VIDEO_STREAM_POOL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMediaPipelineKinesisVideoStreamPoolResponse, T> g) {
        return obj -> g.apply((UpdateMediaPipelineKinesisVideoStreamPoolResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeSdkMediaPipelinesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMediaPipelineKinesisVideoStreamPoolResponse> {
        /**
         * <p>
         * The video stream pool configuration object.
         * </p>
         * 
         * @param kinesisVideoStreamPoolConfiguration
         *        The video stream pool configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration);

        /**
         * <p>
         * The video stream pool configuration object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KinesisVideoStreamPoolConfiguration.Builder} avoiding the need to create one manually via
         * {@link KinesisVideoStreamPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamPoolConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration)}.
         * 
         * @param kinesisVideoStreamPoolConfiguration
         *        a consumer that will call methods on {@link KinesisVideoStreamPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration)
         */
        default Builder kinesisVideoStreamPoolConfiguration(
                Consumer<KinesisVideoStreamPoolConfiguration.Builder> kinesisVideoStreamPoolConfiguration) {
            return kinesisVideoStreamPoolConfiguration(KinesisVideoStreamPoolConfiguration.builder()
                    .applyMutation(kinesisVideoStreamPoolConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkMediaPipelinesResponse.BuilderImpl implements Builder {
        private KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMediaPipelineKinesisVideoStreamPoolResponse model) {
            super(model);
            kinesisVideoStreamPoolConfiguration(model.kinesisVideoStreamPoolConfiguration);
        }

        public final KinesisVideoStreamPoolConfiguration.Builder getKinesisVideoStreamPoolConfiguration() {
            return kinesisVideoStreamPoolConfiguration != null ? kinesisVideoStreamPoolConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamPoolConfiguration(
                KinesisVideoStreamPoolConfiguration.BuilderImpl kinesisVideoStreamPoolConfiguration) {
            this.kinesisVideoStreamPoolConfiguration = kinesisVideoStreamPoolConfiguration != null ? kinesisVideoStreamPoolConfiguration
                    .build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamPoolConfiguration(
                KinesisVideoStreamPoolConfiguration kinesisVideoStreamPoolConfiguration) {
            this.kinesisVideoStreamPoolConfiguration = kinesisVideoStreamPoolConfiguration;
            return this;
        }

        @Override
        public UpdateMediaPipelineKinesisVideoStreamPoolResponse build() {
            return new UpdateMediaPipelineKinesisVideoStreamPoolResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
