/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the configuration settings for a vertical layout.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerticalLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VerticalLayoutConfiguration.Builder, VerticalLayoutConfiguration> {
    private static final SdkField<String> TILE_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TileOrder").getter(getter(VerticalLayoutConfiguration::tileOrderAsString))
            .setter(setter(Builder::tileOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileOrder").build()).build();

    private static final SdkField<String> TILE_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TilePosition").getter(getter(VerticalLayoutConfiguration::tilePositionAsString))
            .setter(setter(Builder::tilePosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TilePosition").build()).build();

    private static final SdkField<Integer> TILE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TileCount").getter(getter(VerticalLayoutConfiguration::tileCount)).setter(setter(Builder::tileCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileCount").build()).build();

    private static final SdkField<String> TILE_ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TileAspectRatio").getter(getter(VerticalLayoutConfiguration::tileAspectRatio))
            .setter(setter(Builder::tileAspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TileAspectRatio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TILE_ORDER_FIELD,
            TILE_POSITION_FIELD, TILE_COUNT_FIELD, TILE_ASPECT_RATIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tileOrder;

    private final String tilePosition;

    private final Integer tileCount;

    private final String tileAspectRatio;

    private VerticalLayoutConfiguration(BuilderImpl builder) {
        this.tileOrder = builder.tileOrder;
        this.tilePosition = builder.tilePosition;
        this.tileCount = builder.tileCount;
        this.tileAspectRatio = builder.tileAspectRatio;
    }

    /**
     * <p>
     * Sets the automatic ordering of the video tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tileOrder} will
     * return {@link TileOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tileOrderAsString}.
     * </p>
     * 
     * @return Sets the automatic ordering of the video tiles.
     * @see TileOrder
     */
    public final TileOrder tileOrder() {
        return TileOrder.fromValue(tileOrder);
    }

    /**
     * <p>
     * Sets the automatic ordering of the video tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tileOrder} will
     * return {@link TileOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tileOrderAsString}.
     * </p>
     * 
     * @return Sets the automatic ordering of the video tiles.
     * @see TileOrder
     */
    public final String tileOrderAsString() {
        return tileOrder;
    }

    /**
     * <p>
     * Sets the position of vertical tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tilePosition} will
     * return {@link VerticalTilePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tilePositionAsString}.
     * </p>
     * 
     * @return Sets the position of vertical tiles.
     * @see VerticalTilePosition
     */
    public final VerticalTilePosition tilePosition() {
        return VerticalTilePosition.fromValue(tilePosition);
    }

    /**
     * <p>
     * Sets the position of vertical tiles.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tilePosition} will
     * return {@link VerticalTilePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tilePositionAsString}.
     * </p>
     * 
     * @return Sets the position of vertical tiles.
     * @see VerticalTilePosition
     */
    public final String tilePositionAsString() {
        return tilePosition;
    }

    /**
     * <p>
     * The maximum number of tiles to display.
     * </p>
     * 
     * @return The maximum number of tiles to display.
     */
    public final Integer tileCount() {
        return tileCount;
    }

    /**
     * <p>
     * Sets the aspect ratio of the video tiles, such as 16:9.
     * </p>
     * 
     * @return Sets the aspect ratio of the video tiles, such as 16:9.
     */
    public final String tileAspectRatio() {
        return tileAspectRatio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tileOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tilePositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tileCount());
        hashCode = 31 * hashCode + Objects.hashCode(tileAspectRatio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerticalLayoutConfiguration)) {
            return false;
        }
        VerticalLayoutConfiguration other = (VerticalLayoutConfiguration) obj;
        return Objects.equals(tileOrderAsString(), other.tileOrderAsString())
                && Objects.equals(tilePositionAsString(), other.tilePositionAsString())
                && Objects.equals(tileCount(), other.tileCount()) && Objects.equals(tileAspectRatio(), other.tileAspectRatio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerticalLayoutConfiguration").add("TileOrder", tileOrderAsString())
                .add("TilePosition", tilePositionAsString()).add("TileCount", tileCount())
                .add("TileAspectRatio", tileAspectRatio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TileOrder":
            return Optional.ofNullable(clazz.cast(tileOrderAsString()));
        case "TilePosition":
            return Optional.ofNullable(clazz.cast(tilePositionAsString()));
        case "TileCount":
            return Optional.ofNullable(clazz.cast(tileCount()));
        case "TileAspectRatio":
            return Optional.ofNullable(clazz.cast(tileAspectRatio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TileOrder", TILE_ORDER_FIELD);
        map.put("TilePosition", TILE_POSITION_FIELD);
        map.put("TileCount", TILE_COUNT_FIELD);
        map.put("TileAspectRatio", TILE_ASPECT_RATIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerticalLayoutConfiguration, T> g) {
        return obj -> g.apply((VerticalLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerticalLayoutConfiguration> {
        /**
         * <p>
         * Sets the automatic ordering of the video tiles.
         * </p>
         * 
         * @param tileOrder
         *        Sets the automatic ordering of the video tiles.
         * @see TileOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TileOrder
         */
        Builder tileOrder(String tileOrder);

        /**
         * <p>
         * Sets the automatic ordering of the video tiles.
         * </p>
         * 
         * @param tileOrder
         *        Sets the automatic ordering of the video tiles.
         * @see TileOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TileOrder
         */
        Builder tileOrder(TileOrder tileOrder);

        /**
         * <p>
         * Sets the position of vertical tiles.
         * </p>
         * 
         * @param tilePosition
         *        Sets the position of vertical tiles.
         * @see VerticalTilePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerticalTilePosition
         */
        Builder tilePosition(String tilePosition);

        /**
         * <p>
         * Sets the position of vertical tiles.
         * </p>
         * 
         * @param tilePosition
         *        Sets the position of vertical tiles.
         * @see VerticalTilePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerticalTilePosition
         */
        Builder tilePosition(VerticalTilePosition tilePosition);

        /**
         * <p>
         * The maximum number of tiles to display.
         * </p>
         * 
         * @param tileCount
         *        The maximum number of tiles to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileCount(Integer tileCount);

        /**
         * <p>
         * Sets the aspect ratio of the video tiles, such as 16:9.
         * </p>
         * 
         * @param tileAspectRatio
         *        Sets the aspect ratio of the video tiles, such as 16:9.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileAspectRatio(String tileAspectRatio);
    }

    static final class BuilderImpl implements Builder {
        private String tileOrder;

        private String tilePosition;

        private Integer tileCount;

        private String tileAspectRatio;

        private BuilderImpl() {
        }

        private BuilderImpl(VerticalLayoutConfiguration model) {
            tileOrder(model.tileOrder);
            tilePosition(model.tilePosition);
            tileCount(model.tileCount);
            tileAspectRatio(model.tileAspectRatio);
        }

        public final String getTileOrder() {
            return tileOrder;
        }

        public final void setTileOrder(String tileOrder) {
            this.tileOrder = tileOrder;
        }

        @Override
        public final Builder tileOrder(String tileOrder) {
            this.tileOrder = tileOrder;
            return this;
        }

        @Override
        public final Builder tileOrder(TileOrder tileOrder) {
            this.tileOrder(tileOrder == null ? null : tileOrder.toString());
            return this;
        }

        public final String getTilePosition() {
            return tilePosition;
        }

        public final void setTilePosition(String tilePosition) {
            this.tilePosition = tilePosition;
        }

        @Override
        public final Builder tilePosition(String tilePosition) {
            this.tilePosition = tilePosition;
            return this;
        }

        @Override
        public final Builder tilePosition(VerticalTilePosition tilePosition) {
            this.tilePosition(tilePosition == null ? null : tilePosition.toString());
            return this;
        }

        public final Integer getTileCount() {
            return tileCount;
        }

        public final void setTileCount(Integer tileCount) {
            this.tileCount = tileCount;
        }

        @Override
        public final Builder tileCount(Integer tileCount) {
            this.tileCount = tileCount;
            return this;
        }

        public final String getTileAspectRatio() {
            return tileAspectRatio;
        }

        public final void setTileAspectRatio(String tileAspectRatio) {
            this.tileAspectRatio = tileAspectRatio;
        }

        @Override
        public final Builder tileAspectRatio(String tileAspectRatio) {
            this.tileAspectRatio = tileAspectRatio;
            return this;
        }

        @Override
        public VerticalLayoutConfiguration build() {
            return new VerticalLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
