/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaPipelineTaskStatus {
    NOT_STARTED("NotStarted"),
    INITIALIZING("Initializing"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaPipelineTaskStatus> VALUE_MAP;
    private final String value;

    private MediaPipelineTaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaPipelineTaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaPipelineTaskStatus> knownValues() {
        EnumSet<MediaPipelineTaskStatus> knownValues = EnumSet.allOf(MediaPipelineTaskStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaPipelineTaskStatus.class, MediaPipelineTaskStatus::toString);
    }
}

