/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateAttendeeRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<BatchCreateAttendeeRequest.Builder, BatchCreateAttendeeRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(BatchCreateAttendeeRequest::meetingId)).setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()).build();

    private static final SdkField<List<CreateAttendeeRequestItem>> ATTENDEES_FIELD = SdkField
            .<List<CreateAttendeeRequestItem>> builder(MarshallingType.LIST)
            .memberName("Attendees")
            .getter(getter(BatchCreateAttendeeRequest::attendees))
            .setter(setter(Builder::attendees))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAttendeeRequestItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAttendeeRequestItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            ATTENDEES_FIELD));

    private final String meetingId;

    private final List<CreateAttendeeRequestItem> attendees;

    private BatchCreateAttendeeRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.attendees = builder.attendees;
    }

    /**
     * <p>
     * The Amazon Chime SDK ID of the meeting to which you're adding attendees.
     * </p>
     * 
     * @return The Amazon Chime SDK ID of the meeting to which you're adding attendees.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attendees property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttendees() {
        return attendees != null && !(attendees instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attendee information, including attendees' IDs and join tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttendees} method.
     * </p>
     * 
     * @return The attendee information, including attendees' IDs and join tokens.
     */
    public final List<CreateAttendeeRequestItem> attendees() {
        return attendees;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendees() ? attendees() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateAttendeeRequest)) {
            return false;
        }
        BatchCreateAttendeeRequest other = (BatchCreateAttendeeRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && hasAttendees() == other.hasAttendees()
                && Objects.equals(attendees(), other.attendees());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateAttendeeRequest").add("MeetingId", meetingId())
                .add("Attendees", hasAttendees() ? attendees() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "Attendees":
            return Optional.ofNullable(clazz.cast(attendees()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateAttendeeRequest, T> g) {
        return obj -> g.apply((BatchCreateAttendeeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchCreateAttendeeRequest> {
        /**
         * <p>
         * The Amazon Chime SDK ID of the meeting to which you're adding attendees.
         * </p>
         * 
         * @param meetingId
         *        The Amazon Chime SDK ID of the meeting to which you're adding attendees.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Collection<CreateAttendeeRequestItem> attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(CreateAttendeeRequestItem... attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreateAttendeeRequestItem>.Builder}
         * avoiding the need to create one manually via {@link List<CreateAttendeeRequestItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreateAttendeeRequestItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #attendees(List<CreateAttendeeRequestItem>)}.
         * 
         * @param attendees
         *        a consumer that will call methods on {@link List<CreateAttendeeRequestItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendees(List<CreateAttendeeRequestItem>)
         */
        Builder attendees(Consumer<CreateAttendeeRequestItem.Builder>... attendees);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String meetingId;

        private List<CreateAttendeeRequestItem> attendees = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateAttendeeRequest model) {
            super(model);
            meetingId(model.meetingId);
            attendees(model.attendees);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        @Transient
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final List<CreateAttendeeRequestItem.Builder> getAttendees() {
            List<CreateAttendeeRequestItem.Builder> result = CreateAttendeeRequestItemListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<CreateAttendeeRequestItem.BuilderImpl> attendees) {
            this.attendees = CreateAttendeeRequestItemListCopier.copyFromBuilder(attendees);
        }

        @Override
        @Transient
        public final Builder attendees(Collection<CreateAttendeeRequestItem> attendees) {
            this.attendees = CreateAttendeeRequestItemListCopier.copy(attendees);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(CreateAttendeeRequestItem... attendees) {
            attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attendees(Consumer<CreateAttendeeRequestItem.Builder>... attendees) {
            attendees(Stream.of(attendees).map(c -> CreateAttendeeRequestItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateAttendeeRequest build() {
            return new BatchCreateAttendeeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
