/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TranscribeRegion {
    US_EAST_2("us-east-2"),

    US_EAST_1("us-east-1"),

    US_WEST_2("us-west-2"),

    AP_NORTHEAST_2("ap-northeast-2"),

    AP_SOUTHEAST_2("ap-southeast-2"),

    AP_NORTHEAST_1("ap-northeast-1"),

    CA_CENTRAL_1("ca-central-1"),

    EU_CENTRAL_1("eu-central-1"),

    EU_WEST_1("eu-west-1"),

    EU_WEST_2("eu-west-2"),

    SA_EAST_1("sa-east-1"),

    AUTO("auto"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TranscribeRegion> VALUE_MAP = EnumUtils.uniqueIndex(TranscribeRegion.class,
            TranscribeRegion::toString);

    private final String value;

    private TranscribeRegion(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TranscribeRegion corresponding to the value
     */
    public static TranscribeRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TranscribeRegion}s
     */
    public static Set<TranscribeRegion> knownValues() {
        Set<TranscribeRegion> knownValues = EnumSet.allOf(TranscribeRegion.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
