/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAttendeeCapabilitiesRequest extends ChimeSdkMeetingsRequest implements
        ToCopyableBuilder<UpdateAttendeeCapabilitiesRequest.Builder, UpdateAttendeeCapabilitiesRequest> {
    private static final SdkField<String> MEETING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeetingId").getter(getter(UpdateAttendeeCapabilitiesRequest::meetingId))
            .setter(setter(Builder::meetingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MeetingId").build()).build();

    private static final SdkField<String> ATTENDEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttendeeId").getter(getter(UpdateAttendeeCapabilitiesRequest::attendeeId))
            .setter(setter(Builder::attendeeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AttendeeId").build()).build();

    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField
            .<AttendeeCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(UpdateAttendeeCapabilitiesRequest::capabilities)).setter(setter(Builder::capabilities))
            .constructor(AttendeeCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_ID_FIELD,
            ATTENDEE_ID_FIELD, CAPABILITIES_FIELD));

    private final String meetingId;

    private final String attendeeId;

    private final AttendeeCapabilities capabilities;

    private UpdateAttendeeCapabilitiesRequest(BuilderImpl builder) {
        super(builder);
        this.meetingId = builder.meetingId;
        this.attendeeId = builder.attendeeId;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The ID of the meeting associated with the update request.
     * </p>
     * 
     * @return The ID of the meeting associated with the update request.
     */
    public final String meetingId() {
        return meetingId;
    }

    /**
     * <p>
     * The ID of the attendee associated with the update request.
     * </p>
     * 
     * @return The ID of the attendee associated with the update request.
     */
    public final String attendeeId() {
        return attendeeId;
    }

    /**
     * <p>
     * The capabilities that you want to update.
     * </p>
     * 
     * @return The capabilities that you want to update.
     */
    public final AttendeeCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meetingId());
        hashCode = 31 * hashCode + Objects.hashCode(attendeeId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAttendeeCapabilitiesRequest)) {
            return false;
        }
        UpdateAttendeeCapabilitiesRequest other = (UpdateAttendeeCapabilitiesRequest) obj;
        return Objects.equals(meetingId(), other.meetingId()) && Objects.equals(attendeeId(), other.attendeeId())
                && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAttendeeCapabilitiesRequest").add("MeetingId", meetingId())
                .add("AttendeeId", attendeeId()).add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MeetingId":
            return Optional.ofNullable(clazz.cast(meetingId()));
        case "AttendeeId":
            return Optional.ofNullable(clazz.cast(attendeeId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAttendeeCapabilitiesRequest, T> g) {
        return obj -> g.apply((UpdateAttendeeCapabilitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAttendeeCapabilitiesRequest> {
        /**
         * <p>
         * The ID of the meeting associated with the update request.
         * </p>
         * 
         * @param meetingId
         *        The ID of the meeting associated with the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingId(String meetingId);

        /**
         * <p>
         * The ID of the attendee associated with the update request.
         * </p>
         * 
         * @param attendeeId
         *        The ID of the attendee associated with the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendeeId(String attendeeId);

        /**
         * <p>
         * The capabilities that you want to update.
         * </p>
         * 
         * @param capabilities
         *        The capabilities that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AttendeeCapabilities capabilities);

        /**
         * <p>
         * The capabilities that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttendeeCapabilities.Builder} avoiding
         * the need to create one manually via {@link AttendeeCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilities(AttendeeCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link AttendeeCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AttendeeCapabilities)
         */
        default Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return capabilities(AttendeeCapabilities.builder().applyMutation(capabilities).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsRequest.BuilderImpl implements Builder {
        private String meetingId;

        private String attendeeId;

        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAttendeeCapabilitiesRequest model) {
            super(model);
            meetingId(model.meetingId);
            attendeeId(model.attendeeId);
            capabilities(model.capabilities);
        }

        public final String getMeetingId() {
            return meetingId;
        }

        public final void setMeetingId(String meetingId) {
            this.meetingId = meetingId;
        }

        @Override
        public final Builder meetingId(String meetingId) {
            this.meetingId = meetingId;
            return this;
        }

        public final String getAttendeeId() {
            return attendeeId;
        }

        public final void setAttendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
        }

        @Override
        public final Builder attendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAttendeeCapabilitiesRequest build() {
            return new UpdateAttendeeCapabilitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
