/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The media capabilities of an attendee: audio, video, or content.
 * </p>
 * <note>
 * <p>
 * You use the capabilities with a set of values that control what the capabilities can do, such as
 * <code>SendReceive</code> data. For more information about those values, see .
 * </p>
 * </note>
 * <p>
 * When using capabilities, be aware of these corner cases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you also
 * set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don't set the
 * <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code. However, you
 * can set your <code>video</code> capability to receive and you set your <code>content</code> capability to not
 * receive.
 * </p>
 * </li>
 * <li>
 * <p>
 * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to <code>Send</code>
 * or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will flow from the attendee to
 * the other meeting participants.
 * </p>
 * </li>
 * <li>
 * <p>
 * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
 * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video or
 * content streams, remote attendees can receive those streams, but only after media renegotiation between the client
 * and the Amazon Chime back-end server.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttendeeCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<AttendeeCapabilities.Builder, AttendeeCapabilities> {
    private static final SdkField<String> AUDIO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Audio")
            .getter(getter(AttendeeCapabilities::audioAsString)).setter(setter(Builder::audio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<String> VIDEO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Video")
            .getter(getter(AttendeeCapabilities::videoAsString)).setter(setter(Builder::video))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(AttendeeCapabilities::contentAsString)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD,
            CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audio;

    private final String video;

    private final String content;

    private AttendeeCapabilities(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
    }

    /**
     * <p>
     * The audio capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audio} will return
     * {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #audioAsString}.
     * </p>
     * 
     * @return The audio capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final MediaCapabilities audio() {
        return MediaCapabilities.fromValue(audio);
    }

    /**
     * <p>
     * The audio capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audio} will return
     * {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #audioAsString}.
     * </p>
     * 
     * @return The audio capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final String audioAsString() {
        return audio;
    }

    /**
     * <p>
     * The video capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #video} will return
     * {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoAsString}.
     * </p>
     * 
     * @return The video capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final MediaCapabilities video() {
        return MediaCapabilities.fromValue(video);
    }

    /**
     * <p>
     * The video capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #video} will return
     * {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #videoAsString}.
     * </p>
     * 
     * @return The video capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final String videoAsString() {
        return video;
    }

    /**
     * <p>
     * The content capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #content} will
     * return {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentAsString}.
     * </p>
     * 
     * @return The content capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final MediaCapabilities content() {
        return MediaCapabilities.fromValue(content);
    }

    /**
     * <p>
     * The content capability assigned to an attendee.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #content} will
     * return {@link MediaCapabilities#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentAsString}.
     * </p>
     * 
     * @return The content capability assigned to an attendee.
     * @see MediaCapabilities
     */
    public final String contentAsString() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttendeeCapabilities)) {
            return false;
        }
        AttendeeCapabilities other = (AttendeeCapabilities) obj;
        return Objects.equals(audioAsString(), other.audioAsString()) && Objects.equals(videoAsString(), other.videoAsString())
                && Objects.equals(contentAsString(), other.contentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttendeeCapabilities").add("Audio", audioAsString()).add("Video", videoAsString())
                .add("Content", contentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audio":
            return Optional.ofNullable(clazz.cast(audioAsString()));
        case "Video":
            return Optional.ofNullable(clazz.cast(videoAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(contentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttendeeCapabilities, T> g) {
        return obj -> g.apply((AttendeeCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttendeeCapabilities> {
        /**
         * <p>
         * The audio capability assigned to an attendee.
         * </p>
         * 
         * @param audio
         *        The audio capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder audio(String audio);

        /**
         * <p>
         * The audio capability assigned to an attendee.
         * </p>
         * 
         * @param audio
         *        The audio capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder audio(MediaCapabilities audio);

        /**
         * <p>
         * The video capability assigned to an attendee.
         * </p>
         * 
         * @param video
         *        The video capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder video(String video);

        /**
         * <p>
         * The video capability assigned to an attendee.
         * </p>
         * 
         * @param video
         *        The video capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder video(MediaCapabilities video);

        /**
         * <p>
         * The content capability assigned to an attendee.
         * </p>
         * 
         * @param content
         *        The content capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder content(String content);

        /**
         * <p>
         * The content capability assigned to an attendee.
         * </p>
         * 
         * @param content
         *        The content capability assigned to an attendee.
         * @see MediaCapabilities
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaCapabilities
         */
        Builder content(MediaCapabilities content);
    }

    static final class BuilderImpl implements Builder {
        private String audio;

        private String video;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(AttendeeCapabilities model) {
            audio(model.audio);
            video(model.video);
            content(model.content);
        }

        public final String getAudio() {
            return audio;
        }

        public final void setAudio(String audio) {
            this.audio = audio;
        }

        @Override
        public final Builder audio(String audio) {
            this.audio = audio;
            return this;
        }

        @Override
        public final Builder audio(MediaCapabilities audio) {
            this.audio(audio == null ? null : audio.toString());
            return this;
        }

        public final String getVideo() {
            return video;
        }

        public final void setVideo(String video) {
            this.video = video;
        }

        @Override
        public final Builder video(String video) {
            this.video = video;
            return this;
        }

        @Override
        public final Builder video(MediaCapabilities video) {
            this.video(video == null ? null : video.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public final Builder content(MediaCapabilities content) {
            this.content(content == null ? null : content.toString());
            return this;
        }

        @Override
        public AttendeeCapabilities build() {
            return new AttendeeCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
