/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAttendeeRequestItem implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateAttendeeRequestItem.Builder, CreateAttendeeRequestItem> {
    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalUserId").getter(getter(CreateAttendeeRequestItem::externalUserId))
            .setter(setter(Builder::externalUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()).build();

    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField
            .<AttendeeCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(CreateAttendeeRequestItem::capabilities)).setter(setter(Builder::capabilities))
            .constructor(AttendeeCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_USER_ID_FIELD,
            CAPABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String externalUserId;

    private final AttendeeCapabilities capabilities;

    private CreateAttendeeRequestItem(BuilderImpl builder) {
        this.externalUserId = builder.externalUserId;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
     * builder application.
     * </p>
     * <p>
     * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     * </p>
     * <p>
     * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix. Case
     * insensitive.
     * </p>
     * 
     * @return The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by
     *         a builder application.</p>
     *         <p>
     *         Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     *         </p>
     *         <p>
     *         Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
     *         Case insensitive.
     */
    public final String externalUserId() {
        return externalUserId;
    }

    /**
     * <p>
     * A list of one or more capabilities.
     * </p>
     * 
     * @return A list of one or more capabilities.
     */
    public final AttendeeCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequestItem)) {
            return false;
        }
        CreateAttendeeRequestItem other = (CreateAttendeeRequestItem) obj;
        return Objects.equals(externalUserId(), other.externalUserId()) && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAttendeeRequestItem")
                .add("ExternalUserId", externalUserId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExternalUserId":
            return Optional.ofNullable(clazz.cast(externalUserId()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAttendeeRequestItem, T> g) {
        return obj -> g.apply((CreateAttendeeRequestItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateAttendeeRequestItem> {
        /**
         * <p>
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
         * builder application.
         * </p>
         * <p>
         * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         * </p>
         * <p>
         * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
         * Case insensitive.
         * </p>
         * 
         * @param externalUserId
         *        The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed
         *        by a builder application.</p>
         *        <p>
         *        Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         *        </p>
         *        <p>
         *        Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this
         *        prefix. Case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserId(String externalUserId);

        /**
         * <p>
         * A list of one or more capabilities.
         * </p>
         * 
         * @param capabilities
         *        A list of one or more capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AttendeeCapabilities capabilities);

        /**
         * <p>
         * A list of one or more capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttendeeCapabilities.Builder} avoiding
         * the need to create one manually via {@link AttendeeCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilities(AttendeeCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link AttendeeCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AttendeeCapabilities)
         */
        default Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return capabilities(AttendeeCapabilities.builder().applyMutation(capabilities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String externalUserId;

        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAttendeeRequestItem model) {
            externalUserId(model.externalUserId);
            capabilities(model.capabilities);
        }

        public final String getExternalUserId() {
            return externalUserId;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public CreateAttendeeRequestItem build() {
            return new CreateAttendeeRequestItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
