/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationsConfiguration> {
    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LambdaFunctionArn").getter(NotificationsConfiguration.getter(NotificationsConfiguration::lambdaFunctionArn)).setter(NotificationsConfiguration.setter(Builder::lambdaFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(NotificationsConfiguration.getter(NotificationsConfiguration::snsTopicArn)).setter(NotificationsConfiguration.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SQS_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SqsQueueArn").getter(NotificationsConfiguration.getter(NotificationsConfiguration::sqsQueueArn)).setter(NotificationsConfiguration.setter(Builder::sqsQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FUNCTION_ARN_FIELD, SNS_TOPIC_ARN_FIELD, SQS_QUEUE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lambdaFunctionArn;
    private final String snsTopicArn;
    private final String sqsQueueArn;

    private NotificationsConfiguration(BuilderImpl builder) {
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.sqsQueueArn = builder.sqsQueueArn;
    }

    public final String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String sqsQueueArn() {
        return this.sqsQueueArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationsConfiguration)) {
            return false;
        }
        NotificationsConfiguration other = (NotificationsConfiguration)obj;
        return Objects.equals(this.lambdaFunctionArn(), other.lambdaFunctionArn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.sqsQueueArn(), other.sqsQueueArn());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationsConfiguration").add("LambdaFunctionArn", (Object)(this.lambdaFunctionArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SnsTopicArn", (Object)(this.snsTopicArn() == null ? null : "*** Sensitive Data Redacted ***")).add("SqsQueueArn", (Object)(this.sqsQueueArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LambdaFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionArn()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SqsQueueArn": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationsConfiguration, T> g) {
        return obj -> g.apply((NotificationsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaFunctionArn;
        private String snsTopicArn;
        private String sqsQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationsConfiguration model) {
            this.lambdaFunctionArn(model.lambdaFunctionArn);
            this.snsTopicArn(model.snsTopicArn);
            this.sqsQueueArn(model.sqsQueueArn);
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSqsQueueArn() {
            return this.sqsQueueArn;
        }

        public final void setSqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
        }

        @Override
        public final Builder sqsQueueArn(String sqsQueueArn) {
            this.sqsQueueArn = sqsQueueArn;
            return this;
        }

        public NotificationsConfiguration build() {
            return new NotificationsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationsConfiguration> {
        public Builder lambdaFunctionArn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder sqsQueueArn(String var1);
    }
}

