/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the current transcription operation. Must contain <code>EngineTranscribeSettings</code> or
 * <code>EngineTranscribeMedicalSettings</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptionConfiguration.Builder, TranscriptionConfiguration> {
    private static final SdkField<EngineTranscribeSettings> ENGINE_TRANSCRIBE_SETTINGS_FIELD = SdkField
            .<EngineTranscribeSettings> builder(MarshallingType.SDK_POJO).memberName("EngineTranscribeSettings")
            .getter(getter(TranscriptionConfiguration::engineTranscribeSettings))
            .setter(setter(Builder::engineTranscribeSettings)).constructor(EngineTranscribeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineTranscribeSettings").build())
            .build();

    private static final SdkField<EngineTranscribeMedicalSettings> ENGINE_TRANSCRIBE_MEDICAL_SETTINGS_FIELD = SdkField
            .<EngineTranscribeMedicalSettings> builder(MarshallingType.SDK_POJO)
            .memberName("EngineTranscribeMedicalSettings")
            .getter(getter(TranscriptionConfiguration::engineTranscribeMedicalSettings))
            .setter(setter(Builder::engineTranscribeMedicalSettings))
            .constructor(EngineTranscribeMedicalSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineTranscribeMedicalSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENGINE_TRANSCRIBE_SETTINGS_FIELD, ENGINE_TRANSCRIBE_MEDICAL_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EngineTranscribeSettings engineTranscribeSettings;

    private final EngineTranscribeMedicalSettings engineTranscribeMedicalSettings;

    private TranscriptionConfiguration(BuilderImpl builder) {
        this.engineTranscribeSettings = builder.engineTranscribeSettings;
        this.engineTranscribeMedicalSettings = builder.engineTranscribeMedicalSettings;
    }

    /**
     * <p>
     * The transcription configuration settings passed to Amazon Transcribe.
     * </p>
     * 
     * @return The transcription configuration settings passed to Amazon Transcribe.
     */
    public final EngineTranscribeSettings engineTranscribeSettings() {
        return engineTranscribeSettings;
    }

    /**
     * <p>
     * The transcription configuration settings passed to Amazon Transcribe Medical.
     * </p>
     * 
     * @return The transcription configuration settings passed to Amazon Transcribe Medical.
     */
    public final EngineTranscribeMedicalSettings engineTranscribeMedicalSettings() {
        return engineTranscribeMedicalSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineTranscribeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(engineTranscribeMedicalSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionConfiguration)) {
            return false;
        }
        TranscriptionConfiguration other = (TranscriptionConfiguration) obj;
        return Objects.equals(engineTranscribeSettings(), other.engineTranscribeSettings())
                && Objects.equals(engineTranscribeMedicalSettings(), other.engineTranscribeMedicalSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptionConfiguration").add("EngineTranscribeSettings", engineTranscribeSettings())
                .add("EngineTranscribeMedicalSettings", engineTranscribeMedicalSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineTranscribeSettings":
            return Optional.ofNullable(clazz.cast(engineTranscribeSettings()));
        case "EngineTranscribeMedicalSettings":
            return Optional.ofNullable(clazz.cast(engineTranscribeMedicalSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionConfiguration, T> g) {
        return obj -> g.apply((TranscriptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptionConfiguration> {
        /**
         * <p>
         * The transcription configuration settings passed to Amazon Transcribe.
         * </p>
         * 
         * @param engineTranscribeSettings
         *        The transcription configuration settings passed to Amazon Transcribe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineTranscribeSettings(EngineTranscribeSettings engineTranscribeSettings);

        /**
         * <p>
         * The transcription configuration settings passed to Amazon Transcribe.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineTranscribeSettings.Builder}
         * avoiding the need to create one manually via {@link EngineTranscribeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineTranscribeSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #engineTranscribeSettings(EngineTranscribeSettings)}.
         * 
         * @param engineTranscribeSettings
         *        a consumer that will call methods on {@link EngineTranscribeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineTranscribeSettings(EngineTranscribeSettings)
         */
        default Builder engineTranscribeSettings(Consumer<EngineTranscribeSettings.Builder> engineTranscribeSettings) {
            return engineTranscribeSettings(EngineTranscribeSettings.builder().applyMutation(engineTranscribeSettings).build());
        }

        /**
         * <p>
         * The transcription configuration settings passed to Amazon Transcribe Medical.
         * </p>
         * 
         * @param engineTranscribeMedicalSettings
         *        The transcription configuration settings passed to Amazon Transcribe Medical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineTranscribeMedicalSettings(EngineTranscribeMedicalSettings engineTranscribeMedicalSettings);

        /**
         * <p>
         * The transcription configuration settings passed to Amazon Transcribe Medical.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngineTranscribeMedicalSettings.Builder}
         * avoiding the need to create one manually via {@link EngineTranscribeMedicalSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineTranscribeMedicalSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #engineTranscribeMedicalSettings(EngineTranscribeMedicalSettings)}.
         * 
         * @param engineTranscribeMedicalSettings
         *        a consumer that will call methods on {@link EngineTranscribeMedicalSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineTranscribeMedicalSettings(EngineTranscribeMedicalSettings)
         */
        default Builder engineTranscribeMedicalSettings(
                Consumer<EngineTranscribeMedicalSettings.Builder> engineTranscribeMedicalSettings) {
            return engineTranscribeMedicalSettings(EngineTranscribeMedicalSettings.builder()
                    .applyMutation(engineTranscribeMedicalSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EngineTranscribeSettings engineTranscribeSettings;

        private EngineTranscribeMedicalSettings engineTranscribeMedicalSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionConfiguration model) {
            engineTranscribeSettings(model.engineTranscribeSettings);
            engineTranscribeMedicalSettings(model.engineTranscribeMedicalSettings);
        }

        public final EngineTranscribeSettings.Builder getEngineTranscribeSettings() {
            return engineTranscribeSettings != null ? engineTranscribeSettings.toBuilder() : null;
        }

        public final void setEngineTranscribeSettings(EngineTranscribeSettings.BuilderImpl engineTranscribeSettings) {
            this.engineTranscribeSettings = engineTranscribeSettings != null ? engineTranscribeSettings.build() : null;
        }

        @Override
        public final Builder engineTranscribeSettings(EngineTranscribeSettings engineTranscribeSettings) {
            this.engineTranscribeSettings = engineTranscribeSettings;
            return this;
        }

        public final EngineTranscribeMedicalSettings.Builder getEngineTranscribeMedicalSettings() {
            return engineTranscribeMedicalSettings != null ? engineTranscribeMedicalSettings.toBuilder() : null;
        }

        public final void setEngineTranscribeMedicalSettings(
                EngineTranscribeMedicalSettings.BuilderImpl engineTranscribeMedicalSettings) {
            this.engineTranscribeMedicalSettings = engineTranscribeMedicalSettings != null ? engineTranscribeMedicalSettings
                    .build() : null;
        }

        @Override
        public final Builder engineTranscribeMedicalSettings(EngineTranscribeMedicalSettings engineTranscribeMedicalSettings) {
            this.engineTranscribeMedicalSettings = engineTranscribeMedicalSettings;
            return this;
        }

        @Override
        public TranscriptionConfiguration build() {
            return new TranscriptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
