/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Chime SDK meeting attendee. Includes a unique <code>AttendeeId</code> and <code>JoinToken</code>. The
 * <code>JoinToken</code> allows a client to authenticate and join as the specified attendee. The <code>JoinToken</code>
 * expires when the meeting ends, or when <a>DeleteAttendee</a> is called. After that, the attendee is unable to join
 * the meeting.
 * </p>
 * <p>
 * We recommend securely transferring each <code>JoinToken</code> from your server application to the client so that no
 * other client has access to the token except for the one authorized to represent the attendee.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attendee implements SdkPojo, Serializable, ToCopyableBuilder<Attendee.Builder, Attendee> {
    private static final SdkField<String> EXTERNAL_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExternalUserId").getter(getter(Attendee::externalUserId)).setter(setter(Builder::externalUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalUserId").build()).build();

    private static final SdkField<String> ATTENDEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttendeeId").getter(getter(Attendee::attendeeId)).setter(setter(Builder::attendeeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttendeeId").build()).build();

    private static final SdkField<String> JOIN_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinToken").getter(getter(Attendee::joinToken)).setter(setter(Builder::joinToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinToken").build()).build();

    private static final SdkField<AttendeeCapabilities> CAPABILITIES_FIELD = SdkField
            .<AttendeeCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(Attendee::capabilities)).setter(setter(Builder::capabilities))
            .constructor(AttendeeCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_USER_ID_FIELD,
            ATTENDEE_ID_FIELD, JOIN_TOKEN_FIELD, CAPABILITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String externalUserId;

    private final String attendeeId;

    private final String joinToken;

    private final AttendeeCapabilities capabilities;

    private Attendee(BuilderImpl builder) {
        this.externalUserId = builder.externalUserId;
        this.attendeeId = builder.attendeeId;
        this.joinToken = builder.joinToken;
        this.capabilities = builder.capabilities;
    }

    /**
     * <p>
     * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
     * builder application.
     * </p>
     * <p>
     * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     * </p>
     * <p>
     * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix. Case
     * insensitive.
     * </p>
     * 
     * @return The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by
     *         a builder application.</p>
     *         <p>
     *         Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
     *         </p>
     *         <p>
     *         Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
     *         Case insensitive.
     */
    public final String externalUserId() {
        return externalUserId;
    }

    /**
     * <p>
     * The Amazon Chime SDK attendee ID.
     * </p>
     * 
     * @return The Amazon Chime SDK attendee ID.
     */
    public final String attendeeId() {
        return attendeeId;
    }

    /**
     * <p>
     * The join token used by the Amazon Chime SDK attendee.
     * </p>
     * 
     * @return The join token used by the Amazon Chime SDK attendee.
     */
    public final String joinToken() {
        return joinToken;
    }

    /**
     * <p>
     * The capabilities assigned to an attendee: audio, video, or content.
     * </p>
     * <note>
     * <p>
     * You use the capabilities with a set of values that control what the capabilities can do, such as
     * <code>SendReceive</code> data. For more information about those values, see .
     * </p>
     * </note>
     * <p>
     * When using capabilities, be aware of these corner cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API requests
     * that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
     * <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API
     * requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
     * <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless you
     * also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you don't set
     * the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request status code.
     * However, you can set your <code>video</code> capability to receive and you set your <code>content</code>
     * capability to not receive.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
     * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
     * flow from the attendee to the other meeting participants.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
     * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their video
     * or content streams, remote attendees can receive those streams, but only after media renegotiation between the
     * client and the Amazon Chime back-end server.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The capabilities assigned to an attendee: audio, video, or content.</p> <note>
     *         <p>
     *         You use the capabilities with a set of values that control what the capabilities can do, such as
     *         <code>SendReceive</code> data. For more information about those values, see .
     *         </p>
     *         </note>
     *         <p>
     *         When using capabilities, be aware of these corner cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API
     *         requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
     *         <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API
     *         requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
     *         <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code>
     *         unless you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>.
     *         If you don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad
     *         Request status code. However, you can set your <code>video</code> capability to receive and you set your
     *         <code>content</code> capability to not receive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
     *         <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio
     *         will flow from the attendee to the other meeting participants.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
     *         <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on
     *         their video or content streams, remote attendees can receive those streams, but only after media
     *         renegotiation between the client and the Amazon Chime back-end server.
     *         </p>
     *         </li>
     */
    public final AttendeeCapabilities capabilities() {
        return capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(attendeeId());
        hashCode = 31 * hashCode + Objects.hashCode(joinToken());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attendee)) {
            return false;
        }
        Attendee other = (Attendee) obj;
        return Objects.equals(externalUserId(), other.externalUserId()) && Objects.equals(attendeeId(), other.attendeeId())
                && Objects.equals(joinToken(), other.joinToken()) && Objects.equals(capabilities(), other.capabilities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attendee")
                .add("ExternalUserId", externalUserId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttendeeId", attendeeId()).add("JoinToken", joinToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Capabilities", capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExternalUserId":
            return Optional.ofNullable(clazz.cast(externalUserId()));
        case "AttendeeId":
            return Optional.ofNullable(clazz.cast(attendeeId()));
        case "JoinToken":
            return Optional.ofNullable(clazz.cast(joinToken()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attendee, T> g) {
        return obj -> g.apply((Attendee) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attendee> {
        /**
         * <p>
         * The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed by a
         * builder application.
         * </p>
         * <p>
         * Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         * </p>
         * <p>
         * Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this prefix.
         * Case insensitive.
         * </p>
         * 
         * @param externalUserId
         *        The Amazon Chime SDK external user ID. An idempotency token. Links the attendee to an identity managed
         *        by a builder application.</p>
         *        <p>
         *        Pattern: <code>[-_&amp;@+=,(){}\[\]\/«».:|'"#a-zA-Z0-9À-ÿ\s]*</code>
         *        </p>
         *        <p>
         *        Values that begin with <code>aws:</code> are reserved. You can't configure a value that uses this
         *        prefix. Case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalUserId(String externalUserId);

        /**
         * <p>
         * The Amazon Chime SDK attendee ID.
         * </p>
         * 
         * @param attendeeId
         *        The Amazon Chime SDK attendee ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendeeId(String attendeeId);

        /**
         * <p>
         * The join token used by the Amazon Chime SDK attendee.
         * </p>
         * 
         * @param joinToken
         *        The join token used by the Amazon Chime SDK attendee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinToken(String joinToken);

        /**
         * <p>
         * The capabilities assigned to an attendee: audio, video, or content.
         * </p>
         * <note>
         * <p>
         * You use the capabilities with a set of values that control what the capabilities can do, such as
         * <code>SendReceive</code> data. For more information about those values, see .
         * </p>
         * </note>
         * <p>
         * When using capabilities, be aware of these corner cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API
         * requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         * <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API
         * requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         * <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless
         * you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you
         * don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request
         * status code. However, you can set your <code>video</code> capability to receive and you set your
         * <code>content</code> capability to not receive.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
         * flow from the attendee to the other meeting participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their
         * video or content streams, remote attendees can receive those streams, but only after media renegotiation
         * between the client and the Amazon Chime back-end server.
         * </p>
         * </li>
         * </ul>
         * 
         * @param capabilities
         *        The capabilities assigned to an attendee: audio, video, or content.</p> <note>
         *        <p>
         *        You use the capabilities with a set of values that control what the capabilities can do, such as
         *        <code>SendReceive</code> data. For more information about those values, see .
         *        </p>
         *        </note>
         *        <p>
         *        When using capabilities, be aware of these corner cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all
         *        API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         *        <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all
         *        API requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         *        <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code>
         *        unless you also set <code>video</code> capabilities to <code>SendReceive</code> or
         *        <code>Receive</code>. If you don't set the <code>video</code> capability to receive, the response will
         *        contain an HTTP 400 Bad Request status code. However, you can set your <code>video</code> capability
         *        to receive and you set your <code>content</code> capability to not receive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         *        <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted,
         *        audio will flow from the attendee to the other meeting participants.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         *        <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on
         *        their video or content streams, remote attendees can receive those streams, but only after media
         *        renegotiation between the client and the Amazon Chime back-end server.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(AttendeeCapabilities capabilities);

        /**
         * <p>
         * The capabilities assigned to an attendee: audio, video, or content.
         * </p>
         * <note>
         * <p>
         * You use the capabilities with a set of values that control what the capabilities can do, such as
         * <code>SendReceive</code> data. For more information about those values, see .
         * </p>
         * </note>
         * <p>
         * When using capabilities, be aware of these corner cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you specify <code>MeetingFeatures:Video:MaxResolution:None</code> when you create a meeting, all API
         * requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         * <code>AttendeeCapabilities:Video</code> will be rejected with <code>ValidationError 400</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify <code>MeetingFeatures:Content:MaxResolution:None</code> when you create a meeting, all API
         * requests that include <code>SendReceive</code>, <code>Send</code>, or <code>Receive</code> for
         * <code>AttendeeCapabilities:Content</code> will be rejected with <code>ValidationError 400</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can't set <code>content</code> capabilities to <code>SendReceive</code> or <code>Receive</code> unless
         * you also set <code>video</code> capabilities to <code>SendReceive</code> or <code>Receive</code>. If you
         * don't set the <code>video</code> capability to receive, the response will contain an HTTP 400 Bad Request
         * status code. However, you can set your <code>video</code> capability to receive and you set your
         * <code>content</code> capability to not receive.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change an <code>audio</code> capability from <code>None</code> or <code>Receive</code> to
         * <code>Send</code> or <code>SendReceive</code> , and if the attendee left their microphone unmuted, audio will
         * flow from the attendee to the other meeting participants.
         * </p>
         * </li>
         * <li>
         * <p>
         * When you change a <code>video</code> or <code>content</code> capability from <code>None</code> or
         * <code>Receive</code> to <code>Send</code> or <code>SendReceive</code> , and if the attendee turned on their
         * video or content streams, remote attendees can receive those streams, but only after media renegotiation
         * between the client and the Amazon Chime back-end server.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link AttendeeCapabilities.Builder} avoiding
         * the need to create one manually via {@link AttendeeCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #capabilities(AttendeeCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link AttendeeCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(AttendeeCapabilities)
         */
        default Builder capabilities(Consumer<AttendeeCapabilities.Builder> capabilities) {
            return capabilities(AttendeeCapabilities.builder().applyMutation(capabilities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String externalUserId;

        private String attendeeId;

        private String joinToken;

        private AttendeeCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(Attendee model) {
            externalUserId(model.externalUserId);
            attendeeId(model.attendeeId);
            joinToken(model.joinToken);
            capabilities(model.capabilities);
        }

        public final String getExternalUserId() {
            return externalUserId;
        }

        public final void setExternalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
        }

        @Override
        public final Builder externalUserId(String externalUserId) {
            this.externalUserId = externalUserId;
            return this;
        }

        public final String getAttendeeId() {
            return attendeeId;
        }

        public final void setAttendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
        }

        @Override
        public final Builder attendeeId(String attendeeId) {
            this.attendeeId = attendeeId;
            return this;
        }

        public final String getJoinToken() {
            return joinToken;
        }

        public final void setJoinToken(String joinToken) {
            this.joinToken = joinToken;
        }

        @Override
        public final Builder joinToken(String joinToken) {
            this.joinToken = joinToken;
            return this;
        }

        public final AttendeeCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(AttendeeCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(AttendeeCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        @Override
        public Attendee build() {
            return new Attendee(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
