/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingWithAttendeesResponse extends ChimeSdkMeetingsResponse implements
        ToCopyableBuilder<CreateMeetingWithAttendeesResponse.Builder, CreateMeetingWithAttendeesResponse> {
    private static final SdkField<Meeting> MEETING_FIELD = SdkField.<Meeting> builder(MarshallingType.SDK_POJO)
            .memberName("Meeting").getter(getter(CreateMeetingWithAttendeesResponse::meeting)).setter(setter(Builder::meeting))
            .constructor(Meeting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meeting").build()).build();

    private static final SdkField<List<Attendee>> ATTENDEES_FIELD = SdkField
            .<List<Attendee>> builder(MarshallingType.LIST)
            .memberName("Attendees")
            .getter(getter(CreateMeetingWithAttendeesResponse::attendees))
            .setter(setter(Builder::attendees))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendees").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attendee> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attendee::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CreateAttendeeError>> ERRORS_FIELD = SdkField
            .<List<CreateAttendeeError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(CreateMeetingWithAttendeesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreateAttendeeError> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreateAttendeeError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEETING_FIELD,
            ATTENDEES_FIELD, ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Meeting meeting;

    private final List<Attendee> attendees;

    private final List<CreateAttendeeError> errors;

    private CreateMeetingWithAttendeesResponse(BuilderImpl builder) {
        super(builder);
        this.meeting = builder.meeting;
        this.attendees = builder.attendees;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The meeting information, including the meeting ID and <code>MediaPlacement</code>.
     * </p>
     * 
     * @return The meeting information, including the meeting ID and <code>MediaPlacement</code>.
     */
    public final Meeting meeting() {
        return meeting;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attendees property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttendees() {
        return attendees != null && !(attendees instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attendee information, including attendees' IDs and join tokens.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttendees} method.
     * </p>
     * 
     * @return The attendee information, including attendees' IDs and join tokens.
     */
    public final List<Attendee> attendees() {
        return attendees;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If the action fails for one or more of the attendees in the request, a list of the attendees is returned, along
     * with error codes and error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
     *         along with error codes and error messages.
     */
    public final List<CreateAttendeeError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(meeting());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttendees() ? attendees() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingWithAttendeesResponse)) {
            return false;
        }
        CreateMeetingWithAttendeesResponse other = (CreateMeetingWithAttendeesResponse) obj;
        return Objects.equals(meeting(), other.meeting()) && hasAttendees() == other.hasAttendees()
                && Objects.equals(attendees(), other.attendees()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMeetingWithAttendeesResponse").add("Meeting", meeting())
                .add("Attendees", hasAttendees() ? attendees() : null).add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Meeting":
            return Optional.ofNullable(clazz.cast(meeting()));
        case "Attendees":
            return Optional.ofNullable(clazz.cast(attendees()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Meeting", MEETING_FIELD);
        map.put("Attendees", ATTENDEES_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingWithAttendeesResponse, T> g) {
        return obj -> g.apply((CreateMeetingWithAttendeesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMeetingsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMeetingWithAttendeesResponse> {
        /**
         * <p>
         * The meeting information, including the meeting ID and <code>MediaPlacement</code>.
         * </p>
         * 
         * @param meeting
         *        The meeting information, including the meeting ID and <code>MediaPlacement</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meeting(Meeting meeting);

        /**
         * <p>
         * The meeting information, including the meeting ID and <code>MediaPlacement</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Meeting.Builder} avoiding the need to
         * create one manually via {@link Meeting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Meeting.Builder#build()} is called immediately and its result is
         * passed to {@link #meeting(Meeting)}.
         * 
         * @param meeting
         *        a consumer that will call methods on {@link Meeting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meeting(Meeting)
         */
        default Builder meeting(Consumer<Meeting.Builder> meeting) {
            return meeting(Meeting.builder().applyMutation(meeting).build());
        }

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Collection<Attendee> attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * 
         * @param attendees
         *        The attendee information, including attendees' IDs and join tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendees(Attendee... attendees);

        /**
         * <p>
         * The attendee information, including attendees' IDs and join tokens.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.Attendee.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.chimesdkmeetings.model.Attendee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.Attendee.Builder#build()} is called immediately
         * and its result is passed to {@link #attendees(List<Attendee>)}.
         * 
         * @param attendees
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmeetings.model.Attendee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendees(java.util.Collection<Attendee>)
         */
        Builder attendees(Consumer<Attendee.Builder>... attendees);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * 
         * @param errors
         *        If the action fails for one or more of the attendees in the request, a list of the attendees is
         *        returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<CreateAttendeeError> errors);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * 
         * @param errors
         *        If the action fails for one or more of the attendees in the request, a list of the attendees is
         *        returned, along with error codes and error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(CreateAttendeeError... errors);

        /**
         * <p>
         * If the action fails for one or more of the attendees in the request, a list of the attendees is returned,
         * along with error codes and error messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<CreateAttendeeError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkmeetings.model.CreateAttendeeError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<CreateAttendeeError>)
         */
        Builder errors(Consumer<CreateAttendeeError.Builder>... errors);
    }

    static final class BuilderImpl extends ChimeSdkMeetingsResponse.BuilderImpl implements Builder {
        private Meeting meeting;

        private List<Attendee> attendees = DefaultSdkAutoConstructList.getInstance();

        private List<CreateAttendeeError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingWithAttendeesResponse model) {
            super(model);
            meeting(model.meeting);
            attendees(model.attendees);
            errors(model.errors);
        }

        public final Meeting.Builder getMeeting() {
            return meeting != null ? meeting.toBuilder() : null;
        }

        public final void setMeeting(Meeting.BuilderImpl meeting) {
            this.meeting = meeting != null ? meeting.build() : null;
        }

        @Override
        public final Builder meeting(Meeting meeting) {
            this.meeting = meeting;
            return this;
        }

        public final List<Attendee.Builder> getAttendees() {
            List<Attendee.Builder> result = AttendeeListCopier.copyToBuilder(this.attendees);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttendees(Collection<Attendee.BuilderImpl> attendees) {
            this.attendees = AttendeeListCopier.copyFromBuilder(attendees);
        }

        @Override
        public final Builder attendees(Collection<Attendee> attendees) {
            this.attendees = AttendeeListCopier.copy(attendees);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Attendee... attendees) {
            attendees(Arrays.asList(attendees));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attendees(Consumer<Attendee.Builder>... attendees) {
            attendees(Stream.of(attendees).map(c -> Attendee.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateAttendeeError.Builder> getErrors() {
            List<CreateAttendeeError.Builder> result = BatchCreateAttendeeErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CreateAttendeeError.BuilderImpl> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CreateAttendeeError> errors) {
            this.errors = BatchCreateAttendeeErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CreateAttendeeError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CreateAttendeeError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> CreateAttendeeError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateMeetingWithAttendeesResponse build() {
            return new CreateMeetingWithAttendeesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
