/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmeetings.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration settings of the features available to a meeting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeetingFeaturesConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MeetingFeaturesConfiguration.Builder, MeetingFeaturesConfiguration> {
    private static final SdkField<AudioFeatures> AUDIO_FIELD = SdkField.<AudioFeatures> builder(MarshallingType.SDK_POJO)
            .memberName("Audio").getter(getter(MeetingFeaturesConfiguration::audio)).setter(setter(Builder::audio))
            .constructor(AudioFeatures::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<VideoFeatures> VIDEO_FIELD = SdkField.<VideoFeatures> builder(MarshallingType.SDK_POJO)
            .memberName("Video").getter(getter(MeetingFeaturesConfiguration::video)).setter(setter(Builder::video))
            .constructor(VideoFeatures::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<ContentFeatures> CONTENT_FIELD = SdkField.<ContentFeatures> builder(MarshallingType.SDK_POJO)
            .memberName("Content").getter(getter(MeetingFeaturesConfiguration::content)).setter(setter(Builder::content))
            .constructor(ContentFeatures::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<AttendeeFeatures> ATTENDEE_FIELD = SdkField
            .<AttendeeFeatures> builder(MarshallingType.SDK_POJO).memberName("Attendee")
            .getter(getter(MeetingFeaturesConfiguration::attendee)).setter(setter(Builder::attendee))
            .constructor(AttendeeFeatures::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendee").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_FIELD, VIDEO_FIELD,
            CONTENT_FIELD, ATTENDEE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioFeatures audio;

    private final VideoFeatures video;

    private final ContentFeatures content;

    private final AttendeeFeatures attendee;

    private MeetingFeaturesConfiguration(BuilderImpl builder) {
        this.audio = builder.audio;
        this.video = builder.video;
        this.content = builder.content;
        this.attendee = builder.attendee;
    }

    /**
     * <p>
     * The configuration settings for the audio features available to a meeting.
     * </p>
     * 
     * @return The configuration settings for the audio features available to a meeting.
     */
    public final AudioFeatures audio() {
        return audio;
    }

    /**
     * <p>
     * The configuration settings for the video features available to a meeting.
     * </p>
     * 
     * @return The configuration settings for the video features available to a meeting.
     */
    public final VideoFeatures video() {
        return video;
    }

    /**
     * <p>
     * The configuration settings for the content features available to a meeting.
     * </p>
     * 
     * @return The configuration settings for the content features available to a meeting.
     */
    public final ContentFeatures content() {
        return content;
    }

    /**
     * <p>
     * The configuration settings for the attendee features available to a meeting.
     * </p>
     * 
     * @return The configuration settings for the attendee features available to a meeting.
     */
    public final AttendeeFeatures attendee() {
        return attendee;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(attendee());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeetingFeaturesConfiguration)) {
            return false;
        }
        MeetingFeaturesConfiguration other = (MeetingFeaturesConfiguration) obj;
        return Objects.equals(audio(), other.audio()) && Objects.equals(video(), other.video())
                && Objects.equals(content(), other.content()) && Objects.equals(attendee(), other.attendee());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeetingFeaturesConfiguration").add("Audio", audio()).add("Video", video())
                .add("Content", content()).add("Attendee", attendee()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Attendee":
            return Optional.ofNullable(clazz.cast(attendee()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Audio", AUDIO_FIELD);
        map.put("Video", VIDEO_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Attendee", ATTENDEE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MeetingFeaturesConfiguration, T> g) {
        return obj -> g.apply((MeetingFeaturesConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeetingFeaturesConfiguration> {
        /**
         * <p>
         * The configuration settings for the audio features available to a meeting.
         * </p>
         * 
         * @param audio
         *        The configuration settings for the audio features available to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioFeatures audio);

        /**
         * <p>
         * The configuration settings for the audio features available to a meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioFeatures.Builder} avoiding the need
         * to create one manually via {@link AudioFeatures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioFeatures.Builder#build()} is called immediately and its
         * result is passed to {@link #audio(AudioFeatures)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioFeatures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioFeatures)
         */
        default Builder audio(Consumer<AudioFeatures.Builder> audio) {
            return audio(AudioFeatures.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * The configuration settings for the video features available to a meeting.
         * </p>
         * 
         * @param video
         *        The configuration settings for the video features available to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoFeatures video);

        /**
         * <p>
         * The configuration settings for the video features available to a meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoFeatures.Builder} avoiding the need
         * to create one manually via {@link VideoFeatures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoFeatures.Builder#build()} is called immediately and its
         * result is passed to {@link #video(VideoFeatures)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoFeatures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoFeatures)
         */
        default Builder video(Consumer<VideoFeatures.Builder> video) {
            return video(VideoFeatures.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * The configuration settings for the content features available to a meeting.
         * </p>
         * 
         * @param content
         *        The configuration settings for the content features available to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(ContentFeatures content);

        /**
         * <p>
         * The configuration settings for the content features available to a meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentFeatures.Builder} avoiding the
         * need to create one manually via {@link ContentFeatures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentFeatures.Builder#build()} is called immediately and its
         * result is passed to {@link #content(ContentFeatures)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link ContentFeatures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(ContentFeatures)
         */
        default Builder content(Consumer<ContentFeatures.Builder> content) {
            return content(ContentFeatures.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The configuration settings for the attendee features available to a meeting.
         * </p>
         * 
         * @param attendee
         *        The configuration settings for the attendee features available to a meeting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendee(AttendeeFeatures attendee);

        /**
         * <p>
         * The configuration settings for the attendee features available to a meeting.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttendeeFeatures.Builder} avoiding the
         * need to create one manually via {@link AttendeeFeatures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttendeeFeatures.Builder#build()} is called immediately and its
         * result is passed to {@link #attendee(AttendeeFeatures)}.
         * 
         * @param attendee
         *        a consumer that will call methods on {@link AttendeeFeatures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendee(AttendeeFeatures)
         */
        default Builder attendee(Consumer<AttendeeFeatures.Builder> attendee) {
            return attendee(AttendeeFeatures.builder().applyMutation(attendee).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioFeatures audio;

        private VideoFeatures video;

        private ContentFeatures content;

        private AttendeeFeatures attendee;

        private BuilderImpl() {
        }

        private BuilderImpl(MeetingFeaturesConfiguration model) {
            audio(model.audio);
            video(model.video);
            content(model.content);
            attendee(model.attendee);
        }

        public final AudioFeatures.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        public final void setAudio(AudioFeatures.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioFeatures audio) {
            this.audio = audio;
            return this;
        }

        public final VideoFeatures.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoFeatures.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoFeatures video) {
            this.video = video;
            return this;
        }

        public final ContentFeatures.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(ContentFeatures.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(ContentFeatures content) {
            this.content = content;
            return this;
        }

        public final AttendeeFeatures.Builder getAttendee() {
            return attendee != null ? attendee.toBuilder() : null;
        }

        public final void setAttendee(AttendeeFeatures.BuilderImpl attendee) {
            this.attendee = attendee != null ? attendee.build() : null;
        }

        @Override
        public final Builder attendee(AttendeeFeatures attendee) {
            this.attendee = attendee;
            return this;
        }

        @Override
        public MeetingFeaturesConfiguration build() {
            return new MeetingFeaturesConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
